/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilesProcessorWithNotificationImpl;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.IgnoredFileContentProvider;
import com.intellij.openapi.vcs.changes.IgnoredFileDescriptor;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.openapi.vcs.changes.VcsIgnoreManager;
import com.intellij.openapi.vcs.changes.ignore.IgnoreFilesProcessorImpl;
import com.intellij.openapi.vcs.changes.ignore.IgnoreFilesProcessorImplKt;
import com.intellij.openapi.vcs.changes.ignore.psi.util.IgnoreFileUtilKt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.project.ProjectKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.vfs.AsyncVfsEventsListener;
import com.intellij.vfs.AsyncVfsEventsPostProcessor;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001OB\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010'\u001a\u00020(H\u0016J\u0016\u0010)\u001a\u00020(2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001f0+H\u0016J\u001c\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001f0-2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001f0+H\u0016J\u0016\u0010.\u001a\u00020(2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002000-H\u0016J\"\u00101\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u001fH\u0002J\u0012\u00105\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0012\u00106\u001a\u0004\u0018\u0001072\u0006\u00108\u001a\u000200H\u0002J\u0006\u00109\u001a\u00020(J\u001e\u0010:\u001a\u00020;2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u001f0=2\u0006\u0010>\u001a\u00020\u001fH\u0002J\b\u0010?\u001a\u00020;H\u0014J\b\u0010@\u001a\u00020;H\u0002J\b\u0010A\u001a\u00020\u000eH\u0016J\b\u0010B\u001a\u00020\u000eH\u0016J\b\u0010C\u001a\u00020(H\u0014J\u001c\u0010D\u001a\b\u0012\u0004\u0012\u00020\u001f0-2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001f0-H\u0002J\u0010\u0010E\u001a\u00020(2\u0006\u0010F\u001a\u00020;H\u0016J\u001e\u0010G\u001a\u00020(2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u001f0+H\u0002J\u001a\u0010I\u001a\u00020J*\b\u0012\u0004\u0012\u00020J0K2\u0006\u0010L\u001a\u00020\u000eH\u0002J\u0014\u0010M\u001a\u00020;*\u00020\u001f2\u0006\u0010N\u001a\u00020\u001fH\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0014\u0010\u0015\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0014\u0010\u0017\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0010R\u0014\u0010\u0019\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0010R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\n \"*\u0004\u0018\u00010!0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0010R\u0014\u0010%\u001a\u00020\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0010\u00a8\u0006P"}, d2={"Lcom/intellij/openapi/vcs/changes/ignore/IgnoreFilesProcessorImpl;", "Lcom/intellij/openapi/vcs/FilesProcessorWithNotificationImpl;", "Lcom/intellij/vfs/AsyncVfsEventsListener;", "Lcom/intellij/openapi/vcs/changes/ChangeListListener;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/vcs/AbstractVcs;)V", "UNPROCESSED_FILES_LOCK", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "askedBeforeProperty", "", "getAskedBeforeProperty", "()Ljava/lang/String;", "doForCurrentProjectProperty", "getDoForCurrentProjectProperty", "forAllProjectsActionText", "getForAllProjectsActionText", "forCurrentProjectActionText", "getForCurrentProjectActionText", "muteActionText", "getMuteActionText", "notificationDisplayId", "getNotificationDisplayId", "showActionText", "getShowActionText", "unprocessedFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "vcsIgnoreManager", "Lcom/intellij/openapi/vcs/changes/VcsIgnoreManager;", "kotlin.jvm.PlatformType", "viewFilesDialogOkActionName", "getViewFilesDialogOkActionName", "viewFilesDialogTitle", "getViewFilesDialogTitle", "dispose", "", "doActionOnChosenFiles", "files", "", "doFilterFiles", "", "filesChanged", "events", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "findOrCreateIgnoreFileByFile", "ignoredContentProvider", "Lcom/intellij/openapi/vcs/changes/IgnoredFileContentProvider;", "file", "findStoreDir", "getAffectedFilePath", "Lcom/intellij/openapi/vcs/FilePath;", "event", "install", "isUnder", "", "parents", "", "child", "needDoForCurrentProject", "needProcessIgnoredFiles", "notificationMessage", "notificationTitle", "rememberForAllProjects", "silentlyIgnoreFilesInsideConfigDir", "unchangedFileStatusChanged", "upToDate", "writeIgnores", "potentiallyIgnoredFiles", "getOrInitialize", "Lcom/intellij/openapi/vcs/changes/ignore/IgnoreFilesProcessorImpl$IgnoreGroupContent;", "", "group", "underProjectStoreDir", "storeDir", "IgnoreGroupContent", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nIgnoreFilesProcessorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IgnoreFilesProcessorImpl.kt\ncom/intellij/openapi/vcs/changes/ignore/IgnoreFilesProcessorImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,240:1\n766#2:241\n857#2,2:242\n766#2:250\n857#2,2:251\n766#2:256\n857#2,2:257\n8406#3,2:244\n9088#3,4:246\n37#4,2:253\n1#5:255\n1247#6,2:259\n*S KotlinDebug\n*F\n+ 1 IgnoreFilesProcessorImpl.kt\ncom/intellij/openapi/vcs/changes/ignore/IgnoreFilesProcessorImpl\n*L\n71#1:241\n71#1:242,2\n127#1:250\n127#1:251,2\n188#1:256\n188#1:257,2\n120#1:244,2\n120#1:246,4\n143#1:253,2\n215#1:259,2\n*E\n"})
public final class IgnoreFilesProcessorImpl
extends FilesProcessorWithNotificationImpl
implements AsyncVfsEventsListener,
ChangeListListener {
    @NotNull
    private final Disposable parentDisposable;
    @NotNull
    private final AbstractVcs vcs;
    @NotNull
    private final ReentrantReadWriteLock UNPROCESSED_FILES_LOCK;
    @NotNull
    private final Set<VirtualFile> unprocessedFiles;
    private final VcsIgnoreManager vcsIgnoreManager;
    @NotNull
    private final String notificationDisplayId;
    @NotNull
    private final String askedBeforeProperty;
    @NotNull
    private final String doForCurrentProjectProperty;
    @NotNull
    private final String showActionText;
    @NotNull
    private final String forCurrentProjectActionText;
    @NotNull
    private final String forAllProjectsActionText;
    @NotNull
    private final String muteActionText;
    @NotNull
    private final String viewFilesDialogTitle;
    @NotNull
    private final String viewFilesDialogOkActionName;

    public IgnoreFilesProcessorImpl(@NotNull Project project2, @NotNull Disposable parentDisposable, @NotNull AbstractVcs vcs) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)vcs, (String)"vcs");
        super(project2, parentDisposable);
        this.parentDisposable = parentDisposable;
        this.vcs = vcs;
        this.UNPROCESSED_FILES_LOCK = new ReentrantReadWriteLock();
        this.unprocessedFiles = new LinkedHashSet();
        this.vcsIgnoreManager = VcsIgnoreManager.getInstance(project2);
        this.notificationDisplayId = "manage.ignore.files.notification";
        this.askedBeforeProperty = "ASKED_MANAGE_IGNORE_FILES";
        this.doForCurrentProjectProperty = "MANAGE_IGNORE_FILES";
        String string2 = VcsBundle.message("ignored.file.manage.view", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        this.showActionText = string2;
        String string3 = VcsBundle.message("ignored.file.manage.this.project", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        this.forCurrentProjectActionText = string3;
        String string4 = VcsBundle.message("ignored.file.manage.all.project", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        this.forAllProjectsActionText = string4;
        String string5 = VcsBundle.message("ignored.file.manage.notmanage", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        this.muteActionText = string5;
        String string6 = VcsBundle.message("ignored.file.manage.view.dialog.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
        this.viewFilesDialogTitle = string6;
        String string7 = VcsBundle.message("ignored.file.manage.view.dialog.ignore.action", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(...)");
        this.viewFilesDialogOkActionName = string7;
    }

    public final void install() {
        ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ IgnoreFilesProcessorImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (!IgnoreFilesProcessorImpl.access$getProject(this.this$0).isDisposed()) {
                    MessageBusConnection messageBusConnection = IgnoreFilesProcessorImpl.access$getProject(this.this$0).getMessageBus().connect(IgnoreFilesProcessorImpl.access$getParentDisposable$p(this.this$0));
                    Topic<ChangeListListener> topic = ChangeListListener.TOPIC;
                    Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
                    messageBusConnection.subscribe(topic, (Object)this.this$0);
                    AsyncVfsEventsPostProcessor.getInstance().addListener(this.this$0, IgnoreFilesProcessorImpl.access$getParentDisposable$p(this.this$0));
                }
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unchangedFileStatusChanged(boolean upToDate) {
        if (!upToDate) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        List files2 = null;
        ReentrantReadWriteLock reentrantReadWriteLock = this.UNPROCESSED_FILES_LOCK;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            files2 = CollectionsKt.toList((Iterable)this.unprocessedFiles);
            this.unprocessedFiles.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        if (files2.isEmpty()) {
            return;
        }
        List<VirtualFile> restFiles = this.silentlyIgnoreFilesInsideConfigDir(files2);
        if (this.needProcessIgnoredFiles() && !((Collection)restFiles).isEmpty()) {
            this.processFiles((Collection<? extends VirtualFile>)restFiles);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<VirtualFile> silentlyIgnoreFilesInsideConfigDir(List<? extends VirtualFile> files2) {
        void $this$filterTo$iv$iv;
        Path path2 = ProjectKt.getStateStore((Project)this.getProject()).getDirectoryStorePath();
        if (path2 == null) {
            return files2;
        }
        Path configDir = path2;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByNioFile(configDir);
        if (virtualFile == null) {
            return files2;
        }
        VirtualFile configDirFile = virtualFile;
        Iterable $this$filter$iv = files2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!VfsUtil.isAncestor((VirtualFile)configDirFile, (VirtualFile)it, (boolean)true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filesInConfigDir = (List)destination$iv$iv;
        Collection unversionedFilesInConfigDir = this.doFilterFiles((Collection)filesInConfigDir);
        ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(this, (List<? extends VirtualFile>)unversionedFilesInConfigDir){
            final /* synthetic */ IgnoreFilesProcessorImpl this$0;
            final /* synthetic */ List<VirtualFile> $unversionedFilesInConfigDir;
            {
                this.this$0 = $receiver;
                this.$unversionedFilesInConfigDir = $unversionedFilesInConfigDir;
                super(0);
            }

            public final void invoke() {
                IgnoreFilesProcessorImpl.access$writeIgnores(this.this$0, IgnoreFilesProcessorImpl.access$getProject(this.this$0), this.$unversionedFilesInConfigDir);
            }
        }), (int)1, null);
        return CollectionsKt.minus((Iterable)files2, (Iterable)filesInConfigDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void filesChanged(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        List potentiallyIgnoredFiles2 = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)events), (Function1)((Function1)new Function1<VFileEvent, Boolean>(this){
            final /* synthetic */ IgnoreFilesProcessorImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull VFileEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                FilePath filePath = IgnoreFilesProcessorImpl.access$getAffectedFilePath(this.this$0, it);
                return filePath != null && IgnoreFilesProcessorImpl.access$getVcsIgnoreManager$p(this.this$0).isPotentiallyIgnoredFile(filePath);
            }
        })), (Function1)filesChanged.potentiallyIgnoredFiles.2.INSTANCE));
        if (potentiallyIgnoredFiles2.isEmpty()) {
            return;
        }
        Object object = new Object[]{potentiallyIgnoredFiles2};
        IgnoreFilesProcessorImplKt.access$getLOG$p().debug("Got potentially ignored files from VFS events", (Object[])object);
        object = this.UNPROCESSED_FILES_LOCK;
        ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)object).readLock();
        int n = ((ReentrantReadWriteLock)object).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)object).getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)object).writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            boolean bl2 = this.unprocessedFiles.addAll(potentiallyIgnoredFiles2);
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    @Override
    public void doActionOnChosenFiles(@NotNull Collection<? extends VirtualFile> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(this, files2){
            final /* synthetic */ IgnoreFilesProcessorImpl this$0;
            final /* synthetic */ Collection<VirtualFile> $files;
            {
                this.this$0 = $receiver;
                this.$files = $files;
                super(0);
            }

            public final void invoke() {
                IgnoreFilesProcessorImpl.access$writeIgnores(this.this$0, IgnoreFilesProcessorImpl.access$getProject(this.this$0), this.$files);
            }
        }), (int)1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        super.dispose();
        ReentrantReadWriteLock reentrantReadWriteLock = this.UNPROCESSED_FILES_LOCK;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.unprocessedFiles.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void writeIgnores(Project project2, Collection<? extends VirtualFile> potentiallyIgnoredFiles2) {
        void $this$associateTo$iv$iv;
        if (project2.isDisposed()) {
            return;
        }
        if (potentiallyIgnoredFiles2.isEmpty()) {
            return;
        }
        Object[] objectArray = new Object[]{potentiallyIgnoredFiles2};
        IgnoreFilesProcessorImplKt.access$getLOG$p().debug("Try to write potential ignored files", objectArray);
        HashMap<Object, List> ignoreFileToContent = new HashMap<Object, List>();
        Object[] $this$associate$iv = IgnoredFileProvider.IGNORE_FILE.getExtensions();
        boolean bl = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associate$iv.length), (int)16);
        Object[] objectArray2 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (void element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            Object it = (IgnoredFileProvider)element$iv$iv;
            boolean bl2 = false;
            it = TuplesKt.to((Object)it, it.getIgnoredFiles(project2));
            map2.put(it.getFirst(), it.getSecond());
        }
        Map providerToDescriptorMap = destination$iv$iv;
        for (VirtualFile virtualFile : potentiallyIgnoredFiles2) {
            IgnoredFileContentProvider ignoredContentProvider;
            AbstractVcs vcs;
            if (VcsUtil.getVcsFor(project2, virtualFile) == null) continue;
            boolean bl3 = false;
            if (VcsImplUtil.findIgnoredFileContentProvider(vcs) == null) continue;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)ignoredContentProvider);
            if (this.findOrCreateIgnoreFileByFile(project2, ignoredContentProvider, virtualFile) == null) continue;
            boolean bl32 = false;
            for (Map.Entry entry2 : providerToDescriptorMap.entrySet()) {
                void $this$filterTo$iv$iv;
                IgnoredFileProvider ignoredFileProvider = (IgnoredFileProvider)entry2.getKey();
                Set descriptors = (Set)entry2.getValue();
                Intrinsics.checkNotNull((Object)descriptors);
                Iterable $this$filter$iv = descriptors;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    IgnoredFileDescriptor it = (IgnoredFileDescriptor)element$iv$iv;
                    boolean bl4 = false;
                    if (!it.matchesFile(VcsUtil.getFilePath(virtualFile))) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                for (IgnoredFileDescriptor ignoredFileDescriptor : (List)destination$iv$iv2) {
                    String groupDescription;
                    List ignoreFileContent2;
                    VirtualFile ignoreFile2;
                    Intrinsics.checkNotNullExpressionValue((Object)ignoreFileToContent.computeIfAbsent(ignoreFile2, arg_0 -> IgnoreFilesProcessorImpl.writeIgnores$lambda$9$lambda$8$lambda$7$lambda$6(writeIgnores.1.1.1.ignoreFileContent.1.INSTANCE, arg_0)), (String)"computeIfAbsent(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)ignoredContentProvider.buildIgnoreGroupDescription(ignoredFileProvider), (String)"buildIgnoreGroupDescription(...)");
                    IgnoreGroupContent ignoreFileGroupContent = this.getOrInitialize(ignoreFileContent2, groupDescription);
                    Set<IgnoredFileDescriptor> set = ignoreFileGroupContent.getIgnoredDescriptors();
                    Intrinsics.checkNotNull((Object)ignoredFileDescriptor);
                    set.add(ignoredFileDescriptor);
                }
            }
        }
        for (Map.Entry entry3 : ((Map)ignoreFileToContent).entrySet()) {
            VirtualFile ignoreFile3 = (VirtualFile)entry3.getKey();
            List newContent = (List)entry3.getValue();
            for (IgnoreGroupContent groupContent : newContent) {
                Set<IgnoredFileDescriptor> ignoredDescriptors = groupContent.getIgnoredDescriptors();
                IgnoreFilesProcessorImplKt.access$getLOG$p().debug("Write to ignore file " + ignoreFile3 + " ignores: " + ignoredDescriptors);
                Collection $this$toTypedArray$iv = ignoredDescriptors;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                IgnoredFileDescriptor[] ignoredFileDescriptorArray = thisCollection$iv.toArray(new IgnoredFileDescriptor[0]);
                IgnoreFileUtilKt.addNewElementsToIgnoreBlock(project2, ignoreFile3, groupContent.getGroup(), Arrays.copyOf(ignoredFileDescriptorArray, ignoredFileDescriptorArray.length));
            }
        }
    }

    private final IgnoreGroupContent getOrInitialize(List<IgnoreGroupContent> $this$getOrInitialize, String group2) {
        IgnoreGroupContent ignoreGroupContent;
        Object v0;
        block2: {
            Iterable iterable = $this$getOrInitialize;
            for (Object t : iterable) {
                IgnoreGroupContent it = (IgnoreGroupContent)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getGroup(), (Object)group2)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((ignoreGroupContent = (IgnoreGroupContent)v0) == null) {
            IgnoreGroupContent ignoreGroupContent2;
            IgnoreGroupContent $this$getOrInitialize_u24lambda_u2411 = ignoreGroupContent2 = new IgnoreGroupContent(group2, null, 2, null);
            boolean bl = false;
            $this$getOrInitialize.add($this$getOrInitialize_u24lambda_u2411);
            ignoreGroupContent = ignoreGroupContent2;
        }
        return ignoreGroupContent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final VirtualFile findOrCreateIgnoreFileByFile(Project project2, IgnoredFileContentProvider ignoredContentProvider, VirtualFile file) {
        VirtualFile virtualFile;
        VirtualFile storeDir = this.findStoreDir(project2);
        if (storeDir != null && ignoredContentProvider.supportIgnoreFileNotInVcsRoot() && this.underProjectStoreDir(file, storeDir)) {
            if (!ignoredContentProvider.canCreateIgnoreFileInStateStoreDir()) return null;
            virtualFile = storeDir;
        } else {
            virtualFile = VcsUtil.getVcsRootFor(project2, file);
            if (virtualFile == null) {
                return null;
            }
        }
        VirtualFile ignoreFileRoot = virtualFile;
        VirtualFile virtualFile2 = ignoreFileRoot.findChild(ignoredContentProvider.getFileName());
        if (virtualFile2 != null) return virtualFile2;
        virtualFile2 = (VirtualFile)ActionsKt.runWriteAction((Function0)((Function0)new Function0<VirtualFile>(ignoreFileRoot, this, ignoredContentProvider){
            final /* synthetic */ VirtualFile $ignoreFileRoot;
            final /* synthetic */ IgnoreFilesProcessorImpl this$0;
            final /* synthetic */ IgnoredFileContentProvider $ignoredContentProvider;
            {
                this.$ignoreFileRoot = $ignoreFileRoot;
                this.this$0 = $receiver;
                this.$ignoredContentProvider = $ignoredContentProvider;
                super(0);
            }

            @NotNull
            public final VirtualFile invoke() {
                return this.$ignoreFileRoot.createChildData((Object)this.this$0, this.$ignoredContentProvider.getFileName());
            }
        }));
        return virtualFile2;
    }

    private final VirtualFile findStoreDir(Project project2) {
        String string2 = project2.getBasePath();
        if (string2 == null) {
            return null;
        }
        String projectBasePath = string2;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(projectBasePath);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile projectBaseDir = virtualFile;
        return ProjectKt.getProjectStoreDirectory((VirtualFile)projectBaseDir);
    }

    private final boolean underProjectStoreDir(VirtualFile $this$underProjectStoreDir, VirtualFile storeDir) {
        return VfsUtilCore.isAncestor((VirtualFile)storeDir, (VirtualFile)$this$underProjectStoreDir, (boolean)true);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<VirtualFile> doFilterFiles(@NotNull Collection<? extends VirtualFile> files2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        HashSet parents = CollectionsKt.toHashSet((Iterable)files2);
        List<VirtualFile> list2 = ChangeListManagerImpl.getInstanceImpl(this.getProject()).getUnversionedFiles();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getUnversionedFiles(...)");
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            Set set = parents;
            Intrinsics.checkNotNull((Object)it);
            if (!this.isUnder(set, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    protected void rememberForAllProjects() {
        VcsApplicationSettings applicationSettings = VcsApplicationSettings.getInstance();
        applicationSettings.MANAGE_IGNORE_FILES = true;
    }

    @Override
    @NotNull
    public String getNotificationDisplayId() {
        return this.notificationDisplayId;
    }

    @Override
    @NotNull
    public String getAskedBeforeProperty() {
        return this.askedBeforeProperty;
    }

    @Override
    @NotNull
    public String getDoForCurrentProjectProperty() {
        return this.doForCurrentProjectProperty;
    }

    @Override
    @NotNull
    public String getShowActionText() {
        return this.showActionText;
    }

    @Override
    @NotNull
    public String getForCurrentProjectActionText() {
        return this.forCurrentProjectActionText;
    }

    @Override
    @NotNull
    public String getForAllProjectsActionText() {
        return this.forAllProjectsActionText;
    }

    @Override
    @NotNull
    public String getMuteActionText() {
        return this.muteActionText;
    }

    @Override
    @NotNull
    protected String getViewFilesDialogTitle() {
        return this.viewFilesDialogTitle;
    }

    @Override
    @NotNull
    protected String getViewFilesDialogOkActionName() {
        return this.viewFilesDialogOkActionName;
    }

    @Override
    @NotNull
    public String notificationTitle() {
        return "";
    }

    @Override
    @NotNull
    public String notificationMessage() {
        Object[] objectArray = new Object[2];
        objectArray[0] = ApplicationNamesInfo.getInstance().getFullProductName();
        Object object = VcsImplUtil.findIgnoredFileContentProvider(this.vcs);
        if (object == null || (object = object.getFileName()) == null) {
            object = VcsBundle.message("changes.ignore.file", new Object[0]);
        }
        objectArray[1] = object;
        String string2 = VcsBundle.message("ignored.file.manage.with.files.message", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return string2;
    }

    private final boolean isUnder(Set<? extends VirtualFile> parents, VirtualFile child) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = SequencesKt.generateSequence((Object)child, (Function1)isUnder.1.INSTANCE);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl2 = false;
                if (!parents.contains(it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    protected boolean needDoForCurrentProject() {
        VcsApplicationSettings appSettings = VcsApplicationSettings.getInstance();
        return !appSettings.DISABLE_MANAGE_IGNORE_FILES && (appSettings.MANAGE_IGNORE_FILES || super.needDoForCurrentProject());
    }

    private final FilePath getAffectedFilePath(VFileEvent event) {
        FilePath filePath;
        if (!(event.getFileSystem() instanceof LocalFileSystem)) {
            return null;
        }
        if (event instanceof VFileCreateEvent) {
            filePath = VcsUtil.getFilePath(((VFileCreateEvent)event).getPath(), ((VFileCreateEvent)event).isDirectory());
        } else if (event instanceof VFileMoveEvent || event instanceof VFileCopyEvent || event instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)event).isRename()) {
            String string2 = event.getPath();
            VirtualFile virtualFile = event.getFile();
            Intrinsics.checkNotNull((Object)virtualFile);
            filePath = VcsUtil.getFilePath(string2, virtualFile.isDirectory());
        } else {
            filePath = null;
        }
        return filePath;
    }

    private final boolean needProcessIgnoredFiles() {
        return Registry.is((String)"vcs.ignorefile.generation");
    }

    private static final List writeIgnores$lambda$9$lambda$8$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Project access$getProject(IgnoreFilesProcessorImpl $this) {
        return $this.getProject();
    }

    public static final /* synthetic */ Disposable access$getParentDisposable$p(IgnoreFilesProcessorImpl $this) {
        return $this.parentDisposable;
    }

    public static final /* synthetic */ void access$writeIgnores(IgnoreFilesProcessorImpl $this, Project project2, Collection potentiallyIgnoredFiles2) {
        $this.writeIgnores(project2, potentiallyIgnoredFiles2);
    }

    public static final /* synthetic */ FilePath access$getAffectedFilePath(IgnoreFilesProcessorImpl $this, VFileEvent event) {
        return $this.getAffectedFilePath(event);
    }

    public static final /* synthetic */ VcsIgnoreManager access$getVcsIgnoreManager$p(IgnoreFilesProcessorImpl $this) {
        return $this.vcsIgnoreManager;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/vcs/changes/ignore/IgnoreFilesProcessorImpl$IgnoreGroupContent;", "", "group", "", "ignoredDescriptors", "", "Lcom/intellij/openapi/vcs/changes/IgnoredFileDescriptor;", "(Ljava/lang/String;Ljava/util/Set;)V", "getGroup", "()Ljava/lang/String;", "getIgnoredDescriptors", "()Ljava/util/Set;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.vcs.impl"})
    private static final class IgnoreGroupContent {
        @NotNull
        private final String group;
        @NotNull
        private final Set<IgnoredFileDescriptor> ignoredDescriptors;

        public IgnoreGroupContent(@NotNull String group2, @NotNull Set<IgnoredFileDescriptor> ignoredDescriptors) {
            Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
            Intrinsics.checkNotNullParameter(ignoredDescriptors, (String)"ignoredDescriptors");
            this.group = group2;
            this.ignoredDescriptors = ignoredDescriptors;
        }

        public /* synthetic */ IgnoreGroupContent(String string2, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                set = new LinkedHashSet();
            }
            this(string2, set);
        }

        @NotNull
        public final String getGroup() {
            return this.group;
        }

        @NotNull
        public final Set<IgnoredFileDescriptor> getIgnoredDescriptors() {
            return this.ignoredDescriptors;
        }

        @NotNull
        public final String component1() {
            return this.group;
        }

        @NotNull
        public final Set<IgnoredFileDescriptor> component2() {
            return this.ignoredDescriptors;
        }

        @NotNull
        public final IgnoreGroupContent copy(@NotNull String group2, @NotNull Set<IgnoredFileDescriptor> ignoredDescriptors) {
            Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
            Intrinsics.checkNotNullParameter(ignoredDescriptors, (String)"ignoredDescriptors");
            return new IgnoreGroupContent(group2, ignoredDescriptors);
        }

        public static /* synthetic */ IgnoreGroupContent copy$default(IgnoreGroupContent ignoreGroupContent, String string2, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = ignoreGroupContent.group;
            }
            if ((n & 2) != 0) {
                set = ignoreGroupContent.ignoredDescriptors;
            }
            return ignoreGroupContent.copy(string2, set);
        }

        @NotNull
        public String toString() {
            return "IgnoreGroupContent(group=" + this.group + ", ignoredDescriptors=" + this.ignoredDescriptors + ")";
        }

        public int hashCode() {
            int result2 = this.group.hashCode();
            result2 = result2 * 31 + ((Object)this.ignoredDescriptors).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IgnoreGroupContent)) {
                return false;
            }
            IgnoreGroupContent ignoreGroupContent = (IgnoreGroupContent)other;
            if (!Intrinsics.areEqual((Object)this.group, (Object)ignoreGroupContent.group)) {
                return false;
            }
            return Intrinsics.areEqual(this.ignoredDescriptors, ignoreGroupContent.ignoredDescriptors);
        }
    }
}

