/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.dvcs.ui.RepositoryChangesBrowserNode;
import com.intellij.dvcs.ui.RepositoryChangesGroupingPolicy;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ui.BaseChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.StaticFilePath;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import java.util.Map;
import java.util.Objects;
import javax.swing.tree.DefaultTreeModel;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J.\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u000f2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/dvcs/ui/RepositoryChangesGroupingPolicy;", "Lcom/intellij/openapi/vcs/changes/ui/BaseChangesGroupingPolicy;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Ljavax/swing/tree/DefaultTreeModel;", "(Lcom/intellij/openapi/project/Project;Ljavax/swing/tree/DefaultTreeModel;)V", "getModel", "()Ljavax/swing/tree/DefaultTreeModel;", "getProject", "()Lcom/intellij/openapi/project/Project;", "repositoryManager", "Lcom/intellij/dvcs/repo/VcsRepositoryManager;", "Lorg/jetbrains/annotations/NotNull;", "getParentNodeFor", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "nodePath", "Lcom/intellij/openapi/vcs/changes/ui/StaticFilePath;", "node", "subtreeRoot", "getRepositoryFor", "Lcom/intellij/dvcs/repo/Repository;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "Companion", "Factory", "intellij.platform.vcs.dvcs.impl"})
@SourceDebugExtension(value={"SMAP\nRepositoryChangesGroupingPolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepositoryChangesGroupingPolicy.kt\ncom/intellij/dvcs/ui/RepositoryChangesGroupingPolicy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
public final class RepositoryChangesGroupingPolicy
extends BaseChangesGroupingPolicy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final DefaultTreeModel model;
    @NotNull
    private final VcsRepositoryManager repositoryManager;
    @NotNull
    private static final NotNullLazyKey<Map<Repository, ChangesBrowserNode<?>>, ChangesBrowserNode<?>> REPOSITORY_CACHE;

    public RepositoryChangesGroupingPolicy(@NotNull Project project2, @NotNull DefaultTreeModel model2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        this.project = project2;
        this.model = model2;
        VcsRepositoryManager vcsRepositoryManager = VcsRepositoryManager.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)vcsRepositoryManager, (String)"getInstance(...)");
        this.repositoryManager = vcsRepositoryManager;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final DefaultTreeModel getModel() {
        return this.model;
    }

    @Override
    @Nullable
    public ChangesBrowserNode<?> getParentNodeFor(@NotNull StaticFilePath nodePath, @NotNull ChangesBrowserNode<?> node, @NotNull ChangesBrowserNode<?> subtreeRoot) {
        ChangesBrowserNode<?> grandParent;
        ChangesBrowserNode<?> cachingRoot;
        ChangesBrowserNode changesBrowserNode;
        Intrinsics.checkNotNullParameter((Object)nodePath, (String)"nodePath");
        Intrinsics.checkNotNullParameter(node, (String)"node");
        Intrinsics.checkNotNullParameter(subtreeRoot, (String)"subtreeRoot");
        ChangesGroupingPolicy changesGroupingPolicy = this.getNextPolicy();
        ChangesBrowserNode<?> nextPolicyParent = changesGroupingPolicy != null ? changesGroupingPolicy.getParentNodeFor(nodePath, node, subtreeRoot) : null;
        VcsLogColorManager colorManager = RepositoryChangesBrowserNode.Companion.getColorManager(this.project);
        if (!colorManager.hasMultiplePaths()) {
            return nextPolicyParent;
        }
        FilePath filePath = nodePath.getFilePath();
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
        FilePath filePath2 = filePath;
        Repository repository = this.getRepositoryFor(filePath2);
        if (repository == null || this.repositoryManager.isExternal(repository)) {
            return nextPolicyParent;
        }
        ChangesBrowserNode<?> changesBrowserNode2 = nextPolicyParent;
        if (changesBrowserNode2 == null) {
            changesBrowserNode2 = subtreeRoot;
        }
        if ((changesBrowserNode = (ChangesBrowserNode)((Map)REPOSITORY_CACHE.getValue((UserDataHolder)(cachingRoot = BaseChangesGroupingPolicy.Companion.getCachingRoot(grandParent = changesBrowserNode2, subtreeRoot)))).get(repository)) != null) {
            ChangesBrowserNode it = changesBrowserNode;
            boolean bl = false;
            return it;
        }
        RepositoryChangesBrowserNode repoNode = new RepositoryChangesBrowserNode(repository, colorManager);
        repoNode.markAsHelperNode();
        this.model.insertNodeInto(repoNode, grandParent, grandParent.getChildCount());
        Object object = REPOSITORY_CACHE.getValue((UserDataHolder)cachingRoot);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        ((Map)object).put(repository, repoNode);
        TreeModelBuilder.IS_CACHING_ROOT.set((UserDataHolder)repoNode, (Object)true);
        Object object2 = TreeModelBuilder.DIRECTORY_CACHE.getValue((UserDataHolder)repoNode);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getValue(...)");
        Map map2 = (Map)object2;
        map2.put(TreeModelBuilder.staticFrom(repository.getRoot()).getKey(), repoNode);
        return repoNode;
    }

    private final Repository getRepositoryFor(FilePath filePath) {
        Repository parentRepo;
        Repository repository = this.repositoryManager.getRepositoryForFile(filePath, true);
        if (repository != null && !repository.getVcs().areDirectoriesVersionedItems() && Objects.equals(repository.getRoot().getPath(), filePath.getPath()) && (parentRepo = this.repositoryManager.getRepositoryForFile(repository.getRoot().getParent(), true)) != null) {
            return parentRepo;
        }
        return repository;
    }

    private static final Map REPOSITORY_CACHE$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Map)$tmp0.invoke(p0);
    }

    static {
        NotNullLazyKey notNullLazyKey = NotNullLazyKey.createLazyKey((String)"ChangesTree.RepositoryCache", arg_0 -> RepositoryChangesGroupingPolicy.REPOSITORY_CACHE$lambda$1(Companion.REPOSITORY_CACHE.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)notNullLazyKey, (String)"createLazyKey(...)");
        REPOSITORY_CACHE = notNullLazyKey;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002RZ\u0010\u0003\u001aK\u0012,\u0012*\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007 \b*\u0014\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0018\u00010\u00050\u0005\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \b*\b\u0012\u0002\b\u0003\u0018\u00010\u00070\u00070\u0004\u00a2\u0006\u0002\b\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/dvcs/ui/RepositoryChangesGroupingPolicy$Companion;", "", "()V", "REPOSITORY_CACHE", "Lcom/intellij/openapi/util/NotNullLazyKey;", "", "Lcom/intellij/dvcs/repo/Repository;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getREPOSITORY_CACHE", "()Lcom/intellij/openapi/util/NotNullLazyKey;", "intellij.platform.vcs.dvcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NotNullLazyKey<Map<Repository, ChangesBrowserNode<?>>, ChangesBrowserNode<?>> getREPOSITORY_CACHE() {
            return REPOSITORY_CACHE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/dvcs/ui/RepositoryChangesGroupingPolicy$Factory;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;", "()V", "createGroupingPolicy", "Lcom/intellij/dvcs/ui/RepositoryChangesGroupingPolicy;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Ljavax/swing/tree/DefaultTreeModel;", "intellij.platform.vcs.dvcs.impl"})
    public static final class Factory
    extends ChangesGroupingPolicyFactory {
        @Override
        @NotNull
        public RepositoryChangesGroupingPolicy createGroupingPolicy(@NotNull Project project2, @NotNull DefaultTreeModel model2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            return new RepositoryChangesGroupingPolicy(project2, model2);
        }
    }
}

