/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.branch;

import com.intellij.dvcs.branch.BranchStorage;
import com.intellij.dvcs.branch.BranchType;
import com.intellij.dvcs.branch.DvcsBranchInfo;
import com.intellij.dvcs.branch.DvcsBranchSettings;
import com.intellij.dvcs.branch.GroupingKey;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DvcsBranchManager<T extends Repository> {
    private final AbstractRepositoryManager<T> myRepositoryManager;
    @NotNull
    private final DvcsBranchSettings myBranchSettings;
    @NotNull
    private final Map<BranchType, Collection<String>> myPredefinedFavoriteBranches;
    @NotNull
    private final Project myProject;
    @NotNull
    public static final Topic<DvcsBranchManagerListener> DVCS_BRANCH_SETTINGS_CHANGED = Topic.create((String)"Branch settings changed", DvcsBranchManagerListener.class);

    protected DvcsBranchManager(@NotNull Project project2, @NotNull DvcsBranchSettings settings, BranchType @NotNull [] branchTypes, @NotNull AbstractRepositoryManager<T> repositoryManager) {
        if (project2 == null) {
            DvcsBranchManager.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            DvcsBranchManager.$$$reportNull$$$0(1);
        }
        if (repositoryManager == null) {
            DvcsBranchManager.$$$reportNull$$$0(2);
        }
        if (branchTypes == null) {
            DvcsBranchManager.$$$reportNull$$$0(3);
        }
        this.myPredefinedFavoriteBranches = new HashMap<BranchType, Collection<String>>();
        this.myProject = project2;
        this.myBranchSettings = settings;
        this.myRepositoryManager = repositoryManager;
        for (BranchType type2 : branchTypes) {
            Collection predefinedFavoriteBranches = this.myPredefinedFavoriteBranches.computeIfAbsent(type2, __ -> new HashSet());
            for (String branchName : this.getDefaultBranchNames(type2)) {
                if (StringUtil.isEmptyOrSpaces((String)branchName)) continue;
                predefinedFavoriteBranches.add(branchName);
            }
            this.myPredefinedFavoriteBranches.put(type2, predefinedFavoriteBranches);
        }
    }

    protected Collection<String> getDefaultBranchNames(@NotNull BranchType type2) {
        if (type2 == null) {
            DvcsBranchManager.$$$reportNull$$$0(4);
        }
        return Collections.EMPTY_LIST;
    }

    public boolean isFavorite(@Nullable BranchType branchType, @Nullable Repository repository, @NotNull String branchName) {
        if (branchName == null) {
            DvcsBranchManager.$$$reportNull$$$0(5);
        }
        if (branchType == null) {
            return false;
        }
        String branchTypeName = branchType.getName();
        if (this.myBranchSettings.getFavorites().contains(branchTypeName, repository, branchName)) {
            return true;
        }
        if (this.myBranchSettings.getExcludedFavorites().contains(branchTypeName, repository, branchName)) {
            return false;
        }
        return this.isPredefinedAsFavorite(branchType, branchName);
    }

    @NotNull
    public Map<T, Set<String>> getFavoriteBranches(@NotNull BranchType branchType) {
        if (branchType == null) {
            DvcsBranchManager.$$$reportNull$$$0(6);
        }
        Map<T, List<String>> favorites = this.collectBranchesByRoot(this.myBranchSettings.getFavorites(), branchType);
        Map<T, List<String>> excludedFavorites = this.collectBranchesByRoot(this.myBranchSettings.getExcludedFavorites(), branchType);
        Collection<String> predefinedFavorites = this.myPredefinedFavoriteBranches.get(branchType);
        HashMap result2 = new HashMap();
        for (Repository repo : this.myRepositoryManager.getRepositories()) {
            HashSet<String> branches = new HashSet<String>();
            if (predefinedFavorites != null) {
                branches.addAll(predefinedFavorites);
            }
            List repoExcludedFavorites = ContainerUtil.notNullize(excludedFavorites.get(repo));
            for (String repoExcludedFavorite : repoExcludedFavorites) {
                branches.remove(repoExcludedFavorite);
            }
            List repoFavorites = ContainerUtil.notNullize(favorites.get(repo));
            branches.addAll(repoFavorites);
            result2.put(repo, branches);
        }
        HashMap hashMap = result2;
        if (hashMap == null) {
            DvcsBranchManager.$$$reportNull$$$0(7);
        }
        return hashMap;
    }

    @NotNull
    private Map<T, List<String>> collectBranchesByRoot(@NotNull BranchStorage storage, @NotNull BranchType branchType) {
        if (storage == null) {
            DvcsBranchManager.$$$reportNull$$$0(8);
        }
        if (branchType == null) {
            DvcsBranchManager.$$$reportNull$$$0(9);
        }
        List infos = ContainerUtil.notNullize(storage.getBranches().get(branchType.getName()));
        HashMap<String, List> infoByPath = new HashMap<String, List>();
        for (DvcsBranchInfo info : infos) {
            List list3 = infoByPath.computeIfAbsent(info.repoPath, key2 -> new ArrayList());
            list3.add(info.sourceName);
        }
        HashMap infoByRepo = new HashMap();
        infoByPath.forEach((repoPath, list2) -> {
            T repo = this.myRepositoryManager.getRepositoryForRootQuick(VcsUtil.getFilePath(repoPath, true));
            if (repo == null) {
                return;
            }
            infoByRepo.put(repo, list2);
        });
        HashMap hashMap = infoByRepo;
        if (hashMap == null) {
            DvcsBranchManager.$$$reportNull$$$0(10);
        }
        return hashMap;
    }

    private boolean isPredefinedAsFavorite(@NotNull BranchType type2, @NotNull String branchName) {
        Collection<String> predefinedNames;
        if (type2 == null) {
            DvcsBranchManager.$$$reportNull$$$0(11);
        }
        if (branchName == null) {
            DvcsBranchManager.$$$reportNull$$$0(12);
        }
        return (predefinedNames = this.myPredefinedFavoriteBranches.get(type2)) != null && predefinedNames.contains(branchName);
    }

    public void setFavorite(@Nullable BranchType branchType, @Nullable Repository repository, @NotNull String branchName, boolean shouldBeFavorite) {
        if (branchName == null) {
            DvcsBranchManager.$$$reportNull$$$0(13);
        }
        if (branchType == null) {
            return;
        }
        String branchTypeName = branchType.getName();
        if (shouldBeFavorite) {
            this.myBranchSettings.getExcludedFavorites().remove(branchTypeName, repository, branchName);
            if (!this.isPredefinedAsFavorite(branchType, branchName)) {
                this.myBranchSettings.getFavorites().add(branchTypeName, repository, branchName);
            }
        } else {
            this.myBranchSettings.getFavorites().remove(branchTypeName, repository, branchName);
            if (this.isPredefinedAsFavorite(branchType, branchName)) {
                this.myBranchSettings.getExcludedFavorites().add(branchTypeName, repository, branchName);
            }
        }
        this.notifyFavoriteSettingsChanged();
    }

    private void notifyFavoriteSettingsChanged() {
        BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this.myProject, () -> ((DvcsBranchManagerListener)this.myProject.getMessageBus().syncPublisher(DVCS_BRANCH_SETTINGS_CHANGED)).branchFavoriteSettingsChanged());
    }

    public boolean isGroupingEnabled(@NotNull GroupingKey key2) {
        if (key2 == null) {
            DvcsBranchManager.$$$reportNull$$$0(14);
        }
        return this.myBranchSettings.getGroupingKeyIds().contains(key2.getId());
    }

    public void setGrouping(@NotNull GroupingKey key2, boolean state) {
        if (key2 == null) {
            DvcsBranchManager.$$$reportNull$$$0(15);
        }
        if (state) {
            this.myBranchSettings.getGroupingKeyIds().add(key2.getId());
        } else {
            this.myBranchSettings.getGroupingKeyIds().remove(key2.getId());
        }
        this.myBranchSettings.intIncrementModificationCount();
        this.notifyGroupingSettingsChanged(key2, state);
    }

    private void notifyGroupingSettingsChanged(@NotNull GroupingKey key2, boolean state) {
        if (key2 == null) {
            DvcsBranchManager.$$$reportNull$$$0(16);
        }
        BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this.myProject, () -> ((DvcsBranchManagerListener)this.myProject.getMessageBus().syncPublisher(DVCS_BRANCH_SETTINGS_CHANGED)).branchGroupingSettingsChanged(key2, state));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchTypes";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchType";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/branch/DvcsBranchManager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/branch/DvcsBranchManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFavoriteBranches";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "collectBranchesByRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultBranchNames";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isFavorite";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFavoriteBranches";
                break;
            }
            case 7: 
            case 10: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectBranchesByRoot";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isPredefinedAsFavorite";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setFavorite";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isGroupingEnabled";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setGrouping";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "notifyGroupingSettingsChanged";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 7, 10 -> new IllegalStateException(string2);
        };
    }

    public static interface DvcsBranchManagerListener {
        default public void branchFavoriteSettingsChanged() {
        }

        default public void branchGroupingSettingsChanged(@NotNull GroupingKey key2, boolean state) {
            if (key2 == null) {
                DvcsBranchManagerListener.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/dvcs/branch/DvcsBranchManager$DvcsBranchManagerListener", "branchGroupingSettingsChanged"));
        }
    }
}

