/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.auth;

import com.intellij.collaboration.auth.services.OAuthService;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.Url;
import com.intellij.util.concurrency.AppExecutorUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.concurrent.Future;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.RestService;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\bH\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0015J\u0014\u0010\u0014\u001a\u00020\u00112\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0014J\f\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0004H&J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0018\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00048DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001d"}, d2={"Lcom/intellij/collaboration/auth/OAuthCallbackHandlerBase;", "Lorg/jetbrains/ide/RestService;", "()V", "service", "Lcom/intellij/collaboration/auth/services/OAuthService;", "getService", "()Lcom/intellij/collaboration/auth/services/OAuthService;", "execute", "", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "getServiceName", "handleAcceptCode", "Lcom/intellij/collaboration/auth/OAuthCallbackHandlerBase$AcceptCodeHandleResult;", "isAccepted", "", "handleOAuthResult", "oAuthResult", "Lcom/intellij/collaboration/auth/services/OAuthService$OAuthResult;", "oauthService", "sendRedirect", "", "url", "Lcom/intellij/util/Url;", "AcceptCodeHandleResult", "intellij.platform.collaborationTools.auth"})
public abstract class OAuthCallbackHandlerBase
extends RestService {
    @NotNull
    protected final OAuthService<?> getService() {
        return this.oauthService();
    }

    @NotNull
    public abstract OAuthService<?> oauthService();

    @NotNull
    protected String getServiceName() {
        return this.getService().getName();
    }

    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Channel channel = context.channel();
        EmptyProgressIndicator indicator = new EmptyProgressIndicator();
        channel.closeFuture().addListener(arg_0 -> OAuthCallbackHandlerBase.execute$lambda$0(indicator, arg_0));
        ExecutorService executorService = AppExecutorUtil.getAppExecutorService();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"getAppExecutorService(...)");
        ExecutorService executor = executorService;
        CompletableFuture.supplyAsync(() -> OAuthCallbackHandlerBase.execute$lambda$2(indicator, this, urlDecoder), executor).handle((arg_0, arg_1) -> OAuthCallbackHandlerBase.execute$lambda$3((Function2)new Function2<AcceptCodeHandleResult, Throwable, Object>(channel, context, request, this){
            final /* synthetic */ Channel $channel;
            final /* synthetic */ ChannelHandlerContext $context;
            final /* synthetic */ FullHttpRequest $request;
            final /* synthetic */ OAuthCallbackHandlerBase this$0;
            {
                this.$channel = $channel;
                this.$context = $context;
                this.$request = $request;
                this.this$0 = $receiver;
                super(2);
            }

            public final Object invoke(@Nullable AcceptCodeHandleResult res, Throwable err) {
                ChannelFuture channelFuture;
                if (err != null) {
                    if (err instanceof ProcessCanceledException) {
                        channelFuture = this.$channel.close();
                    } else {
                        RestService.LOG.warn(err);
                        HttpResponseStatus httpResponseStatus = HttpResponseStatus.INTERNAL_SERVER_ERROR;
                        Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"INTERNAL_SERVER_ERROR");
                        Channel channel = this.$channel;
                        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"$channel");
                        RestService.Companion.sendStatus(httpResponseStatus, false, channel);
                        channelFuture = Unit.INSTANCE;
                    }
                } else if (res != null) {
                    AcceptCodeHandleResult acceptCodeHandleResult = res;
                    if (acceptCodeHandleResult instanceof AcceptCodeHandleResult.Page) {
                        byte[] byArray = ((AcceptCodeHandleResult.Page)res).getHtml().getBytes(Charsets.UTF_8);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                        HttpResponse httpResponse = (HttpResponse)Responses.response((String)"text/html", (ByteBuf)Unpooled.wrappedBuffer((byte[])byArray));
                        Channel channel = this.$context.channel();
                        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
                        Responses.send$default((HttpResponse)httpResponse, (Channel)channel, (HttpRequest)((HttpRequest)this.$request), null, (int)4, null);
                    } else if (acceptCodeHandleResult instanceof AcceptCodeHandleResult.Redirect) {
                        OAuthCallbackHandlerBase.access$sendRedirect(this.this$0, this.$request, this.$context, ((AcceptCodeHandleResult.Redirect)res).getUrl());
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    channelFuture = Unit.INSTANCE;
                } else {
                    HttpResponseStatus httpResponseStatus = HttpResponseStatus.NO_CONTENT;
                    Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"NO_CONTENT");
                    Channel channel = this.$channel;
                    Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"$channel");
                    RestService.Companion.sendStatus(httpResponseStatus, false, channel);
                    channelFuture = Unit.INSTANCE;
                }
                return channelFuture;
            }
        }, arg_0, arg_1));
        return null;
    }

    @NotNull
    protected AcceptCodeHandleResult handleOAuthResult(@NotNull OAuthService.OAuthResult<?> oAuthResult) {
        Intrinsics.checkNotNullParameter(oAuthResult, (String)"oAuthResult");
        return this.handleAcceptCode(oAuthResult.isAccepted());
    }

    @Deprecated(message="Use handleOAuthResult instead", replaceWith=@ReplaceWith(expression="handleOAuthResult", imports={}))
    @NotNull
    protected AcceptCodeHandleResult handleAcceptCode(boolean isAccepted) {
        throw new UnsupportedOperationException();
    }

    private final void sendRedirect(FullHttpRequest request, ChannelHandlerContext context, Url url) {
        HttpHeaders headers = new DefaultHttpHeaders().set((CharSequence)HttpHeaderNames.LOCATION, (Object)url.toExternalForm());
        HttpResponseStatus httpResponseStatus = HttpResponseStatus.FOUND;
        Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"FOUND");
        Channel channel = context.channel();
        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
        Responses.send((HttpResponseStatus)httpResponseStatus, (Channel)channel, (HttpRequest)((HttpRequest)request), null, (HttpHeaders)headers);
    }

    private static final void execute$lambda$0(EmptyProgressIndicator $indicator, Future it) {
        Intrinsics.checkNotNullParameter((Object)$indicator, (String)"$indicator");
        $indicator.cancel();
    }

    private static final AcceptCodeHandleResult execute$handle$lambda$1(OAuthCallbackHandlerBase this$0, QueryStringDecoder $urlDecoder) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$urlDecoder, (String)"$urlDecoder");
        OAuthService<?> oAuthService = this$0.getService();
        String string2 = $urlDecoder.path();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"path(...)");
        Map map2 = $urlDecoder.parameters();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"parameters(...)");
        OAuthService.OAuthResult<?> oAuthResult = oAuthService.handleOAuthServerCallback(string2, map2);
        if (oAuthResult == null) {
            return null;
        }
        OAuthService.OAuthResult<?> oAuthResult2 = oAuthResult;
        return this$0.handleOAuthResult(oAuthResult2);
    }

    private static final AcceptCodeHandleResult execute$handle(OAuthCallbackHandlerBase this$0, QueryStringDecoder $urlDecoder, EmptyProgressIndicator indicator) {
        return (AcceptCodeHandleResult)ProgressManager.getInstance().runProcess(() -> OAuthCallbackHandlerBase.execute$handle$lambda$1(this$0, $urlDecoder), (ProgressIndicator)indicator);
    }

    private static final AcceptCodeHandleResult execute$lambda$2(EmptyProgressIndicator $indicator, OAuthCallbackHandlerBase this$0, QueryStringDecoder $urlDecoder) {
        Intrinsics.checkNotNullParameter((Object)$indicator, (String)"$indicator");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$urlDecoder, (String)"$urlDecoder");
        return OAuthCallbackHandlerBase.execute$handle(this$0, $urlDecoder, $indicator);
    }

    private static final Object execute$lambda$3(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return $tmp0.invoke(p0, (Object)p1);
    }

    public static final /* synthetic */ void access$sendRedirect(OAuthCallbackHandlerBase $this, FullHttpRequest request, ChannelHandlerContext context, Url url) {
        $this.sendRedirect(request, context, url);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b4\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/collaboration/auth/OAuthCallbackHandlerBase$AcceptCodeHandleResult;", "", "()V", "Page", "Redirect", "Lcom/intellij/collaboration/auth/OAuthCallbackHandlerBase$AcceptCodeHandleResult$Page;", "Lcom/intellij/collaboration/auth/OAuthCallbackHandlerBase$AcceptCodeHandleResult$Redirect;", "intellij.platform.collaborationTools.auth"})
    protected static abstract class AcceptCodeHandleResult {
        private AcceptCodeHandleResult() {
        }

        public /* synthetic */ AcceptCodeHandleResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/collaboration/auth/OAuthCallbackHandlerBase$AcceptCodeHandleResult$Page;", "Lcom/intellij/collaboration/auth/OAuthCallbackHandlerBase$AcceptCodeHandleResult;", "html", "", "(Ljava/lang/String;)V", "getHtml", "()Ljava/lang/String;", "intellij.platform.collaborationTools.auth"})
        public static final class Page
        extends AcceptCodeHandleResult {
            @NotNull
            private final String html;

            public Page(@NotNull String html) {
                Intrinsics.checkNotNullParameter((Object)html, (String)"html");
                super(null);
                this.html = html;
            }

            @NotNull
            public final String getHtml() {
                return this.html;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/collaboration/auth/OAuthCallbackHandlerBase$AcceptCodeHandleResult$Redirect;", "Lcom/intellij/collaboration/auth/OAuthCallbackHandlerBase$AcceptCodeHandleResult;", "url", "Lcom/intellij/util/Url;", "(Lcom/intellij/util/Url;)V", "getUrl", "()Lcom/intellij/util/Url;", "intellij.platform.collaborationTools.auth"})
        public static final class Redirect
        extends AcceptCodeHandleResult {
            @NotNull
            private final Url url;

            public Redirect(@NotNull Url url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                super(null);
                this.url = url;
            }

            @NotNull
            public final Url getUrl() {
                return this.url;
            }
        }
    }
}

