/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInsight.navigation.PsiTargetNavigator;
import com.intellij.codeInsight.navigation.TargetPresentationProvider;
import com.intellij.codeInsight.navigation.impl.PsiTargetPresentationRenderer;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NavigationGutterIconRenderer
extends GutterIconRenderer
implements GutterIconNavigationHandler<PsiElement>,
DumbAware {
    private static final Logger LOG = Logger.getInstance(NavigationGutterIconRenderer.class);
    protected final @NlsContexts.PopupTitle String myPopupTitle;
    private final @NlsContexts.PopupContent String myEmptyText;
    protected final Computable<? extends PsiElementListCellRenderer> myCellRenderer;
    private Supplier<? extends PsiTargetPresentationRenderer<PsiElement>> myTargetRenderer;
    private Project myProject;
    private final NotNullLazyValue<? extends List<SmartPsiElementPointer<?>>> myPointers;
    private final boolean myComputeTargetsInBackground;
    @Nullable
    private final GutterIconNavigationHandler<? super PsiElement> myNavigationHandler;

    protected NavigationGutterIconRenderer(@NlsContexts.PopupTitle String popupTitle, @NlsContexts.PopupContent String emptyText, @NotNull Computable<? extends PsiElementListCellRenderer<?>> cellRenderer, @NotNull NotNullLazyValue<? extends List<SmartPsiElementPointer<?>>> pointers) {
        if (cellRenderer == null) {
            NavigationGutterIconRenderer.$$$reportNull$$$0(0);
        }
        if (pointers == null) {
            NavigationGutterIconRenderer.$$$reportNull$$$0(1);
        }
        this(popupTitle, emptyText, cellRenderer, pointers, true);
    }

    protected NavigationGutterIconRenderer(@NlsContexts.PopupTitle String popupTitle, @NlsContexts.PopupContent String emptyText, @NotNull Computable<? extends PsiElementListCellRenderer<?>> cellRenderer, @NotNull NotNullLazyValue<? extends List<SmartPsiElementPointer<?>>> pointers, boolean computeTargetsInBackground) {
        if (cellRenderer == null) {
            NavigationGutterIconRenderer.$$$reportNull$$$0(2);
        }
        if (pointers == null) {
            NavigationGutterIconRenderer.$$$reportNull$$$0(3);
        }
        this(popupTitle, emptyText, cellRenderer, pointers, computeTargetsInBackground, null);
    }

    protected NavigationGutterIconRenderer(@NlsContexts.PopupTitle String popupTitle, @NlsContexts.PopupContent String emptyText, @NotNull Computable<? extends PsiElementListCellRenderer<?>> cellRenderer, @NotNull NotNullLazyValue<? extends List<SmartPsiElementPointer<?>>> pointers, boolean computeTargetsInBackground, @Nullable GutterIconNavigationHandler<? super PsiElement> navigationHandler) {
        if (cellRenderer == null) {
            NavigationGutterIconRenderer.$$$reportNull$$$0(4);
        }
        if (pointers == null) {
            NavigationGutterIconRenderer.$$$reportNull$$$0(5);
        }
        this.myPopupTitle = popupTitle;
        this.myEmptyText = emptyText;
        this.myCellRenderer = cellRenderer;
        this.myPointers = pointers;
        this.myComputeTargetsInBackground = computeTargetsInBackground;
        this.myNavigationHandler = navigationHandler;
    }

    public void setTargetRenderer(Supplier<? extends PsiTargetPresentationRenderer<PsiElement>> targetRenderer) {
        this.myTargetRenderer = targetRenderer;
    }

    public void setProject(Project project2) {
        this.myProject = project2;
    }

    public boolean isNavigateAction() {
        return true;
    }

    @NotNull
    public List<PsiElement> getTargetElements() {
        List pointers = (List)this.myPointers.getValue();
        if (pointers.isEmpty()) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                NavigationGutterIconRenderer.$$$reportNull$$$0(6);
            }
            return list2;
        }
        Project project2 = ((SmartPsiElementPointer)pointers.get(0)).getProject();
        DumbService dumbService = DumbService.getInstance((Project)project2);
        List list3 = (List)dumbService.computeWithAlternativeResolveEnabled(() -> ContainerUtil.mapNotNull((Collection)pointers, smartPsiElementPointer -> smartPsiElementPointer.getElement()));
        if (list3 == null) {
            NavigationGutterIconRenderer.$$$reportNull$$$0(7);
        }
        return list3;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        NavigationGutterIconRenderer renderer2 = (NavigationGutterIconRenderer)((Object)o);
        if (this.myEmptyText != null ? !this.myEmptyText.equals(renderer2.myEmptyText) : renderer2.myEmptyText != null) {
            return false;
        }
        if (!((List)this.myPointers.getValue()).equals(renderer2.myPointers.getValue())) {
            return false;
        }
        return !(this.myPopupTitle != null ? !this.myPopupTitle.equals(renderer2.myPopupTitle) : renderer2.myPopupTitle != null);
    }

    public int hashCode() {
        int result2 = this.myPopupTitle != null ? this.myPopupTitle.hashCode() : 0;
        result2 = 31 * result2 + (this.myEmptyText != null ? this.myEmptyText.hashCode() : 0);
        result2 = 31 * result2 + ((List)this.myPointers.getValue()).hashCode();
        return result2;
    }

    @Nullable
    public AnAction getClickAction() {
        return new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                NavigationGutterIconRenderer.this.navigate((MouseEvent)e.getInputEvent(), null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/navigation/NavigationGutterIconRenderer$1", "actionPerformed"));
            }
        };
    }

    public void navigate(@Nullable MouseEvent event, @Nullable PsiElement elt) {
        if (event != null && this.myComputeTargetsInBackground && event.getComponent() != null) {
            this.navigateTargetsAsync(event);
        } else {
            this.navigateTargets(event, this.getTargetElements());
        }
    }

    private void navigateTargetsAsync(@NotNull MouseEvent event) {
        Component component2;
        if (event == null) {
            NavigationGutterIconRenderer.$$$reportNull$$$0(8);
        }
        Runnable loadingRemover = (component2 = event.getComponent()) instanceof EditorGutterComponentEx ? ((EditorGutterComponentEx)component2).setLoadingIconForCurrentGutterMark() : null;
        AppExecutorUtil.getAppExecutorService().execute(ClientId.decorateRunnable(() -> ProgressManager.getInstance().computePrioritized(() -> {
            ProgressManager.getInstance().executeProcessUnderProgress(() -> {
                Ref targets = Ref.create();
                boolean success2 = ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> targets.set(this.getTargetElements()));
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (loadingRemover != null) {
                        loadingRemover.run();
                    }
                    if (success2) {
                        this.navigateTargets(event, (List)targets.get());
                    }
                });
            }, (ProgressIndicator)new EmptyProgressIndicator());
            return null;
        })));
    }

    private void navigateTargets(@Nullable MouseEvent event, @NotNull List<? extends PsiElement> targets) {
        if (targets == null) {
            NavigationGutterIconRenderer.$$$reportNull$$$0(9);
        }
        if (targets.isEmpty()) {
            if (this.myEmptyText != null && event != null) {
                JComponent label2 = HintUtil.createErrorLabel((String)this.myEmptyText);
                label2.setBorder((Border)JBUI.Borders.empty((int)2, (int)7));
                JBPopupFactory.getInstance().createBalloonBuilder(label2).setFadeoutTime(3000L).setFillColor(HintUtil.getErrorColor()).createBalloon().show(new RelativePoint(event), Balloon.Position.above);
            }
        } else {
            this.navigateToItems(event);
        }
    }

    protected void navigateToItems(@Nullable MouseEvent event) {
        ArrayList navigatables = new ArrayList();
        for (SmartPsiElementPointer pointer : (List)this.myPointers.getValue()) {
            ContainerUtil.addIfNotNull(navigatables, NavigationGutterIconRenderer.getNavigatable(pointer));
        }
        if (navigatables.size() == 1) {
            if (this.myNavigationHandler != null) {
                this.myNavigationHandler.navigate(event, (PsiElement)((Pair)navigatables.get((int)0)).first);
            } else {
                ((Navigatable)((Pair)navigatables.get((int)0)).second).navigate(true);
            }
        } else if (event != null) {
            PsiElementListCellRenderer renderer2 = (PsiElementListCellRenderer)this.myCellRenderer.compute();
            if (this.myTargetRenderer != null || DefaultPsiElementCellRenderer.class == renderer2.getClass()) {
                PsiTargetNavigator navigator = new PsiTargetNavigator(() -> this.getTargetElements());
                if (this.myTargetRenderer != null) {
                    navigator.presentationProvider((TargetPresentationProvider)this.myTargetRenderer.get());
                }
                navigator.navigate(new RelativePoint(event), this.myPopupTitle, this.myProject, element -> this.getElementProcessor(event).execute(element));
                return;
            }
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error("Do not use PsiElementListCellRenderer: " + this.myCellRenderer + ". Use PsiTargetPresentationRenderer via NavigationGutterIconBuilder.setTargetRenderer()");
            }
            PsiElement[] elements = PsiUtilCore.toPsiElementArray(this.getTargetElements());
            JBPopup popup2 = NavigationUtil.getPsiElementPopup((PsiElement[])elements, (PsiElementListCellRenderer)renderer2, (String)this.myPopupTitle, this.getElementProcessor(event));
            popup2.show(new RelativePoint(event));
        }
    }

    @NotNull
    private PsiElementProcessor<PsiElement> getElementProcessor(@NotNull MouseEvent event) {
        if (event == null) {
            NavigationGutterIconRenderer.$$$reportNull$$$0(10);
        }
        PsiElementProcessor psiElementProcessor = element -> {
            if (this.myNavigationHandler != null) {
                this.myNavigationHandler.navigate(event, element);
            } else {
                Navigatable descriptor = EditSourceUtil.getDescriptor((PsiElement)element);
                if (descriptor != null && descriptor.canNavigate()) {
                    descriptor.navigate(true);
                }
            }
            return true;
        };
        if (psiElementProcessor == null) {
            NavigationGutterIconRenderer.$$$reportNull$$$0(11);
        }
        return psiElementProcessor;
    }

    @Nullable
    private static Pair<PsiElement, Navigatable> getNavigatable(SmartPsiElementPointer<?> pointer) {
        Navigatable element = NavigationGutterIconRenderer.getNavigationElement(pointer);
        if (element != null) {
            return new Pair((Object)pointer.getElement(), (Object)element);
        }
        VirtualFile virtualFile = pointer.getVirtualFile();
        Segment actualRange = pointer.getRange();
        if (virtualFile != null && actualRange != null && virtualFile.isValid() && actualRange.getStartOffset() >= 0) {
            return new Pair((Object)pointer.getElement(), (Object)new OpenFileDescriptor(pointer.getProject(), virtualFile, actualRange.getStartOffset()));
        }
        return null;
    }

    @Nullable
    private static Navigatable getNavigationElement(SmartPsiElementPointer<?> pointer) {
        PsiElement element = pointer.getElement();
        if (element == null) {
            return null;
        }
        PsiElement navigationElement = element.getNavigationElement();
        return navigationElement instanceof Navigatable ? (Navigatable)navigationElement : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellRenderer";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointers";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/navigation/NavigationGutterIconRenderer";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/navigation/NavigationGutterIconRenderer";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetElements";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "navigateTargetsAsync";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "navigateTargets";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getElementProcessor";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 6, 7, 11 -> new IllegalStateException(string2);
        };
    }
}

