/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtProjectionKind;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.stubs.KotlinUserTypeStub;
import org.jetbrains.kotlin.psi.stubs.StubUtils;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinClassTypeBean;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFlexibleTypeBean;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeArgumentBean;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeBean;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeParameterTypeBean;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinUserTypeStubImpl;

public class KtUserTypeElementType
extends KtStubElementType<KotlinUserTypeStub, KtUserType> {
    public KtUserTypeElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            KtUserTypeElementType.$$$reportNull$$$0(0);
        }
        super(debugName, KtUserType.class, KotlinUserTypeStub.class);
    }

    @NotNull
    public KotlinUserTypeStub createStub(@NotNull KtUserType psi, StubElement parentStub) {
        if (psi == null) {
            KtUserTypeElementType.$$$reportNull$$$0(1);
        }
        return new KotlinUserTypeStubImpl((StubElement<? extends PsiElement>)parentStub, null);
    }

    public void serialize(@NotNull KotlinUserTypeStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            KtUserTypeElementType.$$$reportNull$$$0(2);
        }
        if (dataStream == null) {
            KtUserTypeElementType.$$$reportNull$$$0(3);
        }
        KtUserTypeElementType.serializeType(dataStream, ((KotlinUserTypeStubImpl)stub).getUpperBound());
    }

    public static void serializeType(@NotNull StubOutputStream dataStream, @Nullable KotlinTypeBean type) throws IOException {
        if (dataStream == null) {
            KtUserTypeElementType.$$$reportNull$$$0(4);
        }
        dataStream.writeInt(KotlinTypeBeanKind.fromBean(type).ordinal());
        if (type instanceof KotlinClassTypeBean) {
            StubUtils.serializeClassId(dataStream, ((KotlinClassTypeBean)type).getClassId());
            dataStream.writeBoolean(type.getNullable());
            List<KotlinTypeArgumentBean> arguments = ((KotlinClassTypeBean)type).getArguments();
            dataStream.writeInt(arguments.size());
            for (KotlinTypeArgumentBean argument2 : arguments) {
                KtProjectionKind kind = argument2.getProjectionKind();
                dataStream.writeInt(kind.ordinal());
                if (kind == KtProjectionKind.STAR) continue;
                KtUserTypeElementType.serializeType(dataStream, argument2.getType());
            }
        } else if (type instanceof KotlinTypeParameterTypeBean) {
            dataStream.writeName(((KotlinTypeParameterTypeBean)type).getTypeParameterName());
            dataStream.writeBoolean(type.getNullable());
            dataStream.writeBoolean(((KotlinTypeParameterTypeBean)type).getDefinitelyNotNull());
        } else if (type instanceof KotlinFlexibleTypeBean) {
            KtUserTypeElementType.serializeType(dataStream, ((KotlinFlexibleTypeBean)type).getLowerBound());
            KtUserTypeElementType.serializeType(dataStream, ((KotlinFlexibleTypeBean)type).getUpperBound());
        }
    }

    @NotNull
    public KotlinUserTypeStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            KtUserTypeElementType.$$$reportNull$$$0(5);
        }
        return new KotlinUserTypeStubImpl((StubElement<? extends PsiElement>)parentStub, KtUserTypeElementType.deserializeType(dataStream));
    }

    @Nullable
    public static KotlinTypeBean deserializeType(@NotNull StubInputStream dataStream) throws IOException {
        if (dataStream == null) {
            KtUserTypeElementType.$$$reportNull$$$0(6);
        }
        KotlinTypeBeanKind typeKind = KotlinTypeBeanKind.values()[dataStream.readInt()];
        switch (typeKind) {
            case CLASS: {
                ClassId classId = Objects.requireNonNull(StubUtils.deserializeClassId(dataStream));
                boolean isNullable = dataStream.readBoolean();
                int count = dataStream.readInt();
                ArrayList<KotlinTypeArgumentBean> arguments = new ArrayList<KotlinTypeArgumentBean>();
                for (int i = 0; i < count; ++i) {
                    int kind = dataStream.readInt();
                    KotlinTypeArgumentBean argument2 = kind != KtProjectionKind.STAR.ordinal() ? new KotlinTypeArgumentBean(KtProjectionKind.values()[kind], KtUserTypeElementType.deserializeType(dataStream)) : new KotlinTypeArgumentBean(KtProjectionKind.STAR, null);
                    arguments.add(argument2);
                }
                return new KotlinClassTypeBean(classId, arguments, isNullable);
            }
            case TYPE_PARAMETER: {
                String typeParameterName = Objects.requireNonNull(dataStream.readNameString());
                boolean nullable = dataStream.readBoolean();
                boolean definitelyNotNull = dataStream.readBoolean();
                return new KotlinTypeParameterTypeBean(typeParameterName, nullable, definitelyNotNull);
            }
            case FLEXIBLE: {
                return new KotlinFlexibleTypeBean(Objects.requireNonNull(KtUserTypeElementType.deserializeType(dataStream)), Objects.requireNonNull(KtUserTypeElementType.deserializeType(dataStream)));
            }
            case NONE: {
                return null;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/psi/stubs/elements/KtUserTypeElementType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createStub";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "serializeType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "deserialize";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "deserializeType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum KotlinTypeBeanKind {
        CLASS,
        TYPE_PARAMETER,
        FLEXIBLE,
        NONE;


        static KotlinTypeBeanKind fromBean(@Nullable KotlinTypeBean typeBean) {
            if (typeBean == null) {
                return NONE;
            }
            if (typeBean instanceof KotlinTypeParameterTypeBean) {
                return TYPE_PARAMETER;
            }
            if (typeBean instanceof KotlinClassTypeBean) {
                return CLASS;
            }
            return FLEXIBLE;
        }
    }
}

