/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.runtime.repository.serialization.impl;

import com.intellij.platform.runtime.repository.MalformedRepositoryException;
import com.intellij.platform.runtime.repository.ModuleImportance;
import com.intellij.platform.runtime.repository.RuntimeModuleDescriptor;
import com.intellij.platform.runtime.repository.RuntimeModuleId;
import com.intellij.platform.runtime.repository.RuntimeModuleRepository;
import com.intellij.platform.runtime.repository.serialization.RawIncludedRuntimeModule;
import com.intellij.platform.runtime.repository.serialization.impl.XmlStreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jetbrains.annotations.NotNull;

public final class PluginXmlReader {
    private static final String PLUGIN_XML_PATH = "META-INF/plugin.xml";

    @NotNull
    public static List<RawIncludedRuntimeModule> loadPluginModules(RuntimeModuleDescriptor mainModule, RuntimeModuleRepository repository) {
        ArrayList<RawIncludedRuntimeModule> arrayList;
        try {
            ArrayList<RawIncludedRuntimeModule> modules = new ArrayList<RawIncludedRuntimeModule>();
            HashSet<String> addedModules = new HashSet<String>();
            modules.add(new RawIncludedRuntimeModule(mainModule.getModuleId(), ModuleImportance.FUNCTIONAL, Collections.emptySet()));
            addedModules.add(mainModule.getModuleId().getStringId());
            try (InputStream inputStream = mainModule.readFile(PLUGIN_XML_PATH);){
                if (inputStream == null) {
                    throw new MalformedRepositoryException("META-INF/plugin.xml is not found in '" + mainModule.getModuleId().getStringId() + "' module in " + repository);
                }
                XMLStreamReader reader = XMLInputFactory.newDefaultFactory().createXMLStreamReader(inputStream);
                int level = 0;
                boolean inContentTag = false;
                while (reader.hasNext()) {
                    int event = reader.next();
                    if (event == 1) {
                        String moduleAttribute;
                        int moduleNameEnd;
                        String moduleName;
                        String tagName = reader.getLocalName();
                        if (++level == 2 && tagName.equals("content")) {
                            inContentTag = true;
                            continue;
                        }
                        if (level != 3 || !inContentTag || !tagName.equals("module") || !addedModules.add(moduleName = (moduleNameEnd = (moduleAttribute = XmlStreamUtil.readFirstAttribute(reader, "name")).indexOf(47)) == -1 ? moduleAttribute : moduleAttribute.substring(0, moduleNameEnd))) continue;
                        modules.add(new RawIncludedRuntimeModule(RuntimeModuleId.raw(moduleName), ModuleImportance.OPTIONAL, Collections.emptySet()));
                        continue;
                    }
                    if (event != 2) continue;
                    if (--level != 0) {
                        if (level != 1 || !inContentTag) continue;
                    }
                    break;
                }
            }
            arrayList = modules;
        }
        catch (IOException | XMLStreamException e) {
            throw new MalformedRepositoryException("Failed to load included modules for " + mainModule.getModuleId().getStringId(), e);
        }
        if (arrayList == null) {
            PluginXmlReader.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/runtime/repository/serialization/impl/PluginXmlReader", "loadPluginModules"));
    }
}

