/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.groovy.compiler.rt;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.HashSet;
import java.util.Set;

public class ClassDependencyLoader {
    private final Set<Class<?>> myVisited = new HashSet();

    public Class loadDependencies(Class aClass) throws ClassNotFoundException {
        this.loadClassDependencies(aClass);
        return aClass;
    }

    private void loadTypeDependencies(Type aClass) throws ClassNotFoundException {
        if (aClass instanceof Class) {
            this.loadClassDependencies((Class)aClass);
        } else if (aClass instanceof ParameterizedType) {
            this.loadTypeDependencies(((ParameterizedType)aClass).getOwnerType());
            for (Type type : ((ParameterizedType)aClass).getActualTypeArguments()) {
                this.loadTypeDependencies(type);
            }
        } else if (aClass instanceof WildcardType) {
            for (Type type : ((WildcardType)aClass).getLowerBounds()) {
                this.loadTypeDependencies(type);
            }
            for (Type type : ((WildcardType)aClass).getUpperBounds()) {
                this.loadTypeDependencies(type);
            }
        } else if (aClass instanceof GenericArrayType) {
            this.loadTypeDependencies(((GenericArrayType)aClass).getGenericComponentType());
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void loadClassDependencies(Class aClass) throws ClassNotFoundException {
        String name = aClass.getName();
        if (this.myVisited.add(aClass)) {
            try {
                void var6_15;
                for (Method method : aClass.getDeclaredMethods()) {
                    this.loadTypeDependencies(method.getGenericReturnType());
                    for (Type type : method.getGenericExceptionTypes()) {
                        this.loadTypeDependencies(type);
                    }
                    for (Type type : method.getGenericParameterTypes()) {
                        this.loadTypeDependencies(type);
                    }
                    for (Type type : method.getParameterAnnotations()) {
                        this.loadAnnotationAttributes((Annotation[])type);
                    }
                }
                for (Executable executable : aClass.getDeclaredConstructors()) {
                    for (Type type : ((Constructor)executable).getGenericExceptionTypes()) {
                        this.loadTypeDependencies(type);
                    }
                    for (Type type : ((Constructor)executable).getGenericParameterTypes()) {
                        this.loadTypeDependencies(type);
                    }
                    for (Type type : ((Constructor)executable).getParameterAnnotations()) {
                        this.loadAnnotationAttributes((Annotation[])type);
                    }
                }
                for (AccessibleObject accessibleObject : aClass.getDeclaredFields()) {
                    this.loadTypeDependencies(((Field)accessibleObject).getGenericType());
                    this.loadAnnotationAttributes(((Field)accessibleObject).getDeclaredAnnotations());
                }
                Type superclass = aClass.getGenericSuperclass();
                if (superclass != null) {
                    this.loadClassDependencies(aClass);
                }
                Type[] typeArray = aClass.getGenericInterfaces();
                int n = typeArray.length;
                boolean bl = false;
                while (var6_15 < n) {
                    Type intf = typeArray[var6_15];
                    this.loadTypeDependencies(intf);
                    ++var6_15;
                }
                this.loadAnnotationAttributes(aClass.getAnnotations());
                Package aPackage = aClass.getPackage();
                if (aPackage != null) {
                    this.loadAnnotationAttributes(aPackage.getAnnotations());
                }
            }
            catch (Error e) {
                this.myVisited.remove(aClass);
                if (e instanceof LinkageError) {
                    throw new ClassNotFoundException(name, e);
                }
                throw e;
            }
            catch (RuntimeException e) {
                this.myVisited.remove(aClass);
                if (e instanceof TypeNotPresentException) {
                    throw new ClassNotFoundException(name, e);
                }
                throw e;
            }
        }
    }

    private void loadAnnotationAttributes(Annotation[] annotations) throws ClassNotFoundException {
        for (Annotation annotation : annotations) {
            this.loadAnnotationAttributes(annotation);
        }
    }

    private void loadAnnotationAttributes(Annotation annotation) throws ClassNotFoundException {
        Method[] methods;
        Class<? extends Annotation> annotationType = annotation.annotationType();
        this.loadClassDependencies(annotationType);
        for (Method method : methods = annotationType.getDeclaredMethods()) {
            try {
                method.invoke((Object)annotation, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof TypeNotPresentException) {
                    throw (TypeNotPresentException)cause;
                }
                throw new RuntimeException(e);
            }
        }
    }
}

