/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.logging.Formatter;
import org.jboss.logmanager.formatters.Formatters;
import org.jboss.logmanager.handlers.UninterruptibleOutputStream;
import org.jboss.logmanager.handlers.WriterHandler;

public class OutputStreamHandler
extends WriterHandler {
    private OutputStream outputStream;

    public OutputStreamHandler() {
        this.setFormatter(Formatters.nullFormatter());
    }

    public OutputStreamHandler(Formatter formatter) {
        this.setFormatter(formatter);
    }

    public OutputStreamHandler(OutputStream outputStream, Formatter formatter) {
        this.setFormatter(formatter);
        this.setOutputStream(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getEncoding() {
        Object object = this.outputLock;
        synchronized (object) {
            return super.getEncoding();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEncoding(String encoding) throws SecurityException, UnsupportedEncodingException {
        Object object = this.outputLock;
        synchronized (object) {
            super.setEncoding(encoding);
            if (this.outputStream != null) {
                OutputStream outputStream = this.outputStream;
                this.updateWriter(outputStream, encoding);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWriter(Writer writer) {
        Object object = this.outputLock;
        synchronized (object) {
            super.setWriter(writer);
            this.outputStream = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutputStream(OutputStream outputStream) {
        OutputStreamHandler.checkAccess(this);
        try {
            Object object = this.outputLock;
            synchronized (object) {
                this.outputStream = outputStream;
                this.updateWriter(outputStream, this.getEncoding());
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("The specified encoding is invalid");
        }
        catch (Exception e) {
            this.reportError("Error opening output stream", e, 4);
            return;
        }
    }

    private void updateWriter(OutputStream newOutputStream, String encoding) throws UnsupportedEncodingException {
        UninterruptibleOutputStream outputStream = new UninterruptibleOutputStream(newOutputStream);
        super.setWriter(newOutputStream == null ? null : (encoding == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter((OutputStream)outputStream, encoding)));
    }
}

