/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.logging.Formatter;
import org.jboss.logmanager.handlers.OutputStreamHandler;

public class FileHandler
extends OutputStreamHandler {
    private File file;
    private boolean append;

    public FileHandler() {
    }

    public FileHandler(Formatter formatter) {
        super(formatter);
    }

    public FileHandler(Formatter formatter, File file) throws FileNotFoundException {
        super(formatter);
        this.setFile(file);
    }

    public FileHandler(Formatter formatter, File file, boolean append) throws FileNotFoundException {
        super(formatter);
        this.append = append;
        this.setFile(file);
    }

    public FileHandler(File file) throws FileNotFoundException {
        this.setFile(file);
    }

    public FileHandler(File file, boolean append) throws FileNotFoundException {
        this.append = append;
        this.setFile(file);
    }

    public FileHandler(String fileName) throws FileNotFoundException {
        this.setFileName(fileName);
    }

    public FileHandler(String fileName, boolean append) throws FileNotFoundException {
        this.append = append;
        this.setFileName(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppend(boolean append) {
        Object object = this.outputLock;
        synchronized (object) {
            this.append = append;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFile(File file) throws FileNotFoundException {
        Object object = this.outputLock;
        synchronized (object) {
            if (file == null) {
                this.file = null;
                this.setOutputStream(null);
                return;
            }
            File parentFile = file.getParentFile();
            if (parentFile != null) {
                parentFile.mkdirs();
            }
            boolean ok = false;
            FileOutputStream fos = new FileOutputStream(file, this.append);
            try {
                BufferedOutputStream bos = new BufferedOutputStream(fos);
                try {
                    this.setOutputStream(bos);
                    this.file = file;
                    ok = true;
                }
                finally {
                    if (!ok) {
                        this.safeClose(bos);
                    }
                }
            }
            finally {
                if (!ok) {
                    this.safeClose(fos);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getFile() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.file;
        }
    }

    public void setFileName(String fileName) throws FileNotFoundException {
        this.setFile(fileName == null ? null : new File(fileName));
    }
}

