/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.util.formatparser.handlers;

import java.util.Collections;
import java.util.Map;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.formatparser.FormatContentHandler;
import org.jboss.galleon.util.formatparser.FormatErrors;
import org.jboss.galleon.util.formatparser.FormatParsingException;
import org.jboss.galleon.util.formatparser.ParsingFormat;
import org.jboss.galleon.util.formatparser.formats.MapParsingFormat;
import org.jboss.galleon.util.formatparser.handlers.KeyValueContentHandler;

public class MapContentHandler
extends FormatContentHandler {
    protected Map<Object, Object> map = Collections.emptyMap();

    public MapContentHandler(ParsingFormat format, int strIndex) {
        super(format, strIndex);
    }

    @Override
    public void addChild(FormatContentHandler childHandler) throws FormatParsingException {
        if (!childHandler.getFormat().getName().equals("KeyValue")) {
            throw new FormatParsingException(FormatErrors.unexpectedChildFormat(this.format, childHandler.getFormat()));
        }
        KeyValueContentHandler entry = (KeyValueContentHandler)childHandler;
        MapParsingFormat objectFormat = (MapParsingFormat)this.format;
        if (!objectFormat.isAcceptsKey(entry.key)) {
            throw new FormatParsingException(FormatErrors.unexpectedCompositeFormatElement(this.format, entry.key));
        }
        this.map = CollectionUtils.putLinked(this.map, entry.key, entry.value);
    }

    @Override
    public Object getContent() throws FormatParsingException {
        return this.map;
    }
}

