/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe.maven;

import java.nio.file.Path;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.Universe;
import org.jboss.galleon.universe.UniverseFeaturePackInstaller;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenProducer;
import org.jboss.galleon.universe.maven.MavenUniverse;
import org.jboss.galleon.universe.maven.MvnNoLocUniverse;

public class MavenFeaturePackInstaller
implements UniverseFeaturePackInstaller {
    public static final String ZIP = "zip";

    @Override
    public String getUniverseFactoryId() {
        return "maven";
    }

    @Override
    public void install(Universe<?> universe, FeaturePackLocation.FPID fpid, Path fpZip) throws ProvisioningException {
        if (MvnNoLocUniverse.class.isAssignableFrom(universe.getClass())) {
            ((MvnNoLocUniverse)universe).install(fpid, fpZip);
            return;
        }
        MavenUniverse mvnUni = (MavenUniverse)universe;
        FeaturePackLocation fps = fpid.getLocation();
        MavenProducer producer = mvnUni.getProducer(fps.getProducerName());
        producer.getChannel(fps.getChannelName());
        MavenArtifact artifact = new MavenArtifact();
        artifact.setGroupId(producer.getFeaturePackGroupId());
        artifact.setArtifactId(producer.getFeaturePackArtifactId());
        artifact.setVersion(fpid.getBuild());
        artifact.setExtension(ZIP);
        producer.getRepo().install(artifact, fpZip);
    }
}

