/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe;

import java.nio.file.Path;
import java.util.List;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.layout.FeaturePackUpdatePlan;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.LatestVersionNotAvailableException;

public interface Channel {
    public String getName();

    public String getLatestBuild(FeaturePackLocation var1) throws ProvisioningException;

    public List<String> getAllBuilds(FeaturePackLocation var1) throws ProvisioningException;

    public String getLatestBuild(FeaturePackLocation.FPID var1) throws ProvisioningException;

    public Path resolve(FeaturePackLocation var1) throws ProvisioningException;

    public boolean isResolved(FeaturePackLocation var1) throws ProvisioningException;

    default public FeaturePackUpdatePlan getUpdatePlan(FeaturePackUpdatePlan.Request updateRequest) throws ProvisioningException {
        FeaturePackLocation fpl = updateRequest.getInstalledLocation();
        String latestBuild = null;
        try {
            latestBuild = this.getLatestBuild(fpl);
        }
        catch (LatestVersionNotAvailableException latestVersionNotAvailableException) {
            // empty catch block
        }
        if (latestBuild != null && !latestBuild.isEmpty() && !latestBuild.equals(fpl.getBuild())) {
            updateRequest.setNewLocation(fpl.replaceBuild(latestBuild));
        }
        return updateRequest.buildPlan();
    }

    public boolean isDevBuild(FeaturePackLocation.FPID var1);
}

