/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.ConfigCustomizations;
import org.jboss.galleon.config.ConfigCustomizationsBuilder;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.StringUtils;

public class FeaturePackConfig
extends ConfigCustomizations {
    private final FeaturePackLocation fpl;
    protected final Boolean inheritPackages;
    protected final Set<String> excludedPackages;
    protected final Set<String> includedPackages;
    protected final boolean transitive;
    protected final List<FeaturePackLocation.FPID> patches;

    public static Builder builder(FeaturePackLocation fpl) {
        return new Builder(fpl);
    }

    public static Builder builder(FeaturePackLocation fpl, boolean inheritPackages) {
        return new Builder(fpl, inheritPackages);
    }

    public static FeaturePackConfig forLocation(FeaturePackLocation fpl) {
        return new Builder(fpl).build();
    }

    public static Builder transitiveBuilder(FeaturePackLocation fpl) {
        return new Builder(fpl, null, true);
    }

    public static Builder builder(FeaturePackConfig config) {
        return new Builder(config);
    }

    public static FeaturePackConfig forTransitiveDep(FeaturePackLocation fpl) {
        return new Builder(fpl, null, true).build();
    }

    public static String getDefaultOriginName(FeaturePackLocation fpl) {
        return fpl.getProducer().toString();
    }

    protected FeaturePackConfig(Builder builder) {
        super(builder);
        assert (builder.fpl != null) : "location is null";
        this.fpl = builder.fpl;
        this.inheritPackages = builder.inheritPackages;
        this.excludedPackages = CollectionUtils.unmodifiable(builder.excludedPackages);
        this.includedPackages = CollectionUtils.unmodifiable(builder.includedPackages);
        this.transitive = builder.transitive;
        switch (builder.patches.size()) {
            case 0: {
                this.patches = Collections.emptyList();
                break;
            }
            case 1: {
                this.patches = Collections.singletonList(builder.patches.iterator().next());
                break;
            }
            default: {
                ArrayList<FeaturePackLocation.FPID> tmp = new ArrayList<FeaturePackLocation.FPID>(builder.patches.size());
                for (FeaturePackLocation.FPID fpid : builder.patches) {
                    tmp.add(fpid);
                }
                this.patches = Collections.unmodifiableList(tmp);
            }
        }
    }

    public FeaturePackLocation getLocation() {
        return this.fpl;
    }

    public boolean isTransitive() {
        return this.transitive;
    }

    public boolean hasPatches() {
        return !this.patches.isEmpty();
    }

    public List<FeaturePackLocation.FPID> getPatches() {
        return this.patches;
    }

    public Boolean getInheritPackages() {
        return this.inheritPackages;
    }

    public boolean isInheritPackages(boolean defaultValue) {
        return this.inheritPackages == null ? defaultValue : this.inheritPackages;
    }

    public boolean hasIncludedPackages() {
        return !this.includedPackages.isEmpty();
    }

    public boolean isPackageIncluded(String packageName) {
        return this.includedPackages.contains(packageName);
    }

    public Collection<String> getIncludedPackages() {
        return this.includedPackages;
    }

    public boolean hasExcludedPackages() {
        return !this.excludedPackages.isEmpty();
    }

    public boolean isPackageExcluded(String packageName) {
        return this.excludedPackages.contains(packageName);
    }

    public Set<String> getExcludedPackages() {
        return this.excludedPackages;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.excludedPackages == null ? 0 : this.excludedPackages.hashCode());
        result = 31 * result + (this.fpl == null ? 0 : this.fpl.hashCode());
        result = 31 * result + (this.includedPackages == null ? 0 : this.includedPackages.hashCode());
        result = 31 * result + (this.inheritPackages == null ? 0 : this.inheritPackages.hashCode());
        result = 31 * result + (this.patches == null ? 0 : this.patches.hashCode());
        result = 31 * result + (this.transitive ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeaturePackConfig other = (FeaturePackConfig)obj;
        if (this.excludedPackages == null ? other.excludedPackages != null : !this.excludedPackages.equals(other.excludedPackages)) {
            return false;
        }
        if (this.fpl == null ? other.fpl != null : !this.fpl.equals(other.fpl)) {
            return false;
        }
        if (this.includedPackages == null ? other.includedPackages != null : !this.includedPackages.equals(other.includedPackages)) {
            return false;
        }
        if (this.inheritPackages == null ? other.inheritPackages != null : !this.inheritPackages.equals(other.inheritPackages)) {
            return false;
        }
        if (this.patches == null ? other.patches != null : !this.patches.equals(other.patches)) {
            return false;
        }
        return this.transitive == other.transitive;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        if (this.transitive) {
            buf.append("transitive ");
        }
        buf.append(this.fpl.toString());
        if (!this.patches.isEmpty()) {
            StringUtils.append(buf.append(" patches="), this.patches);
        }
        if (this.inheritPackages != null) {
            buf.append(" inherit-packages=").append(this.inheritPackages);
        }
        if (!this.excludedPackages.isEmpty()) {
            StringUtils.append(buf.append(" excludedPackages="), this.excludedPackages);
        }
        if (!this.includedPackages.isEmpty()) {
            StringUtils.append(buf.append(" includedPackages="), this.includedPackages);
        }
        this.append(buf);
        return buf.append(']').toString();
    }

    public static class Builder
    extends ConfigCustomizationsBuilder<Builder> {
        protected final FeaturePackLocation fpl;
        protected Boolean inheritPackages;
        protected boolean transitive;
        protected Set<String> excludedPackages = Collections.emptySet();
        protected Set<String> includedPackages = Collections.emptySet();
        protected Set<FeaturePackLocation.FPID> patches = Collections.emptySet();

        protected Builder(FeaturePackLocation fpl) {
            this(fpl, null);
        }

        protected Builder(FeaturePackLocation fpl, Boolean inheritPackages) {
            this(fpl, inheritPackages, false);
        }

        protected Builder(FeaturePackLocation fpl, Boolean inheritPackages, boolean transitive) {
            this.fpl = fpl;
            this.inheritPackages = inheritPackages;
            this.transitive = transitive;
        }

        protected Builder(FeaturePackConfig config) {
            this.fpl = config.getLocation();
            this.init(config);
        }

        public Builder init(FeaturePackConfig fpConfig) {
            super.initConfigs(fpConfig);
            this.inheritPackages = fpConfig.inheritPackages;
            this.excludedPackages = CollectionUtils.clone(fpConfig.excludedPackages);
            this.includedPackages = CollectionUtils.clone(fpConfig.includedPackages);
            this.transitive = fpConfig.transitive;
            if (!fpConfig.patches.isEmpty()) {
                if (fpConfig.patches.size() == 1) {
                    this.patches = Collections.singleton(fpConfig.patches.get(0));
                } else {
                    this.patches = new LinkedHashSet<FeaturePackLocation.FPID>(fpConfig.patches.size());
                    for (FeaturePackLocation.FPID patchId : fpConfig.patches) {
                        this.patches.add(patchId);
                    }
                }
            }
            return this;
        }

        public Builder addPatch(FeaturePackLocation.FPID patchId) throws ProvisioningDescriptionException {
            int size = this.patches.size();
            this.patches = CollectionUtils.addLinked(this.patches, patchId);
            if (size == this.patches.size()) {
                throw new ProvisioningDescriptionException("Patch " + patchId + " has already been configured for " + this.fpl);
            }
            return this;
        }

        public Builder removePatch(FeaturePackLocation.FPID patchId) throws ProvisioningDescriptionException {
            int size = this.patches.size();
            this.patches = CollectionUtils.remove(this.patches, patchId);
            if (size == this.patches.size()) {
                throw new ProvisioningDescriptionException("Patch " + patchId + " was not configured for " + this.fpl);
            }
            return this;
        }

        public Builder setInheritPackages(boolean inheritSelectedPackages) {
            this.inheritPackages = inheritSelectedPackages;
            return this;
        }

        public Builder excludePackage(String packageName) throws ProvisioningDescriptionException {
            if (this.includedPackages.contains(packageName)) {
                throw new ProvisioningDescriptionException(Errors.packageExcludeInclude(packageName));
            }
            this.excludedPackages = CollectionUtils.add(this.excludedPackages, packageName);
            return this;
        }

        public Builder removeExcludedPackage(String pkg) throws ProvisioningDescriptionException {
            if (!this.excludedPackages.contains(pkg)) {
                throw new ProvisioningDescriptionException("Package " + pkg + " is not excluded from the configuration");
            }
            this.excludedPackages = CollectionUtils.remove(this.excludedPackages, pkg);
            return this;
        }

        public Builder excludeAllPackages(Collection<String> packageNames) throws ProvisioningDescriptionException {
            for (String packageName : packageNames) {
                this.excludePackage(packageName);
            }
            return this;
        }

        public boolean isPackageExcluded(String packageName) {
            return this.excludedPackages.contains(packageName);
        }

        public Builder includeAllPackages(Collection<String> packageNames) throws ProvisioningDescriptionException {
            for (String packageName : packageNames) {
                this.includePackage(packageName);
            }
            return this;
        }

        public Builder includePackage(String packageName) throws ProvisioningDescriptionException {
            if (this.excludedPackages.contains(packageName)) {
                throw new ProvisioningDescriptionException(Errors.packageExcludeInclude(packageName));
            }
            this.includedPackages = CollectionUtils.add(this.includedPackages, packageName);
            return this;
        }

        public Builder removeIncludedPackage(String pkg) throws ProvisioningDescriptionException {
            if (!this.includedPackages.contains(pkg)) {
                throw new ProvisioningDescriptionException("Package " + pkg + " is not included into the configuration");
            }
            this.includedPackages = CollectionUtils.remove(this.includedPackages, pkg);
            return this;
        }

        public boolean isPackageIncluded(String packageName) {
            return this.includedPackages.contains(packageName);
        }

        @Override
        public Builder addConfig(ConfigModel config) throws ProvisioningDescriptionException {
            if (this.transitive) {
                this.transitiveDoesNotDefineConfigs();
            }
            return (Builder)super.addConfig(config);
        }

        @Override
        public Builder removeConfig(ConfigId id) throws ProvisioningDescriptionException {
            if (this.transitive) {
                this.transitiveDoesNotDefineConfigs();
            }
            return (Builder)super.removeConfig(id);
        }

        private void transitiveDoesNotDefineConfigs() throws ProvisioningDescriptionException {
            throw new ProvisioningDescriptionException("Transitive dependency does not define configs");
        }

        public FeaturePackConfig build() {
            return new FeaturePackConfig(this);
        }
    }
}

