/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.maingrp;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Option;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.UniverseManager;
import org.jboss.galleon.cli.Util;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.CommandDomain;
import org.jboss.galleon.cli.cmd.Table;
import org.jboss.galleon.cli.cmd.maingrp.FindCommand;
import org.jboss.galleon.cli.cmd.state.StateInfoUtil;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.Producer;
import org.jboss.galleon.universe.UniverseSpec;

@CommandDefinition(name="list-feature-packs", description="List latest available feature packs for the default frequency")
public class ListFeaturePacksCommand
extends PmSessionCommand {
    private static final String NONE = "NONE";
    @Option(required=false, name="universe", description="Provide a universe id in order to list feature packs located in not installed universe")
    private String fromUniverse;
    @Option(required=false, name="all-frequencies", hasValue=false, description="Display the latest builds for all frequencies")
    private Boolean allFrequencies;

    @Override
    public void runCommand(final PmCommandInvocation invoc) throws CommandExecutionException {
        final HashMap tables = new HashMap();
        final HashMap<UniverseSpec, Set<String>> exceptions = new HashMap<UniverseSpec, Set<String>>();
        Path installation = null;
        try {
            installation = Util.lookupInstallationDir(invoc.getConfiguration().getAeshContext(), null);
        }
        catch (ProvisioningException provisioningException) {
            // empty catch block
        }
        final Path finalPath = installation;
        UniverseManager.UniverseVisitor visitor = new UniverseManager.UniverseVisitor(){

            @Override
            public void visit(Producer<?> producer, FeaturePackLocation loc) {
                if (loc.getFrequency() == null) {
                    return;
                }
                if (ListFeaturePacksCommand.this.allFrequencies.booleanValue() || loc.getFrequency().equals(producer.getDefaultFrequency())) {
                    Table table = (Table)tables.get(loc.getUniverse());
                    if (table == null) {
                        table = new Table("Product", "Update Channel", "Latest Build");
                        tables.put(loc.getUniverse(), table);
                    }
                    loc = invoc.getPmSession().getExposedLocation(finalPath, loc);
                    table.addLine(producer.getName(), StateInfoUtil.formatChannel(loc), loc.getBuild() == null ? ListFeaturePacksCommand.NONE : loc.getBuild());
                }
            }

            @Override
            public void exception(UniverseSpec spec, Exception ex) {
                HashSet<String> set = (HashSet<String>)exceptions.get(spec);
                if (set == null) {
                    set = new HashSet<String>();
                    exceptions.put(spec, set);
                }
                set.add(ex.getLocalizedMessage() == null ? ex.getMessage() : ex.getLocalizedMessage());
            }
        };
        try {
            if (this.fromUniverse != null) {
                invoc.getPmSession().getUniverse().visitUniverse(UniverseSpec.fromString(this.fromUniverse), visitor, true);
            } else {
                invoc.getPmSession().getUniverse().visitAllUniverses(visitor, true, finalPath);
            }
        }
        catch (ProvisioningException ex) {
            throw new CommandExecutionException(invoc.getPmSession(), CliErrors.resolvedUniverseFailed(), ex);
        }
        FindCommand.printExceptions(invoc, exceptions);
        for (Map.Entry entry : tables.entrySet()) {
            Table table = (Table)entry.getValue();
            table.sort(Table.SortType.ASCENDANT);
            invoc.println(table.build());
        }
    }

    @Override
    public CommandDomain getDomain() {
        return CommandDomain.PROVISIONING;
    }
}

