/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.repository.internal;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.maven.shared.artifact.ArtifactCoordinate;
import org.apache.maven.shared.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.repository.RepositoryManager;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

@Component(role=RepositoryManager.class)
public class DefaultRepositoryManager
implements RepositoryManager,
Contextualizable {
    private PlexusContainer container;

    @Override
    public String getPathForLocalArtifact(ProjectBuildingRequest buildingRequest, Artifact artifact) {
        try {
            String hint = DefaultRepositoryManager.isMaven31() ? "maven31" : "maven3";
            RepositoryManager effectiveRepositoryManager = (RepositoryManager)this.container.lookup(RepositoryManager.class, hint);
            return effectiveRepositoryManager.getPathForLocalArtifact(buildingRequest, artifact);
        }
        catch (ComponentLookupException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public String getPathForLocalArtifact(ProjectBuildingRequest buildingRequest, ArtifactCoordinate coor) {
        try {
            String hint = DefaultRepositoryManager.isMaven31() ? "maven31" : "maven3";
            RepositoryManager effectiveRepositoryManager = (RepositoryManager)this.container.lookup(RepositoryManager.class, hint);
            return effectiveRepositoryManager.getPathForLocalArtifact(buildingRequest, coor);
        }
        catch (ComponentLookupException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public String getPathForLocalMetadata(ProjectBuildingRequest buildingRequest, ArtifactMetadata metadata) {
        if (metadata instanceof ProjectArtifactMetadata) {
            DefaultArtifactCoordinate pomCoordinate = new DefaultArtifactCoordinate();
            pomCoordinate.setGroupId(metadata.getGroupId());
            pomCoordinate.setArtifactId(metadata.getArtifactId());
            pomCoordinate.setVersion(metadata.getBaseVersion());
            pomCoordinate.setExtension("pom");
            return this.getPathForLocalArtifact(buildingRequest, pomCoordinate);
        }
        try {
            String hint = DefaultRepositoryManager.isMaven31() ? "maven31" : "maven3";
            RepositoryManager effectiveRepositoryManager = (RepositoryManager)this.container.lookup(RepositoryManager.class, hint);
            return effectiveRepositoryManager.getPathForLocalMetadata(buildingRequest, metadata);
        }
        catch (ComponentLookupException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public ProjectBuildingRequest setLocalRepositoryBasedir(ProjectBuildingRequest request, File basedir) {
        try {
            String hint = DefaultRepositoryManager.isMaven31() ? "maven31" : (DefaultRepositoryManager.isMaven302() ? "maven302" : "maven3");
            RepositoryManager effectiveRepositoryManager = (RepositoryManager)this.container.lookup(RepositoryManager.class, hint);
            return effectiveRepositoryManager.setLocalRepositoryBasedir(request, basedir);
        }
        catch (ComponentLookupException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public File getLocalRepositoryBasedir(ProjectBuildingRequest request) {
        try {
            String hint = DefaultRepositoryManager.isMaven31() ? "maven31" : (DefaultRepositoryManager.isMaven302() ? "maven302" : "maven3");
            RepositoryManager effectiveRepositoryManager = (RepositoryManager)this.container.lookup(RepositoryManager.class, hint);
            return effectiveRepositoryManager.getLocalRepositoryBasedir(request);
        }
        catch (ComponentLookupException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    protected static boolean isMaven31() {
        return DefaultRepositoryManager.canFindCoreClass("org.eclipse.aether.artifact.Artifact");
    }

    protected static boolean isMaven302() {
        return DefaultRepositoryManager.canFindCoreClass("org.sonatype.aether.spi.localrepo.LocalRepositoryManagerFactory");
    }

    private static boolean canFindCoreClass(String className) {
        try {
            Thread.currentThread().getContextClassLoader().loadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }
}

