/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.sound;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.sf.freecol.common.option.AudioMixerOption;
import net.sf.freecol.common.option.PercentageOption;
import net.sf.freecol.common.sound.OggVorbisDecoderFactory;
import net.sf.freecol.common.util.Utils;

public final class SoundPlayer {
    private static final Logger logger = Logger.getLogger(SoundPlayer.class.getName());
    private Mixer mixer;
    private int volume;
    private final SoundPlayerThread soundPlayerThread;
    private List<File> defaultPlayList = new ArrayList<File>();
    private PercentageOption volumeOption;

    public SoundPlayer(AudioMixerOption mixerOption, PercentageOption volumeOption) {
        this.setMixer(mixerOption.getValue());
        mixerOption.addPropertyChangeListener(e -> this.setMixer((AudioMixerOption.MixerWrapper)e.getNewValue()));
        this.setVolume(volumeOption.getValue());
        this.volumeOption = volumeOption;
        this.soundPlayerThread = new SoundPlayerThread();
        this.soundPlayerThread.setPriority(10);
        this.soundPlayerThread.start();
    }

    public Mixer getMixer() {
        return this.mixer;
    }

    private void setMixer(AudioMixerOption.MixerWrapper mw) {
        try {
            this.mixer = AudioSystem.getMixer(mw.getMixerInfo());
            logger.info("Mixer " + mw + " selected");
        }
        catch (Exception e) {
            this.mixer = null;
            logger.log(Level.WARNING, "Bad mixer: " + mw + ", sound suspended", e);
        }
    }

    public int getVolume() {
        return this.volume;
    }

    private void setVolume(int volume) {
        this.volume = volume;
    }

    public boolean playOnce(File file) {
        if (this.getMixer() == null) {
            return false;
        }
        this.soundPlayerThread.add(file);
        return true;
    }

    public void setDefaultPlaylist(File ... files) {
        ArrayList<File> newDefaultPlayList = new ArrayList<File>(List.of(files));
        this.defaultPlayList = newDefaultPlayList;
    }

    public void stop() {
        this.soundPlayerThread.stopPlaying();
    }

    public static AudioInputStream getAudioInputStream(File file) throws IOException {
        AudioInputStream in;
        if (file.getName().endsWith(".ogg")) {
            in = new OggVorbisDecoderFactory().getOggStream(file);
        } else {
            try {
                in = AudioSystem.getAudioInputStream(file);
            }
            catch (UnsupportedAudioFileException uafe) {
                throw new IOException(uafe);
            }
        }
        return in;
    }

    private static void changeVolume(SourceDataLine line, int vol) {
        FloatControl control;
        FloatControl.Type type;
        FloatControl.Type type2 = line.isControlSupported(FloatControl.Type.VOLUME) ? FloatControl.Type.VOLUME : (type = line.isControlSupported(FloatControl.Type.MASTER_GAIN) ? FloatControl.Type.MASTER_GAIN : null);
        if (type == null) {
            logger.warning("No volume or master gain controls.");
            return;
        }
        try {
            control = (FloatControl)line.getControl(type);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        float min = control.getMinimum();
        float max = control.getMaximum();
        float gain = vol <= 0 ? min : (vol >= 100 ? max : min + 0.5f * (max - min) * (float)Math.log10(vol));
        try {
            control.setValue(gain);
            logger.finest("Using volume " + vol + "%, " + control.getUnits() + "=" + gain + " control=" + type);
        }
        catch (IllegalArgumentException ie) {
            logger.log(Level.WARNING, "Could not set volume  (control=" + type + " in [" + min + "," + max + "]) to " + gain + control.getUnits(), ie);
        }
    }

    private static SourceDataLine openLine(AudioFormat audioFormat, Mixer mixer, int len) {
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        if (mixer == null) {
            logger.log(Level.WARNING, "Null mixer");
            return null;
        }
        if (!mixer.isLineSupported(info)) {
            logger.log(Level.WARNING, "Mixer does not support " + info);
            return null;
        }
        SourceDataLine line = null;
        try {
            line = (SourceDataLine)mixer.getLine(info);
            line.open(audioFormat, len);
        }
        catch (IllegalArgumentException | SecurityException | LineUnavailableException e) {
            logger.log(Level.WARNING, "Can not open SourceDataLine", e);
            return null;
        }
        line.start();
        return line;
    }

    private class SoundPlayerThread
    extends Thread {
        private static final int WAIT_TIMEOUT = 100;
        private final byte[] data;
        private final List<File> playList;
        private volatile boolean playDone;

        public SoundPlayerThread() {
            super("FreeColClient:SoundPlayer");
            this.data = new byte[16384];
            this.playList = new ArrayList<File>();
            this.playDone = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopPlaying() {
            this.playDone = true;
            List<File> list = this.playList;
            synchronized (list) {
                this.playList.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(File sound) {
            List<File> list = this.playList;
            synchronized (list) {
                this.playList.add(sound);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File remove() {
            List<File> list = this.playList;
            synchronized (list) {
                return this.playList.isEmpty() ? null : this.playList.remove(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean playSound(File sound) throws IOException {
            PropertyChangeListener volumeListener;
            boolean ret;
            block21: {
                boolean bl;
                block19: {
                    SoundPlayer.this.setVolume(SoundPlayer.this.volumeOption.getValue());
                    ret = false;
                    volumeListener = null;
                    try {
                        try (AudioInputStream in = SoundPlayer.getAudioInputStream(sound);){
                            SourceDataLine line = SoundPlayer.openLine(in.getFormat(), SoundPlayer.this.getMixer(), this.data.length);
                            if (line == null) {
                                bl = false;
                                if (volumeListener == null) return bl;
                                break block19;
                            }
                            volumeListener = e -> {
                                SoundPlayer.this.setVolume((Integer)e.getNewValue());
                                SoundPlayer.changeVolume(line, SoundPlayer.this.getVolume());
                            };
                            SoundPlayer.this.volumeOption.addPropertyChangeListener(volumeListener);
                            SoundPlayer.changeVolume(line, SoundPlayer.this.getVolume());
                            try {
                                int rd;
                                this.playDone = false;
                                while (!this.playDone && (rd = in.read(this.data)) > 0) {
                                    line.write(this.data, 0, rd);
                                }
                                ret = true;
                            }
                            finally {
                                this.playDone = true;
                                line.drain();
                                line.stop();
                                line.close();
                            }
                        }
                        if (volumeListener == null) return ret;
                        break block21;
                    }
                    catch (IOException ioe) {
                        logger.log(Level.WARNING, "Can not open " + sound + " as audio stream", ioe);
                        boolean bl2 = false;
                        return bl2;
                    }
                }
                SoundPlayer.this.volumeOption.removePropertyChangeListener(volumeListener);
                return bl;
            }
            SoundPlayer.this.volumeOption.removePropertyChangeListener(volumeListener);
            return ret;
            finally {
                if (volumeListener != null) {
                    SoundPlayer.this.volumeOption.removePropertyChangeListener(volumeListener);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                File sound;
                if ((sound = this.remove()) == null) {
                    if (!SoundPlayer.this.defaultPlayList.isEmpty()) {
                        List<File> list = this.playList;
                        synchronized (list) {
                            this.playList.addAll(SoundPlayer.this.defaultPlayList);
                            Collections.shuffle(this.playList);
                        }
                        sound = this.remove();
                    } else {
                        Utils.delay(100L, null);
                    }
                }
                if (sound == null) continue;
                try {
                    this.playSound(sound);
                    continue;
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Failure playing audio.", e);
                    continue;
                }
                break;
            }
        }
    }
}

