/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.Feature;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.LastSale;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.ObjectMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;

public class FeatureChangeMessage
extends ObjectMessage {
    public static final String TAG = "featureChange";
    private static final String ADD_TAG = "add";
    private static final String ID_TAG = "id";

    public FeatureChangeMessage(FreeColGameObject fcgo, FreeColObject fco, boolean add) {
        super(TAG, ID_TAG, fcgo.getId(), ADD_TAG, String.valueOf(add));
        this.appendChild(fco);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeatureChangeMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, ID_TAG, ADD_TAG);
        ArrayList<Feature> fcos = new ArrayList<Feature>();
        FreeColXMLReader.ReadScope rs = xr.replaceScope(FreeColXMLReader.ReadScope.NOINTERN);
        try {
            while (xr.moreTags()) {
                String tag = xr.getLocalName();
                FreeColObject fco = null;
                if ("ability".equals(tag)) {
                    fco = new Ability(game.getSpecification());
                    fco.readFromXML(xr);
                } else if ("modifier".equals(tag)) {
                    fco = new Modifier(game.getSpecification());
                    fco.readFromXML(xr);
                } else if ("historyEvent".equals(tag)) {
                    fco = new HistoryEvent();
                    fco.readFromXML(xr);
                } else if ("lastSale".equals(tag)) {
                    fco = new LastSale();
                    fco.readFromXML(xr);
                } else if ("modelMessage".equals(tag)) {
                    fco = new ModelMessage();
                    fco.readFromXML(xr);
                } else {
                    this.expected("Feature", tag);
                }
                fcos.add((Feature)fco);
                xr.expectTag(tag);
            }
            xr.expectTag(TAG);
            this.setChildren(fcos);
        }
        finally {
            xr.replaceScope(rs);
        }
    }

    private String getParentId() {
        return this.getStringAttribute(ID_TAG);
    }

    private FreeColGameObject getParent(Game game) {
        return game.getFreeColGameObject(this.getParentId());
    }

    private boolean getAdd() {
        return this.getBooleanAttribute(ADD_TAG, Boolean.FALSE);
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.OWNED;
    }

    @Override
    public boolean merge(Message message) {
        if (message instanceof FeatureChangeMessage) {
            FeatureChangeMessage other = (FeatureChangeMessage)message;
            if (this.getParentId().equals(other.getParentId()) && this.getAdd() == other.getAdd()) {
                this.appendChildren(other.getChildren());
                return true;
            }
        }
        return false;
    }

    @Override
    public void aiHandler(FreeColServer freeColServer, AIPlayer aiPlayer) {
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        Game game = freeColClient.getGame();
        FreeColGameObject parent = this.getParent(game);
        List<FreeColObject> children = this.getChildren();
        boolean add = this.getAdd();
        if (parent == null) {
            logger.warning("featureChange with null parent.");
            return;
        }
        if (children.isEmpty()) {
            logger.warning("featureChange with no children.");
            return;
        }
        this.igc(freeColClient).featureChangeHandler(parent, children, add);
        this.clientGeneric(freeColClient);
    }
}

