/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.ObjectMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;

public class DeliverGiftMessage
extends ObjectMessage {
    public static final String TAG = "deliverGift";
    private static final String SETTLEMENT_TAG = "settlement";
    private static final String UNIT_TAG = "unit";

    public DeliverGiftMessage(Unit unit, IndianSettlement is, Goods goods) {
        super(TAG, UNIT_TAG, unit.getId(), SETTLEMENT_TAG, is.getId());
        this.appendChild(goods);
    }

    public DeliverGiftMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, UNIT_TAG, SETTLEMENT_TAG);
        Goods goods = null;
        while (xr.moreTags()) {
            String tag = xr.getLocalName();
            if ("goods".equals(tag)) {
                if (goods == null) {
                    goods = xr.readFreeColObject(game, Goods.class);
                } else {
                    this.expected(TAG, tag);
                }
            } else {
                this.expected("goods", tag);
            }
            xr.expectTag(tag);
        }
        xr.expectTag(TAG);
        this.appendChild(goods);
    }

    private Goods getGoods() {
        return this.getChild(0, Goods.class);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        IndianSettlement is;
        Unit unit;
        String unitId = this.getStringAttribute(UNIT_TAG);
        try {
            unit = serverPlayer.getOurFreeColGameObject(unitId, Unit.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        try {
            is = unit.getAdjacentSettlement(this.getStringAttribute(SETTLEMENT_TAG), IndianSettlement.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        Goods goods = this.getGoods();
        if (goods == null) {
            return serverPlayer.clientError("No goods found");
        }
        if (goods.getLocation() != unit) {
            return serverPlayer.clientError("Gift " + goods.getId() + " is not with unit " + unitId);
        }
        return this.igc(freeColServer).deliverGiftToSettlement(serverPlayer, (ServerUnit)unit, is, goods);
    }
}

