/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.util.test.FreeColTestCase;

public class GameTest
extends FreeColTestCase {
    public void testGame() throws FreeColException {
        Game game = GameTest.getStandardGame();
        game.changeMap(GameTest.getTestMap());
        Nation dutchNation = GameTest.spec().getNation("model.nation.dutch");
        game.addPlayer(new ServerPlayer(game, false, dutchNation));
    }

    public void testAddPlayer() {
        ServerGame game = new ServerGame(GameTest.spec());
        NationOptions defaultOptions = new NationOptions(GameTest.spec());
        game.setNationOptions(defaultOptions);
        ArrayList<Player> players = new ArrayList<Player>();
        int counter = 0;
        for (Nation n : GameTest.spec().getNations()) {
            if (defaultOptions.getNationState(n) == NationOptions.NationState.NOT_AVAILABLE) {
                ++counter;
                continue;
            }
            ServerPlayer p = new ServerPlayer(game, false, n);
            p.setAI(!n.getType().isEuropean() || n.getType().isREF());
            game.addPlayer(p);
            players.add(p);
        }
        players.sort(Player.playerComparator);
        game.sortPlayers(Player.playerComparator);
        GameTest.assertEquals((int)(GameTest.spec().getNations().size() - counter), (int)CollectionUtils.count(game.getPlayerList(CollectionUtils.alwaysTrue())));
        GameTest.assertEquals(players, game.getPlayerList(CollectionUtils.alwaysTrue()));
    }

    public void testTurn() {
        GameTest.assertEquals((int)1492, (int)Turn.getStartingYear());
        GameTest.assertEquals((int)1600, (int)Turn.getSeasonYear());
        GameTest.assertEquals((int)2, (int)Turn.getSeasonNumber());
        GameTest.assertEquals((int)1492, (int)Turn.getTurnYear(1));
        GameTest.assertEquals((int)1, (int)Turn.yearToTurn(1492));
        GameTest.assertEquals((int)-1, (int)Turn.getTurnSeason(1));
        GameTest.assertEquals((int)0, (int)GameTest.spec().getAge(new Turn(1)));
        GameTest.assertEquals((int)1599, (int)Turn.getTurnYear(108));
        GameTest.assertEquals((int)108, (int)Turn.yearToTurn(1599));
        GameTest.assertEquals((int)-1, (int)Turn.getTurnSeason(108));
        GameTest.assertEquals((int)0, (int)GameTest.spec().getAge(new Turn(108)));
        GameTest.assertEquals((int)1600, (int)Turn.getTurnYear(109));
        GameTest.assertEquals((int)109, (int)Turn.yearToTurn(1600, 0));
        GameTest.assertEquals((int)0, (int)Turn.getTurnSeason(109));
        GameTest.assertEquals((int)1, (int)GameTest.spec().getAge(new Turn(109)));
        GameTest.assertEquals((int)1600, (int)Turn.getTurnYear(110));
        GameTest.assertEquals((int)110, (int)Turn.yearToTurn(1600, 1));
        GameTest.assertEquals((int)1, (int)Turn.getTurnSeason(110));
        GameTest.assertEquals((int)1, (int)GameTest.spec().getAge(new Turn(308)));
        GameTest.assertEquals((int)1700, (int)Turn.getTurnYear(309));
        GameTest.assertEquals((int)309, (int)Turn.yearToTurn(1700, 0));
        GameTest.assertEquals((int)0, (int)Turn.getTurnSeason(309));
        GameTest.assertEquals((int)2, (int)GameTest.spec().getAge(new Turn(309)));
        GameTest.assertEquals((int)1700, (int)Turn.getTurnYear(310));
        GameTest.assertEquals((int)310, (int)Turn.yearToTurn(1700, 1));
        GameTest.assertEquals((int)1, (int)Turn.getTurnSeason(310));
    }
}

