/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.action;

import java.awt.event.ActionEvent;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.action.MapboardAction;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Unit;

public class LoadAction
extends MapboardAction {
    public static final String id = "loadAction";

    public LoadAction(FreeColClient freeColClient) {
        super(freeColClient, id);
    }

    @Override
    protected boolean shouldBeEnabled() {
        Unit carrier = this.getGUI().getActiveUnit();
        return carrier != null && carrier.isCarrier() && carrier.hasSpaceLeft() && super.shouldBeEnabled();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Unit unit = this.getGUI().getActiveUnit();
        if (unit == null) {
            return;
        }
        Colony colony = unit.getColony();
        if (colony == null) {
            return;
        }
        for (Goods goods : unit.getCompactGoodsList()) {
            GoodsType type = goods.getType();
            int loadable = unit.getLoadableAmount(type);
            int present = colony.getGoodsCount(type);
            if (loadable <= 0 || present <= 0) continue;
            int n = Math.min(Math.min(loadable, present), 100);
            this.igc().loadCargo(new Goods(goods.getGame(), colony, type, n), unit);
        }
    }
}

