/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.helper.model;

import org.traccar.api.security.PermissionsService;
import org.traccar.config.Config;
import org.traccar.config.ConfigKey;
import org.traccar.config.KeyType;
import org.traccar.config.Keys;
import org.traccar.model.Device;
import org.traccar.model.Group;
import org.traccar.model.Server;
import org.traccar.session.cache.CacheManager;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

public final class AttributeUtil {
    private AttributeUtil() {
    }

    public static <T> T lookup(CacheManager cacheManager, ConfigKey<T> key, long deviceId) {
        return AttributeUtil.lookup(new CacheProvider(cacheManager, deviceId), key);
    }

    public static <T> T lookup(Provider provider, ConfigKey<T> key) {
        Device device = provider.getDevice();
        Object result = device.getAttributes().get(key.getKey());
        long groupId = device.getGroupId();
        while (result == null && groupId > 0L) {
            Group group = provider.getGroup(groupId);
            if (group != null) {
                result = group.getAttributes().get(key.getKey());
                groupId = group.getGroupId();
                continue;
            }
            groupId = 0L;
        }
        if (result == null && key.hasType(KeyType.SERVER)) {
            result = provider.getServer().getAttributes().get(key.getKey());
        }
        if (result == null && key.hasType(KeyType.CONFIG)) {
            result = provider.getConfig().getString(key.getKey());
        }
        if (result != null) {
            Class<T> valueClass = key.getValueClass();
            if (valueClass.equals(Boolean.class)) {
                return (T)(result instanceof String ? Boolean.valueOf(Boolean.parseBoolean((String)result)) : result);
            }
            if (valueClass.equals(Integer.class)) {
                return (T)Integer.valueOf(result instanceof String ? Integer.parseInt((String)result) : ((Number)result).intValue());
            }
            if (valueClass.equals(Long.class)) {
                return (T)Long.valueOf(result instanceof String ? Long.parseLong((String)result) : ((Number)result).longValue());
            }
            if (valueClass.equals(Double.class)) {
                return (T)Double.valueOf(result instanceof String ? Double.parseDouble((String)result) : ((Number)result).doubleValue());
            }
            return (T)result;
        }
        return key.getDefaultValue();
    }

    public static String getDevicePassword(CacheManager cacheManager, long deviceId, String protocol, String defaultPassword) {
        String password = AttributeUtil.lookup(cacheManager, Keys.DEVICE_PASSWORD, deviceId);
        if (password != null) {
            return password;
        }
        if (protocol != null && (password = cacheManager.getConfig().getString(Keys.PROTOCOL_DEVICE_PASSWORD.withPrefix(protocol))) != null) {
            return password;
        }
        return defaultPassword;
    }

    public static class CacheProvider
    implements Provider {
        private final CacheManager cacheManager;
        private final long deviceId;

        public CacheProvider(CacheManager cacheManager, long deviceId) {
            this.cacheManager = cacheManager;
            this.deviceId = deviceId;
        }

        @Override
        public Device getDevice() {
            return this.cacheManager.getObject(Device.class, this.deviceId);
        }

        @Override
        public Group getGroup(long groupId) {
            return this.cacheManager.getObject(Group.class, groupId);
        }

        @Override
        public Server getServer() {
            return this.cacheManager.getServer();
        }

        @Override
        public Config getConfig() {
            return this.cacheManager.getConfig();
        }
    }

    public static interface Provider {
        public Device getDevice();

        public Group getGroup(long var1);

        public Server getServer();

        public Config getConfig();
    }

    public static class StorageProvider
    implements Provider {
        private final Config config;
        private final Storage storage;
        private final PermissionsService permissionsService;
        private final Device device;

        public StorageProvider(Config config, Storage storage, PermissionsService permissionsService, Device device) {
            this.config = config;
            this.storage = storage;
            this.permissionsService = permissionsService;
            this.device = device;
        }

        @Override
        public Device getDevice() {
            return this.device;
        }

        @Override
        public Group getGroup(long groupId) {
            try {
                return this.storage.getObject(Group.class, new Request((Columns)new Columns.All(), new Condition.Equals("id", groupId)));
            }
            catch (StorageException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Server getServer() {
            try {
                return this.permissionsService.getServer();
            }
            catch (StorageException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Config getConfig() {
            return this.config;
        }
    }
}

