/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.downloader;

import java.net.URL;
import org.netbeans.installer.downloader.DownloadListener;
import org.netbeans.installer.downloader.DownloadManager;
import org.netbeans.installer.downloader.Pumping;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.helper.Pair;
import org.netbeans.installer.utils.progress.Progress;

public class DownloadProgress
implements DownloadListener {
    private Progress progress;
    private URL targetUrl;
    public static final String PUMPING_UPDATED_KEY = "DP.pumping.updated";
    public static final String PUMPING_STATE_CHANGED_KEY = "DP.pumping.state.changed";

    public DownloadProgress(Progress progress, URL targetUrl) {
        this.progress = progress;
        this.targetUrl = targetUrl;
    }

    @Override
    public void pumpingUpdate(String id) {
        Pumping pumping = DownloadManager.instance.queue().getById(id);
        if (this.progress == null || !this.targetUrl.equals(pumping.declaredURL())) {
            return;
        }
        this.progress.setDetail(ResourceUtils.getString(DownloadProgress.class, PUMPING_UPDATED_KEY, pumping.declaredURL()));
        if (pumping.length() > 0L) {
            long length = pumping.length();
            long per = 0L;
            for (Pumping.Section section : pumping.getSections()) {
                Pair<Long, Long> pair = section.getRange();
                per += section.offset() - pair.getFirst();
            }
            this.progress.setPercentage((int)(per * 100L / length));
        }
    }

    @Override
    public void pumpingStateChange(String id) {
        if (this.progress == null) {
            return;
        }
        Pumping pumping = DownloadManager.instance.queue().getById(id);
        this.progress.setDetail(ResourceUtils.getString(DownloadProgress.class, PUMPING_STATE_CHANGED_KEY, pumping.state().toString().toLowerCase(), pumping.declaredURL()));
    }

    @Override
    public void pumpingAdd(String id) {
    }

    @Override
    public void pumpingDelete(String id) {
    }

    @Override
    public void queueReset() {
    }

    @Override
    public void pumpsInvoke() {
        if (this.progress == null) {
            return;
        }
    }

    @Override
    public void pumpsTerminate() {
        if (this.progress == null) {
            return;
        }
    }
}

