/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListSwiftPasswordsRequest
extends BmcRequest<Void> {
    private String userId;

    public String getUserId() {
        return this.userId;
    }

    public Builder toBuilder() {
        return new Builder().userId(this.userId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",userId=").append(String.valueOf(this.userId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListSwiftPasswordsRequest)) {
            return false;
        }
        ListSwiftPasswordsRequest other = (ListSwiftPasswordsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.userId, other.userId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.userId == null ? 43 : this.userId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListSwiftPasswordsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String userId = null;

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListSwiftPasswordsRequest o) {
            this.userId(o.getUserId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListSwiftPasswordsRequest build() {
            ListSwiftPasswordsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListSwiftPasswordsRequest buildWithoutInvocationCallback() {
            ListSwiftPasswordsRequest request = new ListSwiftPasswordsRequest();
            request.userId = this.userId;
            return request;
        }
    }
}

