/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.netbeans.modules.form.editors2.TableModelEditor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class CustomTableModelEditor
extends JPanel
implements PropertyChangeListener {
    private PropertyEditor editor;
    private boolean isChangingTableModel = false;
    private ChangeListener changeListener = new TabChangeListener();
    private ListSelectionListener selectionListener = new SelectionListener();
    private JTabbedPane tabbedPane;
    private JTable settingsTable;
    private JTable defaultValuesTable;
    private JTextField rowsField;
    private JTextField columnsField;
    private TableModelEditor.NbTableModel model;
    private TableModelEditor.NbTableModel titleModel;
    private int stSelectedRow;
    private int stSelectedColumn;
    private int defSelectedRow;
    private int defSelectedColumn;
    private JButton insertSColBtn;
    private JButton deleteSColBtn;
    private JButton moveSColUpBtn;
    private JButton moveSColDownBtn;
    private JButton insertColBtn;
    private JButton deleteColBtn;
    private JButton moveColLeftBtn;
    private JButton moveColRightBtn;
    private JButton insertRowBtn;
    private JButton deleteRowBtn;
    private JButton moveRowUpBtn;
    private JButton moveRowDownBtn;
    private JButton addRowBtn;
    private JButton removeRowBtn;
    private JButton addColBtn;
    private JButton removeColBtn;
    static final int SETTINGS_TAB = 0;
    static final int DEFAULT_TAB = 1;
    static final long serialVersionUID = 8002510111948803668L;

    public CustomTableModelEditor(PropertyEditor editor, PropertyEnv env) {
        this.editor = editor;
        env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        env.addPropertyChangeListener((PropertyChangeListener)this);
        ResourceBundle bundle = NbBundle.getBundle(CustomTableModelEditor.class);
        this.model = new TableModelEditor.NbTableModel((TableModel)editor.getValue());
        this.setLayout(new BorderLayout(0, 2));
        this.setBorder(new EmptyBorder(6, 6, 6, 6));
        this.tabbedPane = new JTabbedPane();
        JLabel titleLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)titleLabel, (String)bundle.getString("CTL_TableModelTitle"));
        titleLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_TableModelTitle"));
        titleLabel.setLabelFor(this.tabbedPane);
        this.add((Component)titleLabel, "North");
        JPanel tab = new JPanel();
        tab.setLayout(new BorderLayout(6, 6));
        tab.setBorder(new EmptyBorder(6, 2, 0, 2));
        this.settingsTable = new CustomJTable();
        JLabel titleLabel1 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)titleLabel1, (String)bundle.getString("CTL_Title1"));
        titleLabel1.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_Title1"));
        titleLabel1.setLabelFor(this.settingsTable);
        tab.add((Component)titleLabel1, "North");
        this.titleModel = new TableModelEditor.NbTableModel(new String[]{bundle.getString("CTL_Column"), bundle.getString("CTL_Title"), bundle.getString("CTL_Type"), bundle.getString("CTL_Editable")}, new Class[]{String.class, String.class, String.class, Boolean.class}, new boolean[]{false, true, true, true}, this.model.getColumnCount());
        this.settingsTable.setModel(this.titleModel);
        JComboBox<String> comboBox = new JComboBox<String>();
        comboBox.addItem("Object");
        comboBox.addItem("String");
        comboBox.addItem("Boolean");
        comboBox.addItem("Integer");
        comboBox.addItem("Byte");
        comboBox.addItem("Short");
        comboBox.addItem("Long");
        comboBox.addItem("Float");
        comboBox.addItem("Double");
        comboBox.setMaximumRowCount(9);
        comboBox.setSelectedIndex(0);
        TableColumn typeColumn = this.settingsTable.getColumn(bundle.getString("CTL_Type"));
        typeColumn.setCellEditor(new DefaultCellEditor(comboBox));
        JScrollPane jscrollpane = new JScrollPane(this.settingsTable);
        this.settingsTable.setSelectionMode(0);
        this.settingsTable.setCellSelectionEnabled(true);
        this.settingsTable.setRowSelectionAllowed(true);
        this.settingsTable.setColumnSelectionAllowed(true);
        this.settingsTable.setPreferredScrollableViewportSize(new Dimension(450, 200));
        tab.add((Component)jscrollpane, "Center");
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new GridLayout(4, 0, 0, 3));
        this.insertSColBtn = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.insertSColBtn, (String)bundle.getString("CTL_InsertColumn"));
        this.insertSColBtn.setToolTipText(bundle.getString("CTL_HINT_InsertColumn"));
        buttonsPanel.add(this.insertSColBtn);
        this.insertSColBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomTableModelEditor.this.insertColumn();
            }
        });
        this.deleteSColBtn = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.deleteSColBtn, (String)bundle.getString("CTL_DeleteColumn"));
        this.deleteSColBtn.setToolTipText(bundle.getString("CTL_HINT_DeleteColumn"));
        buttonsPanel.add(this.deleteSColBtn);
        this.deleteSColBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomTableModelEditor.this.removeColumn();
            }
        });
        this.moveSColUpBtn = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.moveSColUpBtn, (String)bundle.getString("CTL_MoveRowUp"));
        this.moveSColUpBtn.setToolTipText(bundle.getString("CTL_HINT_MoveColumnUp"));
        buttonsPanel.add(this.moveSColUpBtn);
        this.moveSColUpBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomTableModelEditor.this.moveColumnLeft();
            }
        });
        this.moveSColDownBtn = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.moveSColDownBtn, (String)bundle.getString("CTL_MoveRowDown"));
        this.moveSColDownBtn.setToolTipText(bundle.getString("CTL_HINT_MoveColumnDown"));
        buttonsPanel.add(this.moveSColDownBtn);
        this.moveSColDownBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomTableModelEditor.this.moveColumnRight();
            }
        });
        JPanel padding = new JPanel(new BorderLayout());
        padding.add((Component)buttonsPanel, "North");
        tab.add((Component)padding, "East");
        this.tabbedPane.addTab(bundle.getString("CTL_Title2"), tab);
        tab = new JPanel();
        tab.setLayout(new BorderLayout(6, 6));
        tab.setBorder(new EmptyBorder(6, 2, 0, 2));
        this.defaultValuesTable = new CustomJTable();
        JLabel titleLabel2 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)titleLabel2, (String)bundle.getString("CTL_DefaultTableValues"));
        titleLabel2.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_DefaultTableValues"));
        titleLabel2.setLabelFor(this.defaultValuesTable);
        tab.add((Component)titleLabel2, "North");
        this.defaultValuesTable.setModel(this.model);
        this.model.alwaysEditable = true;
        jscrollpane = new JScrollPane(this.defaultValuesTable);
        this.defaultValuesTable.setSelectionMode(0);
        this.defaultValuesTable.setCellSelectionEnabled(true);
        this.defaultValuesTable.setRowSelectionAllowed(true);
        this.defaultValuesTable.setColumnSelectionAllowed(true);
        this.defaultValuesTable.setPreferredScrollableViewportSize(new Dimension(450, 80));
        this.defaultValuesTable.setAutoResizeMode(0);
        tab.add((Component)jscrollpane, "Center");
        this.tabbedPane.addTab(bundle.getString("CTL_DefaultValues"), tab);
        buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new GridBagLayout());
        JPanel colButtonsPanel = new JPanel(new GridLayout(4, 0, 0, 3));
        JLabel colLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)colLabel, (String)bundle.getString("CTL_ColumnsPanel"));
        colLabel.setLabelFor(colButtonsPanel);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.gridx = 0;
        buttonsPanel.add((Component)colLabel, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.insets = new Insets(0, 12, 5, 0);
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.gridx = 0;
        buttonsPanel.add((Component)colButtonsPanel, gridBagConstraints1);
        this.insertColBtn = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.insertColBtn, (String)bundle.getString("CTL_InsertColumn"));
        this.insertColBtn.setToolTipText(bundle.getString("CTL_HINT_InsertColumn"));
        colButtonsPanel.add(this.insertColBtn);
        this.insertColBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomTableModelEditor.this.insertColumn();
            }
        });
        this.deleteColBtn = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.deleteColBtn, (String)bundle.getString("CTL_DeleteColumn"));
        this.deleteColBtn.setToolTipText(bundle.getString("CTL_HINT_DeleteColumn"));
        colButtonsPanel.add(this.deleteColBtn);
        this.deleteColBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomTableModelEditor.this.removeColumn();
            }
        });
        this.moveColLeftBtn = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.moveColLeftBtn, (String)bundle.getString("CTL_MoveColumnLeft"));
        this.moveColLeftBtn.setToolTipText(bundle.getString("CTL_HINT_MoveColumnLeft"));
        colButtonsPanel.add(this.moveColLeftBtn);
        this.moveColLeftBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomTableModelEditor.this.moveColumnLeft();
            }
        });
        this.moveColRightBtn = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.moveColRightBtn, (String)bundle.getString("CTL_MoveColumnRight"));
        this.moveColRightBtn.setToolTipText(bundle.getString("CTL_HINT_MoveColumnRight"));
        colButtonsPanel.add(this.moveColRightBtn);
        this.moveColRightBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomTableModelEditor.this.moveColumnRight();
            }
        });
        JPanel rowButtonsPanel = new JPanel(new GridLayout(4, 0, 0, 3));
        JLabel rowLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)rowLabel, (String)bundle.getString("CTL_RowsPanel"));
        rowLabel.setLabelFor(rowButtonsPanel);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.gridx = 0;
        buttonsPanel.add((Component)rowLabel, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.insets = new Insets(0, 12, 0, 0);
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.gridx = 0;
        buttonsPanel.add((Component)rowButtonsPanel, gridBagConstraints1);
        this.insertRowBtn = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.insertRowBtn, (String)bundle.getString("CTL_InsertRow"));
        this.insertRowBtn.setToolTipText(bundle.getString("CTL_HINT_InsertRow"));
        rowButtonsPanel.add(this.insertRowBtn);
        this.insertRowBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomTableModelEditor.this.insertRow();
            }
        });
        this.deleteRowBtn = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.deleteRowBtn, (String)bundle.getString("CTL_DeleteRow"));
        this.deleteRowBtn.setToolTipText(bundle.getString("CTL_HINT_DeleteRow"));
        rowButtonsPanel.add(this.deleteRowBtn);
        this.deleteRowBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomTableModelEditor.this.removeRow();
            }
        });
        this.moveRowUpBtn = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.moveRowUpBtn, (String)bundle.getString("CTL_MoveRowUp"));
        this.moveRowUpBtn.setToolTipText(bundle.getString("CTL_HINT_MoveRowUp"));
        rowButtonsPanel.add(this.moveRowUpBtn);
        this.moveRowUpBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomTableModelEditor.this.moveRowUp();
            }
        });
        this.moveRowDownBtn = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.moveRowDownBtn, (String)bundle.getString("CTL_MoveRowDown"));
        this.moveRowDownBtn.setToolTipText(bundle.getString("CTL_HINT_MoveRowDown"));
        rowButtonsPanel.add(this.moveRowDownBtn);
        this.moveRowDownBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomTableModelEditor.this.moveRowDown();
            }
        });
        padding = new JPanel();
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.weighty = 1.0;
        gridBagConstraints1.fill = 3;
        buttonsPanel.add((Component)padding, gridBagConstraints1);
        tab.add((Component)buttonsPanel, "East");
        this.add((Component)this.tabbedPane, "Center");
        JPanel sizePanel = new JPanel();
        sizePanel.setBorder(new EmptyBorder(8, 2, 0, 2));
        sizePanel.setLayout(new GridBagLayout());
        this.rowsField = new JTextField(3);
        JLabel rowsLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)rowsLabel, (String)bundle.getString("CTL_Rows"));
        rowsLabel.setLabelFor(this.rowsField);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.anchor = 17;
        sizePanel.add((Component)rowsLabel, gridBagConstraints1);
        this.rowsField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_Rows"));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.insets = new Insets(0, 4, 0, 0);
        sizePanel.add((Component)this.rowsField, gridBagConstraints1);
        this.addRowBtn = new JButton(" " + bundle.getString("CTL_CountPlus") + " ");
        if (!Utilities.isMac()) {
            this.addRowBtn.setMnemonic(bundle.getString("CTL_CountPlusRow_Mnemonic").charAt(0));
        }
        this.addRowBtn.setToolTipText(bundle.getString("CTL_HINT_AddRow"));
        this.addRowBtn.setMargin(new Insets(-1, 1, -2, 0));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.insets = new Insets(0, 4, 0, 0);
        sizePanel.add((Component)this.addRowBtn, gridBagConstraints1);
        this.addRowBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomTableModelEditor.this.addRow();
            }
        });
        this.removeRowBtn = new JButton(" " + bundle.getString("CTL_CountMinus") + " ");
        if (!Utilities.isMac()) {
            this.removeRowBtn.setMnemonic(bundle.getString("CTL_CountMinusRow_Mnemonic").charAt(0));
        }
        this.removeRowBtn.setToolTipText(bundle.getString("CTL_HINT_RemoveRow"));
        this.removeRowBtn.setMargin(new Insets(-2, 1, -1, 1));
        gridBagConstraints1 = new GridBagConstraints();
        sizePanel.add((Component)this.removeRowBtn, gridBagConstraints1);
        this.removeRowBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomTableModelEditor.this.removeLastRow();
            }
        });
        this.columnsField = new JTextField(3);
        JLabel columnsLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)columnsLabel, (String)bundle.getString("CTL_Columns"));
        columnsLabel.setLabelFor(this.columnsField);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.insets = new Insets(0, 20, 0, 0);
        sizePanel.add((Component)columnsLabel, gridBagConstraints1);
        this.columnsField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_Columns"));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.insets = new Insets(0, 4, 0, 0);
        sizePanel.add((Component)this.columnsField, gridBagConstraints1);
        this.addColBtn = new JButton(" " + bundle.getString("CTL_CountPlus") + " ");
        if (!Utilities.isMac()) {
            this.addColBtn.setMnemonic(bundle.getString("CTL_CountPlusColumn_Mnemonic").charAt(0));
        }
        this.addColBtn.setToolTipText(bundle.getString("CTL_HINT_AddColumn"));
        this.addColBtn.setMargin(new Insets(-1, 1, -2, 0));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.insets = new Insets(0, 4, 0, 0);
        sizePanel.add((Component)this.addColBtn, gridBagConstraints1);
        this.addColBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomTableModelEditor.this.addColumn();
            }
        });
        this.removeColBtn = new JButton(" " + bundle.getString("CTL_CountMinus") + " ");
        if (!Utilities.isMac()) {
            this.removeColBtn.setMnemonic(bundle.getString("CTL_CountMinusColumn_Mnemonic").charAt(0));
        }
        this.removeColBtn.setToolTipText(bundle.getString("CTL_HINT_RemoveColumn"));
        this.removeColBtn.setMargin(new Insets(-2, 1, -1, 1));
        gridBagConstraints1 = new GridBagConstraints();
        sizePanel.add((Component)this.removeColBtn, gridBagConstraints1);
        this.removeColBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomTableModelEditor.this.removeLastColumn();
            }
        });
        padding = new JPanel();
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        sizePanel.add((Component)padding, gridBagConstraints1);
        this.add((Component)sizePanel, "South");
        this.rowsField.setText(String.valueOf(this.model.getRowCount()));
        this.columnsField.setText(String.valueOf(this.model.getColumnCount()));
        this.rowsField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                CustomTableModelEditor.this.updateRows(CustomTableModelEditor.this.rowsField.getText());
            }
        });
        this.rowsField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomTableModelEditor.this.updateRows(CustomTableModelEditor.this.rowsField.getText());
            }
        });
        this.columnsField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                CustomTableModelEditor.this.updateColumns(CustomTableModelEditor.this.columnsField.getText());
            }
        });
        this.columnsField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomTableModelEditor.this.updateColumns(CustomTableModelEditor.this.columnsField.getText());
            }
        });
        this.updateSettingsTable();
        this.enableButtons();
        this.titleModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent evt) {
                if (evt.getType() == 0) {
                    int selRow = CustomTableModelEditor.this.defaultValuesTable.getSelectedRow();
                    int selCol = CustomTableModelEditor.this.defaultValuesTable.getSelectedColumn();
                    CustomTableModelEditor.this.updateDefaultTable();
                    CustomTableModelEditor.refreshSelection(CustomTableModelEditor.this.defaultValuesTable, selRow, selCol);
                } else {
                    CustomTableModelEditor.this.enableButtons();
                }
            }
        });
        this.model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent evt) {
                if (evt.getType() != 0) {
                    CustomTableModelEditor.this.enableButtons();
                }
            }
        });
        this.defaultValuesTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
                int toI;
                int fromI = e.getFromIndex();
                if (fromI != (toI = e.getToIndex())) {
                    CustomTableModelEditor.this.moveColumn(fromI, toI);
                } else {
                    CustomTableModelEditor.this.defSelectedRow = CustomTableModelEditor.this.defaultValuesTable.getSelectedRow();
                    CustomTableModelEditor.this.defSelectedColumn = CustomTableModelEditor.this.defaultValuesTable.getSelectedColumn();
                }
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
        this.tabbedPane.addChangeListener(this.changeListener);
        this.settingsTable.getSelectionModel().addListSelectionListener(this.selectionListener);
        this.settingsTable.getColumnModel().getSelectionModel().addListSelectionListener(this.selectionListener);
        this.defaultValuesTable.getSelectionModel().addListSelectionListener(this.selectionListener);
        this.defaultValuesTable.getColumnModel().getSelectionModel().addListSelectionListener(this.selectionListener);
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_TableCustomEditor"));
    }

    private void enableButtons() {
        int rowCount = this.model.getRowCount();
        boolean anyRow = rowCount > 0;
        int columnCount = this.model.getColumnCount();
        boolean anyColumn = columnCount > 0;
        int selectedColumn = -1;
        if (anyColumn) {
            if (this.tabbedPane.getSelectedIndex() == 1) {
                selectedColumn = this.defaultValuesTable.getSelectedColumn();
            } else if (this.tabbedPane.getSelectedIndex() == 0) {
                selectedColumn = this.settingsTable.getSelectedRow();
            }
        }
        boolean columnSelected = selectedColumn >= 0 && selectedColumn < columnCount;
        int selectedRow = -1;
        if (anyRow && this.tabbedPane.getSelectedIndex() == 1) {
            selectedRow = this.defaultValuesTable.getSelectedRow();
            columnSelected &= selectedRow >= 0 && selectedRow < rowCount;
        }
        boolean rowSelected = selectedRow >= 0 && selectedRow < rowCount;
        rowSelected &= columnSelected;
        this.insertSColBtn.setEnabled(columnSelected);
        this.deleteSColBtn.setEnabled(columnSelected);
        this.moveSColUpBtn.setEnabled(selectedColumn > 0 && selectedColumn < columnCount);
        this.moveSColDownBtn.setEnabled(columnSelected && selectedColumn < columnCount - 1);
        this.insertColBtn.setEnabled(columnSelected);
        this.deleteColBtn.setEnabled(columnSelected);
        this.moveColLeftBtn.setEnabled(selectedColumn > 0 && selectedColumn < columnCount && rowSelected);
        this.moveColRightBtn.setEnabled(columnSelected && selectedColumn < columnCount - 1);
        this.insertRowBtn.setEnabled(rowSelected);
        this.deleteRowBtn.setEnabled(rowSelected);
        this.moveRowUpBtn.setEnabled(selectedRow > 0 && selectedRow < rowCount && columnSelected);
        this.moveRowDownBtn.setEnabled(rowSelected && selectedRow < rowCount - 1);
        this.addRowBtn.setEnabled(true);
        this.removeRowBtn.setEnabled(anyRow);
        this.addColBtn.setEnabled(true);
        this.removeColBtn.setEnabled(anyColumn);
    }

    private void addRow() {
        this.model.setRowCount(this.model.getRowCount() + 1);
        this.rowsField.setText(Integer.toString(this.model.getRowCount()));
        this.defaultValuesTable.clearSelection();
    }

    private void removeLastRow() {
        int n = this.model.getRowCount();
        if (n > 0) {
            this.model.setRowCount(n - 1);
            this.rowsField.setText(Integer.toString(this.model.getRowCount()));
            this.defaultValuesTable.clearSelection();
        }
    }

    private void insertRow() {
        if (this.tabbedPane.getSelectedIndex() == 1) {
            this.examineSelections();
            if (this.defSelectedRow >= 0) {
                this.model.addRow(this.defSelectedRow);
                this.rowsField.setText(Integer.toString(this.model.getRowCount()));
                this.updateSelections(true);
            } else if (this.model.getRowCount() == 0) {
                this.addRow();
            }
        }
    }

    private void removeRow() {
        if (this.tabbedPane.getSelectedIndex() == 1 && this.model.getRowCount() > 0) {
            this.examineSelections();
            if (this.defSelectedRow >= 0) {
                this.model.removeRow(this.defSelectedRow);
                this.rowsField.setText(Integer.toString(this.model.getRowCount()));
                if (this.defSelectedRow == this.model.getRowCount() && this.defSelectedRow > 0) {
                    --this.defSelectedRow;
                }
                this.updateSelections(true);
            }
        }
    }

    private void updateRows(String text) {
        int n = 0;
        try {
            n = Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            return;
        }
        if (n >= 0) {
            this.model.setRowCount(n);
        }
    }

    private void moveRowUp() {
        if (this.tabbedPane.getSelectedIndex() == 1 && this.model.getRowCount() > 0) {
            this.examineSelections();
            if (this.defSelectedRow > 0) {
                this.model.moveRow(this.defSelectedRow, this.defSelectedRow - 1);
                --this.defSelectedRow;
                this.updateSelections(true);
            }
        }
    }

    private void moveRowDown() {
        if (this.tabbedPane.getSelectedIndex() == 1 && this.model.getRowCount() > 0) {
            this.examineSelections();
            if (this.defSelectedRow >= 0 && this.defSelectedRow < this.model.getRowCount() - 1) {
                this.model.moveRow(this.defSelectedRow, this.defSelectedRow + 1);
                ++this.defSelectedRow;
                this.updateSelections(true);
            }
        }
    }

    private void addColumn() {
        int n = this.model.getColumnCount();
        this.model.setColumnCount(n + 1);
        this.defaultValuesTable.clearSelection();
        this.updateSettingsTable();
        this.settingsTable.clearSelection();
        this.columnsField.setText(Integer.toString(this.model.getColumnCount()));
    }

    private void removeLastColumn() {
        int n = this.model.getColumnCount();
        if (n > 0) {
            this.model.setColumnCount(n - 1);
            this.defaultValuesTable.clearSelection();
            this.updateSettingsTable();
            this.settingsTable.clearSelection();
            this.columnsField.setText(Integer.toString(this.model.getColumnCount()));
        }
    }

    private void insertColumn() {
        this.examineSelections();
        int ci = this.tabbedPane.getSelectedIndex() == 1 ? this.defSelectedColumn : (this.tabbedPane.getSelectedIndex() == 0 ? this.stSelectedRow : -1);
        if (ci >= 0) {
            this.model.addColumn(ci);
            this.updateSettingsTable();
            this.columnsField.setText(Integer.toString(this.model.getColumnCount()));
            this.updateSelections(true);
        } else if (this.model.getColumnCount() == 0) {
            this.addColumn();
        }
    }

    private void removeColumn() {
        if (this.model.getColumnCount() > 0) {
            this.examineSelections();
            int ci = this.tabbedPane.getSelectedIndex() == 1 ? this.defSelectedColumn : (this.tabbedPane.getSelectedIndex() == 0 ? this.stSelectedRow : -1);
            if (ci >= 0) {
                this.model.removeColumn(ci);
                this.updateSettingsTable();
                this.columnsField.setText(Integer.toString(this.model.getColumnCount()));
                if (ci == this.model.getColumnCount() && ci > 0) {
                    --ci;
                }
                if (this.tabbedPane.getSelectedIndex() == 1) {
                    this.defSelectedColumn = ci;
                } else {
                    this.stSelectedRow = ci;
                }
                this.updateSelections(true);
            }
        }
    }

    private void updateColumns(String text) {
        int n = 0;
        try {
            n = Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            return;
        }
        if (n >= 0) {
            this.model.setColumnCount(n);
            this.updateSettingsTable();
        }
    }

    private void moveColumnLeft() {
        this.examineSelections();
        int ci = this.tabbedPane.getSelectedIndex() == 1 ? this.defSelectedColumn : (this.tabbedPane.getSelectedIndex() == 0 ? this.stSelectedRow : -1);
        if (ci > 0) {
            this.model.moveColumn(ci, ci - 1);
            this.updateSettingsTable();
            if (this.tabbedPane.getSelectedIndex() == 1) {
                this.defSelectedColumn = ci - 1;
            } else {
                this.stSelectedRow = ci - 1;
            }
            this.updateSelections(true);
        }
    }

    private void moveColumnRight() {
        this.examineSelections();
        int ci = this.tabbedPane.getSelectedIndex() == 1 ? this.defSelectedColumn : (this.tabbedPane.getSelectedIndex() == 0 ? this.stSelectedRow : -1);
        if (ci >= 0 && ci < this.model.getColumnCount() - 1) {
            this.model.moveColumn(ci, ci + 1);
            this.updateSettingsTable();
            if (this.tabbedPane.getSelectedIndex() == 1) {
                this.defSelectedColumn = ci + 1;
            } else {
                this.stSelectedRow = ci + 1;
            }
            this.updateSelections(true);
        }
    }

    private void moveColumn(int fromIndex, int toIndex) {
        this.model.moveColumn(fromIndex, toIndex);
        this.updateSettingsTable();
        int selCol = this.defSelectedRow >= 0 ? (this.defSelectedColumn == fromIndex ? toIndex : (this.defSelectedColumn == toIndex ? fromIndex : this.defSelectedColumn)) : -1;
        if (selCol >= 0) {
            this.defaultValuesTable.setRowSelectionInterval(this.defSelectedRow, this.defSelectedRow);
            this.defaultValuesTable.setColumnSelectionInterval(selCol, selCol);
        } else {
            this.defaultValuesTable.clearSelection();
            this.defaultValuesTable.getParent().requestFocus();
        }
        if (this.defaultValuesTable.getTableHeader().getDraggedColumn() != null) {
            this.defaultValuesTable.getTableHeader().setDraggedColumn(this.defaultValuesTable.getColumnModel().getColumn(toIndex));
        }
    }

    private void examineSelections() {
        if (this.settingsTable.isEditing()) {
            this.settingsTable.removeEditor();
        }
        if (this.defaultValuesTable.isEditing()) {
            this.defaultValuesTable.removeEditor();
        }
        this.stSelectedRow = this.settingsTable.getSelectedRow();
        this.stSelectedColumn = this.settingsTable.getSelectedColumn();
        this.defSelectedRow = this.defaultValuesTable.getSelectedRow();
        this.defSelectedColumn = this.defaultValuesTable.getSelectedColumn();
    }

    private void updateSelections(boolean focusTable) {
        if (this.tabbedPane.getSelectedIndex() == 1) {
            CustomTableModelEditor.refreshSelection(this.settingsTable, this.defSelectedColumn, this.stSelectedColumn);
            if (focusTable && CustomTableModelEditor.refreshSelection(this.defaultValuesTable, this.defSelectedRow, this.defSelectedColumn)) {
                this.defaultValuesTable.requestFocus();
                this.defaultValuesTable.scrollRectToVisible(this.defaultValuesTable.getCellRect(this.defSelectedRow, this.defSelectedColumn, false));
            }
        } else if (this.tabbedPane.getSelectedIndex() == 0) {
            CustomTableModelEditor.refreshSelection(this.defaultValuesTable, this.defSelectedRow, this.stSelectedRow);
            if (focusTable && CustomTableModelEditor.refreshSelection(this.settingsTable, this.stSelectedRow, this.stSelectedColumn)) {
                this.settingsTable.requestFocus();
                this.settingsTable.scrollRectToVisible(this.settingsTable.getCellRect(this.stSelectedRow, this.stSelectedColumn, false));
            }
        }
    }

    private static boolean refreshSelection(JTable table, int row, int column) {
        table.clearSelection();
        if (row >= 0 && row < table.getRowCount() && column >= 0 && column < table.getColumnCount()) {
            table.setRowSelectionInterval(row, row);
            table.setColumnSelectionInterval(column, column);
            return true;
        }
        return false;
    }

    void updateDefaultTable() {
        if (this.model == null || this.isChangingTableModel) {
            return;
        }
        int cols = this.model.getColumnCount();
        int rows = this.model.getRowCount();
        boolean typeChanged = false;
        for (int i = 0; i < cols; ++i) {
            Class type;
            this.model.setColumnName(i, (String)this.titleModel.getValueAt(i, 1));
            try {
                type = Class.forName("java.lang." + (String)this.titleModel.getValueAt(i, 2));
            }
            catch (Exception e) {
                type = Object.class;
            }
            if (!type.equals(this.model.getColumnClass(i))) {
                typeChanged = true;
                this.model.setColumnClass(i, type);
                for (int j = 0; j < rows; ++j) {
                    this.model.setValueAt(null, j, i);
                }
            }
            this.model.setColumnEditable(i, (Boolean)this.titleModel.getValueAt(i, 3));
        }
        if (typeChanged) {
            this.defaultValuesTable.createDefaultColumnsFromModel();
        }
        this.model.fireTableStructureChanged();
    }

    void updateSettingsTable() {
        this.isChangingTableModel = true;
        int cols = this.model.getColumnCount();
        if (cols != this.titleModel.getRowCount()) {
            this.titleModel.setRowCount(cols);
        }
        for (int i = 0; i < cols; ++i) {
            this.titleModel.setValueAt(Integer.toString(i + 1), i, 0);
            this.titleModel.setValueAt(this.model.getColumnName(i), i, 1);
            String type = this.model.getColumnClass(i).getName();
            int lastDot = type.lastIndexOf(46);
            if (lastDot >= 0) {
                type = type.substring(lastDot + 1);
            }
            this.titleModel.setValueAt(type, i, 2);
            this.titleModel.setValueAt(this.model.isColumnEditable(i) ? Boolean.TRUE : Boolean.FALSE, i, 3);
        }
        this.isChangingTableModel = false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("state".equals(evt.getPropertyName()) && evt.getNewValue() == PropertyEnv.STATE_VALID) {
            this.updateDefaultTable();
            this.editor.setValue(new TableModelEditor.NbTableModel(this.model));
        }
    }

    private static class CustomJTable
    extends JTable {
        Component edComp;

        public CustomJTable() {
            this.initEditors();
        }

        @Override
        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            if (e != null && e.getID() == 401 && (e.getModifiers() & 0xA) != 0) {
                return false;
            }
            return super.processKeyBinding(ks, e, condition, pressed);
        }

        @Override
        protected void processKeyEvent(KeyEvent e) {
            if (e.getID() == 401) {
                if (e.getKeyCode() == 27) {
                    if (!this.isEditing()) {
                        return;
                    }
                } else if (e.getKeyCode() == 32) {
                    int anchorRow = this.getSelectionModel().getAnchorSelectionIndex();
                    int anchorColumn = this.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
                    if (anchorRow != -1 && anchorColumn != -1 && !this.isEditing()) {
                        super.processKeyEvent(e);
                        e.consume();
                        if (this.edComp != null) {
                            this.edComp.requestFocus();
                        }
                        return;
                    }
                }
            }
            super.processKeyEvent(e);
        }

        @Override
        public Component prepareEditor(TableCellEditor editor, int row, int column) {
            this.edComp = super.prepareEditor(editor, row, column);
            return this.edComp;
        }

        private void initEditors() {
            this.initEditor(Object.class);
            this.initEditor(Number.class);
        }

        private void initEditor(Class type) {
            DefaultCellEditor defaultEditor;
            Component editorComponent;
            TableCellEditor cellEditor = this.getDefaultEditor(type);
            if (cellEditor instanceof DefaultCellEditor && (editorComponent = (defaultEditor = (DefaultCellEditor)cellEditor).getComponent()) instanceof JTextField) {
                editorComponent.addFocusListener(new FocusListener(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        defaultEditor.stopCellEditing();
                    }

                    @Override
                    public void focusGained(FocusEvent e) {
                    }
                });
            }
        }
    }

    private class TabChangeListener
    implements ChangeListener {
        private TabChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            CustomTableModelEditor.this.enableButtons();
        }
    }

    private class SelectionListener
    implements ListSelectionListener {
        private SelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            CustomTableModelEditor.this.enableButtons();
        }
    }
}

