/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support.hostinfo.impl;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.netbeans.modules.nativeexecution.support.Logger;

public final class HostInfoFactory {
    private static final String UNKNOWN = "UNKNOWN";

    private HostInfoFactory() {
    }

    static HostInfo newHostInfo(ExecutionEnvironment execEnv, Properties initData, Map<String, String> environment) {
        HostInfoImpl info = new HostInfoImpl();
        OSImpl _os = new OSImpl();
        _os.setBitness(HostInfoFactory.getInt(initData, "BITNESS", 32));
        _os.setFamily(initData.getProperty("OSFAMILY", UNKNOWN));
        _os.setName(initData.getProperty("OSNAME", UNKNOWN));
        _os.setVersion(initData.getProperty("OSBUILD", UNKNOWN));
        info.os = _os;
        info.hostname = initData.getProperty("HOSTNAME", UNKNOWN);
        info.cpuFamily = HostInfoFactory.toCpuFamily(initData.getProperty("CPUFAMILY", UNKNOWN));
        info.loginShell = initData.getProperty("SH", UNKNOWN);
        info.tempDir = initData.getProperty("TMPDIRBASE", UNKNOWN);
        info.userDir = initData.getProperty("USERDIRBASE", UNKNOWN);
        info.cpuNum = HostInfoFactory.getInt(initData, "CPUNUM", 1);
        if (environment == null) {
            info.environment = Collections.unmodifiableMap(Collections.emptyMap());
        } else {
            info.environment = Collections.unmodifiableMap(environment);
        }
        if (initData.containsKey("LOCALTIME")) {
            long localTime = (Long)initData.get("LOCALTIME");
            long remoteTime = HostInfoFactory.getTime(initData, "DATETIME", localTime);
            info.clockSkew = remoteTime - localTime;
        }
        String id = initData.getProperty("ID");
        HostInfoFactory.parseId(info, id);
        info.envfile = execEnv.isLocal() ? null : info.tempDir + "/env";
        return info;
    }

    private static HostInfo.CpuFamily toCpuFamily(String cpuFamilyStr) {
        try {
            return HostInfo.CpuFamily.valueOf(cpuFamilyStr.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            if (cpuFamilyStr.startsWith("arm")) {
                return HostInfo.CpuFamily.ARM;
            }
            return HostInfo.CpuFamily.UNKNOWN;
        }
    }

    private static void parseId(HostInfoImpl info, String id) {
        StringBuilder sb;
        if (id == null) {
            return;
        }
        String[] parts = id.split(" +");
        boolean error = false;
        if (parts.length > 0 && parts[0].startsWith("uid=")) {
            sb = new StringBuilder();
            info.uid = HostInfoFactory.parseIdAndName(parts[0].substring(4), sb);
            error |= info.uid < 0;
        } else {
            error = true;
        }
        if (parts.length > 1 && parts[1].startsWith("gid=")) {
            sb = new StringBuilder();
            info.gid = HostInfoFactory.parseIdAndName(parts[1].substring(4), sb);
            error |= info.uid < 0;
            info.group = sb.toString();
        } else {
            error = true;
        }
        if (parts.length > 2) {
            if (parts[2].startsWith("groups=")) {
                String[] groupPairs = parts[2].substring(7).split(", *");
                if (groupPairs.length > 0) {
                    ArrayList<Integer> gids = new ArrayList<Integer>(groupPairs.length);
                    ArrayList<String> groups = new ArrayList<String>(groupPairs.length);
                    for (String pair : groupPairs) {
                        sb = new StringBuilder();
                        int gid = HostInfoFactory.parseIdAndName(pair, sb);
                        error |= info.uid < 0;
                        if (gid >= 0) {
                            gids.add(gid);
                        }
                        if (sb.length() <= 0) continue;
                        groups.add(sb.toString());
                    }
                    HostInfoImpl.access$1802(info, new int[gids.size()]);
                    for (int i = 0; i < gids.size(); ++i) {
                        ((HostInfoImpl)info).gids[i] = (Integer)gids.get(i);
                    }
                    HostInfoImpl.access$1902(info, groups.toArray(new String[groups.size()]));
                }
            } else {
                error = true;
            }
        }
        if (error) {
            Logger.getInstance().log(Level.INFO, "Wrong `id` format: {0}", id);
        }
    }

    private static int parseIdAndName(String text, StringBuilder sb) {
        int id;
        if (text == null || text.length() == 0) {
            return -1;
        }
        int bracketPos = text.indexOf(40);
        String idText = bracketPos >= 0 ? text.substring(0, bracketPos) : text;
        String nameText = bracketPos >= 0 && text.endsWith(")") ? text.substring(bracketPos + 1, text.length() - 1) : null;
        try {
            id = Integer.parseInt(idText);
        }
        catch (NumberFormatException e) {
            return -1;
        }
        if (nameText != null) {
            sb.append(nameText);
        }
        return id;
    }

    private static int getInt(Properties props, String key, int defaultValue) {
        int result = defaultValue;
        String value = props.getProperty(key, null);
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    private static long getTime(Properties props, String key, long defaultValue) {
        long result = defaultValue;
        String value = props.getProperty(key, null);
        if (value != null) {
            try {
                SimpleDateFormat df = new SimpleDateFormat("y-M-d H:m:s");
                df.setTimeZone(TimeZone.getTimeZone("GMT"));
                Date date = df.parse(value);
                result = date.getTime();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return result;
    }

    static String getNBKey() {
        int hashCode = System.getProperty("netbeans.user", "").hashCode();
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            hashCode = 3 * hashCode + 5 * localhost.getHostName().hashCode();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return Integer.toHexString(hashCode);
    }

    static final class OSImpl
    implements HostInfo.OS {
        private HostInfo.OSFamily family = HostInfo.OSFamily.UNKNOWN;
        private String name = "UNKNOWN";
        private String version = "UNKNOWN";
        private HostInfo.Bitness bitness = HostInfo.Bitness._32;

        OSImpl() {
        }

        @Override
        public HostInfo.Bitness getBitness() {
            return this.bitness;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public HostInfo.OSFamily getFamily() {
            return this.family;
        }

        @Override
        public String getName() {
            return this.name;
        }

        private void setVersion(String version) {
            this.version = version;
        }

        private void setBitness(int bitness) {
            this.bitness = bitness == 64 ? HostInfo.Bitness._64 : HostInfo.Bitness._32;
        }

        private void setFamily(String family) {
            try {
                this.family = HostInfo.OSFamily.valueOf(family.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        private void setName(String name) {
            this.name = name;
        }
    }

    private static class HostInfoImpl
    implements HostInfo {
        private HostInfo.OS os;
        private HostInfo.CpuFamily cpuFamily;
        private String hostname;
        private String loginShell;
        private String tempDir;
        private String userDir;
        private int cpuNum;
        private long clockSkew;
        private Map<String, String> environment;
        private int uid = -1;
        private int gid = -1;
        private int[] gids = new int[0];
        private String group = "";
        private String[] groups = new String[0];
        private String envfile;

        private HostInfoImpl() {
        }

        @Override
        public HostInfo.OS getOS() {
            return this.os;
        }

        @Override
        public HostInfo.CpuFamily getCpuFamily() {
            return this.cpuFamily;
        }

        @Override
        public int getCpuNum() {
            return this.cpuNum;
        }

        @Override
        public HostInfo.OSFamily getOSFamily() {
            return this.os.getFamily();
        }

        @Override
        public String getHostname() {
            return this.hostname;
        }

        @Override
        public String getLoginShell() {
            return this.loginShell;
        }

        @Override
        public String getShell() {
            return "/bin/sh";
        }

        @Override
        public String getTempDir() {
            return this.tempDir;
        }

        @Override
        public String getUserDir() {
            return this.userDir;
        }

        @Override
        public int getUserId() {
            return this.uid;
        }

        @Override
        public int getGroupId() {
            return this.gid;
        }

        @Override
        public int[] getAllGroupIDs() {
            for (int i = 0; i < this.gids.length; ++i) {
                if (this.gids[i] != this.gid) continue;
                int[] copy = new int[this.gids.length];
                System.arraycopy(this.gids, 0, copy, 0, this.gids.length);
                return copy;
            }
            int[] copy = new int[this.gids.length + 1];
            copy[0] = this.gid;
            System.arraycopy(this.gids, 0, copy, 1, this.gids.length);
            return copy;
        }

        @Override
        public String getGroup() {
            return this.group;
        }

        @Override
        public String[] getAllGroups() {
            String[] copy = new String[this.groups.length + 1];
            copy[0] = this.group;
            System.arraycopy(this.groups, 0, copy, 1, this.groups.length);
            return copy;
        }

        @Override
        public File getUserDirFile() {
            if (this.getOSFamily() == HostInfo.OSFamily.WINDOWS) {
                return new File(WindowsSupport.getInstance().convertToWindowsPath(this.userDir));
            }
            return new File(this.userDir);
        }

        @Override
        public File getTempDirFile() {
            if (this.getOSFamily() == HostInfo.OSFamily.WINDOWS) {
                return new File(WindowsSupport.getInstance().convertToWindowsPath(this.tempDir));
            }
            return new File(this.tempDir);
        }

        @Override
        public long getClockSkew() {
            return this.clockSkew;
        }

        @Override
        public Map<String, String> getEnvironment() {
            return this.environment;
        }

        @Override
        public String getEnvironmentFile() {
            return this.envfile;
        }

        static /* synthetic */ int[] access$1802(HostInfoImpl x0, int[] x1) {
            x0.gids = x1;
            return x1;
        }

        static /* synthetic */ String[] access$1902(HostInfoImpl x0, String[] x1) {
            x0.groups = x1;
            return x1;
        }
    }
}

