/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.devops.model.RepositoryBranch;
import com.oracle.bmc.devops.model.RepositoryTag;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="refType", defaultImpl=RepositoryRef.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=RepositoryBranch.class, name="BRANCH"), @JsonSubTypes.Type(value=RepositoryTag.class, name="TAG")})
@JsonFilter(value="explicitlySetFilter")
public class RepositoryRef
extends ExplicitlySetBmcModel {
    @JsonProperty(value="refName")
    private final String refName;
    @JsonProperty(value="fullRefName")
    private final String fullRefName;
    @JsonProperty(value="repositoryId")
    private final String repositoryId;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"refName", "fullRefName", "repositoryId", "freeformTags", "definedTags"})
    protected RepositoryRef(String refName, String fullRefName, String repositoryId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.refName = refName;
        this.fullRefName = fullRefName;
        this.repositoryId = repositoryId;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public String getRefName() {
        return this.refName;
    }

    public String getFullRefName() {
        return this.fullRefName;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RepositoryRef(");
        sb.append("super=").append(super.toString());
        sb.append("refName=").append(String.valueOf(this.refName));
        sb.append(", fullRefName=").append(String.valueOf(this.fullRefName));
        sb.append(", repositoryId=").append(String.valueOf(this.repositoryId));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RepositoryRef)) {
            return false;
        }
        RepositoryRef other = (RepositoryRef)((Object)o);
        return Objects.equals(this.refName, other.refName) && Objects.equals(this.fullRefName, other.fullRefName) && Objects.equals(this.repositoryId, other.repositoryId) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.refName == null ? 43 : this.refName.hashCode());
        result = result * 59 + (this.fullRefName == null ? 43 : this.fullRefName.hashCode());
        result = result * 59 + (this.repositoryId == null ? 43 : this.repositoryId.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum RefType implements BmcEnum
    {
        Branch("BRANCH"),
        Tag("TAG"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, RefType> map;

        private RefType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RefType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'RefType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(RefType.class);
            map = new HashMap<String, RefType>();
            for (RefType v : RefType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

