/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ModuleTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.ClientCodeWrapper;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.ClassFinder;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.util.Name;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.support.ErrorAwareTreeScanner;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaSourceUtilImpl;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.classpath.AptSourcePath;
import org.netbeans.modules.java.source.classpath.CacheClassPath;
import org.netbeans.modules.java.source.indexing.APTUtils;
import org.netbeans.modules.java.source.indexing.TransactionContext;
import org.netbeans.modules.java.source.parsing.CachingArchiveProvider;
import org.netbeans.modules.java.source.parsing.CachingFileManager;
import org.netbeans.modules.java.source.parsing.FileManagerTransaction;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.InferableJavaFileObject;
import org.netbeans.modules.java.source.parsing.JavacParser;
import org.netbeans.modules.java.source.parsing.PrefetchableJavaFileObject;
import org.netbeans.modules.java.source.parsing.ProcessorGenerated;
import org.netbeans.modules.java.source.usages.ClasspathInfoAccessor;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

public final class JavaSourceUtilImpl
extends org.netbeans.modules.java.preprocessorbridge.spi.JavaSourceUtilImpl {
    private static final Logger LOGGER = Logger.getLogger(JavaSourceUtilImpl.class.getName());

    protected long createTaggedCompilationController(org.openide.filesystems.FileObject file, int position, long currenTag, Object[] out) throws IOException {
        assert (file != null);
        JavaSource js = JavaSource.forFileObject(file);
        if (js != null) {
            return JavaSourceAccessor.getINSTANCE().createTaggedCompilationController(js, currenTag, out);
        }
        long l = JavaSourceAccessor.getINSTANCE().createTaggedCompilationController(file, position, currenTag, out);
        if (out[0] == null || l == -1L) {
            throw new FileNotFoundException(String.format("No java source for %s, exists: %b, file: %b", FileUtil.getFileDisplayName((org.openide.filesystems.FileObject)file), file.isValid(), file.isData()));
        }
        return l;
    }

    protected long createTaggedCompilationController(org.openide.filesystems.FileObject file, long currenTag, Object[] out) throws IOException {
        return this.createTaggedCompilationController(file, -1, currenTag, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    protected Map<String, byte[]> generate(@NonNull org.openide.filesystems.FileObject srcRoot, @NonNull org.openide.filesystems.FileObject file, @NullAllowed CharSequence content, @NullAllowed DiagnosticListener<? super JavaFileObject> diagnostics) throws IOException {
        Parameters.notNull((CharSequence)"srcRoot", (Object)srcRoot);
        Parameters.notNull((CharSequence)"file", (Object)file);
        String path = FileUtil.getRelativePath((org.openide.filesystems.FileObject)srcRoot, (org.openide.filesystems.FileObject)file);
        if (path == null) {
            throw new IllegalArgumentException(String.format("File: %s not in root: %s", file, srcRoot));
        }
        String[] ncs = FileObjects.getPackageAndName(FileObjects.convertFolder2Package(FileObjects.stripExtension(path)));
        PrefetchableJavaFileObject toCompile = FileObjects.memoryFileObject(ncs[0], ncs[1] + '.' + file.getExt(), file.toURI(), System.currentTimeMillis(), content);
        boolean success = false;
        TransactionContext ctx = TransactionContext.beginTrans().register(FileManagerTransaction.class, FileManagerTransaction.writeThrough()).register(ProcessorGenerated.class, ProcessorGenerated.create(srcRoot.toURL()));
        try {
            ClassPath moduleClass;
            ClassPath moduleCompile;
            ClassPath compile;
            ClassPath moduleBoot;
            ClassPath boot;
            ClassPath moduleSrc;
            ClassPath src = ClassPath.getClassPath((org.openide.filesystems.FileObject)srcRoot, (String)"classpath/source");
            if (src == null) {
                src = ClassPathSupport.createClassPath((org.openide.filesystems.FileObject[])new org.openide.filesystems.FileObject[]{srcRoot});
            }
            if ((moduleSrc = ClassPath.getClassPath((org.openide.filesystems.FileObject)srcRoot, (String)"modules/source")) == null) {
                moduleSrc = ClassPath.EMPTY;
            }
            if ((boot = ClassPath.getClassPath((org.openide.filesystems.FileObject)srcRoot, (String)"classpath/boot")) == null) {
                boot = JavaPlatform.getDefault().getBootstrapLibraries();
            }
            if ((moduleBoot = ClassPath.getClassPath((org.openide.filesystems.FileObject)srcRoot, (String)"modules/boot")) == null) {
                moduleBoot = ClassPath.EMPTY;
            }
            if ((compile = ClassPath.getClassPath((org.openide.filesystems.FileObject)srcRoot, (String)"classpath/compile")) == null) {
                compile = ClassPath.EMPTY;
            }
            if ((moduleCompile = ClassPath.getClassPath((org.openide.filesystems.FileObject)srcRoot, (String)"modules/compile")) == null) {
                moduleCompile = ClassPath.EMPTY;
            }
            if ((moduleClass = ClassPath.getClassPath((org.openide.filesystems.FileObject)srcRoot, (String)"modules/classpath")) == null) {
                moduleClass = ClassPath.EMPTY;
            }
            ClassPath srcFin = src;
            SourceLevelQuery.Result r = SourceLevelQuery.getSourceLevel2((org.openide.filesystems.FileObject)file);
            Source sourceLevel = JavacParser.validateSourceLevel(r.getSourceLevel(), boot, compile, src, moduleBoot, moduleCompile, moduleClass, "module-info".equals(file.getName()));
            Function<JavaFileManager.Location, JavaFileManager> jfmProvider = loc -> loc == StandardLocation.CLASS_OUTPUT ? new OutputFileManager(CachingArchiveProvider.getDefault(), srcFin, sourceLevel) : null;
            ClasspathInfo cpInfo = ClasspathInfoAccessor.getINSTANCE().create(boot, moduleBoot, compile, moduleCompile, moduleClass, src, moduleSrc, null, true, true, false, false, false, jfmProvider);
            APTUtils aptUtils = APTUtils.get(srcRoot);
            boolean[] hasErrors = new boolean[1];
            Diags diagnosticsDelegate = diagnostics != null ? diagnostics : new Diags();
            DiagnosticListener errors = d -> {
                if (d.getKind() == Diagnostic.Kind.ERROR) {
                    hasErrors[0] = true;
                }
                diagnosticsDelegate.report(d);
            };
            JavacTaskImpl jt = JavacParser.createJavacTask(cpInfo, errors, r.getSourceLevel(), r.getProfile(), null, null, aptUtils, null, Arrays.asList(toCompile));
            Iterable<? extends Element> attributed = jt.analyze(jt.enter(jt.parse()));
            if (hasErrors[0]) {
                Map<String, byte[]> map = Collections.emptyMap();
                return map;
            }
            Iterable<? extends JavaFileObject> generated = jt.generate(StreamSupport.stream(attributed.spliterator(), false).filter(e -> e.getKind().isClass() || e.getKind().isInterface()).map(e -> (TypeElement)e).collect(Collectors.toList()));
            HashMap<String, byte[]> result = new HashMap<String, byte[]>();
            for (JavaFileObject javaFileObject : generated) {
                if (javaFileObject instanceof OutputFileManager.MemOutFileObject) {
                    OutputFileManager.MemOutFileObject mout = (OutputFileManager.MemOutFileObject)javaFileObject;
                    result.put(mout.inferBinaryName(), mout.toByteArray());
                    continue;
                }
                throw new IOException(String.format("Unexpected JavaFileObject: %s", javaFileObject));
            }
            success = true;
            Map map = Collections.unmodifiableMap(result);
            return map;
        }
        finally {
            if (success) {
                ctx.commit();
            } else {
                ctx.rollBack();
            }
        }
    }

    @CheckForNull
    protected JavaSourceUtilImpl.ModuleInfoHandle getModuleInfoHandle(@NonNull Object javaSource) throws IOException {
        if (!(javaSource instanceof JavaSource)) {
            throw new IllegalArgumentException("The javaSource parameter must be an instance of JavaSource");
        }
        Collection<org.openide.filesystems.FileObject> fileObjects = ((JavaSource)javaSource).getFileObjects();
        int size = fileObjects.size();
        if (size > 1) {
            throw new IllegalArgumentException("The javaSource parameter cannot represent multiple FileObjects");
        }
        org.netbeans.modules.parsing.api.Source s = size > 0 ? org.netbeans.modules.parsing.api.Source.create((org.openide.filesystems.FileObject)fileObjects.iterator().next()) : null;
        try {
            final CompilationController cc = JavaSourceAccessor.getINSTANCE().createCompilationController(s, ((JavaSource)javaSource).getClasspathInfo());
            if (cc != null) {
                return new JavaSourceUtilImpl.ModuleInfoHandle(){

                    @CheckForNull
                    public String parseModuleName() throws IOException {
                        cc.toPhase(JavaSource.Phase.PARSED);
                        CompilationUnitTree cu = cc.getCompilationUnit();
                        for (Tree tree : cu.getTypeDecls()) {
                            if (tree.getKind() != Tree.Kind.MODULE) continue;
                            return ((ModuleTree)tree).getName().toString();
                        }
                        return null;
                    }

                    @CheckForNull
                    public ModuleTree parseModule() throws IOException {
                        cc.toPhase(JavaSource.Phase.PARSED);
                        ErrorAwareTreeScanner<ModuleTree, Void> scanner = new ErrorAwareTreeScanner<ModuleTree, Void>(){

                            @Override
                            public ModuleTree visitModule(ModuleTree node, Void p) {
                                return node;
                            }
                        };
                        return (ModuleTree)scanner.scan(cc.getCompilationUnit(), null);
                    }

                    @CheckForNull
                    public ModuleElement resolveModule(@NonNull ModuleTree moduleTree) throws IOException {
                        cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        Trees trees = cc.getTrees();
                        return (ModuleElement)trees.getElement(TreePath.getPath(cc.getCompilationUnit(), (Tree)moduleTree));
                    }

                    @CheckForNull
                    public ModuleElement resolveModule(String moduleName) throws IOException {
                        cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        ModuleElement mod = cc.getElements().getModuleElement(moduleName);
                        return mod == null || cc.getElementUtilities().isErroneous(mod) ? null : mod;
                    }

                    public TypeElement readClassFile() throws IOException {
                        Symbol.ClassSymbol sym;
                        cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        JavacTaskImpl jt = JavaSourceAccessor.getINSTANCE().getCompilationInfoImpl(cc).getJavacTask();
                        ClassFinder finder = ClassFinder.instance(jt.getContext());
                        Symtab syms = Symtab.instance(jt.getContext());
                        if ("module-info".equals(cc.getFileObject().getName())) {
                            String moduleName = SourceUtils.getModuleName(cc.getFileObject().getParent().toURL());
                            if (moduleName != null) {
                                Symbol.ModuleSymbol msym = syms.enterModule((Name)cc.getElements().getName(moduleName));
                                sym = msym.module_info;
                                if (sym.classfile == null) {
                                    sym.classfile = FileObjects.fileObjectFileObject(cc.getFileObject(), cc.getFileObject().getParent(), null, null);
                                    sym.owner = msym;
                                    msym.owner = syms.noSymbol;
                                    sym.completer = finder.getCompleter();
                                    msym.classLocation = StandardLocation.CLASS_PATH;
                                }
                                msym.complete();
                            } else {
                                sym = null;
                            }
                        } else {
                            throw new UnsupportedOperationException("Not supported yet.");
                        }
                        return sym;
                    }
                };
            }
            return null;
        }
        catch (ParseException pe) {
            throw new IOException(pe);
        }
    }

    private static final class OutputFileManager
    implements JavaFileManager {
        private final JavaFileManager readDelegate;

        OutputFileManager(@NonNull CachingArchiveProvider cap, @NonNull ClassPath srcPath, @NullAllowed Source sourceLevel) {
            ClassPathImplementation srcNoApt = AptSourcePath.sources(srcPath);
            ClassPath out = CacheClassPath.forSourcePath(ClassPathFactory.createClassPath((ClassPathImplementation)srcNoApt), true);
            this.readDelegate = new CachingFileManager(cap, out, sourceLevel, false, true);
        }

        @Override
        public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
            OutputFileManager.assertLocation(location, false);
            return this.readDelegate.list(location, packageName, kinds, recurse);
        }

        @Override
        public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
            OutputFileManager.assertLocation(location, false);
            return this.readDelegate.getJavaFileForInput(location, className, kind);
        }

        @Override
        public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
            OutputFileManager.assertLocation(location, false);
            return this.readDelegate.getFileForInput(location, packageName, relativeName);
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            OutputFileManager.assertLocation(location, true);
            String[] ncs = FileObjects.getPackageAndName(className);
            return new MemOutFileObject(ncs[0], String.format("%s%s", ncs[1], kind.extension));
        }

        @Override
        public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
            OutputFileManager.assertLocation(location, true);
            String resourceName = FileObjects.resolveRelativePath(packageName, relativeName);
            String[] ncs = FileObjects.getFolderAndBaseName(resourceName, '/');
            return new MemOutFileObject(FileObjects.convertFolder2Package(ncs[0]), ncs[1]);
        }

        @Override
        public boolean isSameFile(FileObject a, FileObject b) {
            if (a == b) {
                return true;
            }
            return a.toUri().equals(b.toUri());
        }

        @Override
        public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
            if (this.hasLocation(location)) {
                return ((InferableJavaFileObject)file).inferBinaryName();
            }
            return null;
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public boolean hasLocation(JavaFileManager.Location location) {
            return location == StandardLocation.CLASS_OUTPUT;
        }

        @Override
        public int isSupportedOption(String string) {
            return -1;
        }

        @Override
        public boolean handleOption(String head, Iterator<String> tail) {
            return false;
        }

        @Override
        public ClassLoader getClassLoader(JavaFileManager.Location location) {
            OutputFileManager.assertLocation(location, false);
            return null;
        }

        private static void assertLocation(JavaFileManager.Location l, boolean write) {
            if (l instanceof StandardLocation) {
                switch ((StandardLocation)l) {
                    case CLASS_OUTPUT: {
                        return;
                    }
                    case CLASS_PATH: {
                        if (write) break;
                        return;
                    }
                }
            }
            throw new IllegalStateException(String.valueOf(l));
        }

        @ClientCodeWrapper.Trusted
        private static final class MemOutFileObject
        extends FileObjects.Base {
            private final ByteArrayOutputStream out = new ByteArrayOutputStream();
            private long modified = -1L;

            MemOutFileObject(@NonNull String pkg, @NonNull String name) {
                super(pkg, name, null, true);
            }

            @Override
            public URI toUri() {
                return URI.create(String.format("%s/%s", FileObjects.convertPackage2Folder(this.getPackage()), this.getName()));
            }

            @Override
            public InputStream openInputStream() throws IOException {
                return new ByteArrayInputStream(this.out.toByteArray());
            }

            @Override
            public OutputStream openOutputStream() throws IOException {
                this.modified = System.currentTimeMillis();
                this.out.reset();
                return this.out;
            }

            @Override
            public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
                return this.encoding == null ? new String(this.out.toByteArray()) : new String(this.out.toByteArray(), this.encoding);
            }

            @Override
            public long getLastModified() {
                return this.modified;
            }

            @Override
            public boolean delete() {
                this.out.reset();
                return true;
            }

            byte[] toByteArray() {
                return this.out.toByteArray();
            }
        }
    }

    private static final class Diags
    implements DiagnosticListener<JavaFileObject> {
        private Diags() {
        }

        @Override
        public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
            LOGGER.log(Level.FINE, "{0}", diagnostic);
        }
    }
}

