/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.composer.options;

import java.util.List;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.composer.commands.Composer;
import org.openide.util.NbPreferences;

public final class ComposerOptions {
    public static final String COMPOSER_PATH = "composer.path";
    public static final String VENDOR = "vendor";
    public static final String AUTHOR_NAME = "author.name";
    public static final String AUTHOR_EMAIL = "author.email";
    public static final String IGNORE_VENDOR = "ignore.vendor";
    private static final String PREFERENCES_PATH = "composer";
    private static final ComposerOptions INSTANCE = new ComposerOptions();
    private final Preferences preferences = NbPreferences.forModule(ComposerOptions.class).node("composer");
    private volatile boolean composerSearched = false;

    private ComposerOptions() {
    }

    public static ComposerOptions getInstance() {
        return INSTANCE;
    }

    public void addPreferenceChangeListener(PreferenceChangeListener listener) {
        this.preferences.addPreferenceChangeListener(listener);
    }

    public void removePreferenceChangeListener(PreferenceChangeListener listener) {
        this.preferences.removePreferenceChangeListener(listener);
    }

    public String getComposerPath() {
        String composerPath = this.preferences.get(COMPOSER_PATH, null);
        if (composerPath == null && !this.composerSearched) {
            this.composerSearched = true;
            List paths = FileUtils.findFileOnUsersPath((String[])Composer.COMPOSER_FILENAMES.toArray(new String[0]));
            if (!paths.isEmpty()) {
                composerPath = (String)paths.get(0);
                this.setComposerPath(composerPath);
            }
        }
        return composerPath;
    }

    public void setComposerPath(String composerPath) {
        this.preferences.put(COMPOSER_PATH, composerPath);
    }

    public String getVendor() {
        return this.preferences.get(VENDOR, VENDOR);
    }

    public void setVendor(String vendor) {
        this.preferences.put(VENDOR, vendor);
    }

    public String getAuthorName() {
        return this.preferences.get(AUTHOR_NAME, System.getProperty("user.name"));
    }

    public void setAuthorName(String authorName) {
        this.preferences.put(AUTHOR_NAME, authorName);
    }

    public String getAuthorEmail() {
        return this.preferences.get(AUTHOR_EMAIL, "your@email.here");
    }

    public void setAuthorEmail(String authorEmail) {
        this.preferences.put(AUTHOR_EMAIL, authorEmail);
    }

    public boolean isIgnoreVendor() {
        return this.preferences.getBoolean(IGNORE_VENDOR, true);
    }

    public void setIgnoreVendor(boolean ignoreVendor) {
        this.preferences.putBoolean(IGNORE_VENDOR, ignoreVendor);
    }
}

