/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jakarta.web.beans.analysis.analyzer;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.ModelAnalyzer;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.annotation.InterceptorBindingAnalyzer;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.annotation.StereotypeAnalyzer;
import org.netbeans.modules.jakarta.web.beans.api.model.WebBeansModel;

public class AnnotationModelAnalyzer
implements ModelAnalyzer {
    private static final List<AnnotationAnalyzer> ANALYZERS = new LinkedList<AnnotationAnalyzer>();

    @Override
    public void analyze(Element element, TypeElement parent, WebBeansModel model, AtomicBoolean cancel, ModelAnalyzer.Result result) {
        TypeElement subject = (TypeElement)element;
        for (AnnotationAnalyzer analyzer : ANALYZERS) {
            if (cancel.get()) {
                return;
            }
            analyzer.analyze(subject, model, cancel, result);
        }
    }

    static {
        ANALYZERS.add(new StereotypeAnalyzer());
        ANALYZERS.add(new InterceptorBindingAnalyzer());
    }

    public static interface AnnotationAnalyzer {
        public static final String INCORRECT_RUNTIME = "ERR_IncorrectRuntimeRetention";

        public void analyze(TypeElement var1, WebBeansModel var2, AtomicBoolean var3, ModelAnalyzer.Result var4);
    }
}

