/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.grammar;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Segment;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.openide.util.Exceptions;

class AntHighlightsContainer
extends AbstractHighlightsContainer {
    private static final Pattern EXPR = Pattern.compile("(?<![$])[$@][{][^{}]+[}]");
    private final AbstractDocument doc;
    private final AttributeSet attrs;

    public AntHighlightsContainer(AbstractDocument doc, AttributeSet attrs) {
        this.doc = doc;
        this.attrs = attrs;
    }

    public HighlightsSequence getHighlights(final int startOffset, final int endOffset) {
        return new HighlightsSequence(){
            int start;
            int end;
            final Matcher m;
            final int scanStart;
            final int _endOffset;
            {
                int scanEnd;
                this.scanStart = AntHighlightsContainer.this.doc.getParagraphElement(startOffset).getStartOffset();
                if (endOffset == Integer.MAX_VALUE) {
                    scanEnd = this._endOffset = AntHighlightsContainer.this.doc.getLength();
                } else {
                    this._endOffset = endOffset;
                    scanEnd = AntHighlightsContainer.this.doc.getParagraphElement(endOffset).getEndOffset();
                }
                Segment text = new Segment();
                try {
                    AntHighlightsContainer.this.doc.getText(this.scanStart, scanEnd - this.scanStart, text);
                }
                catch (BadLocationException x) {
                    Exceptions.printStackTrace((Throwable)x);
                }
                this.m = EXPR.matcher(text);
            }

            public boolean moveNext() {
                if (!this.m.find()) {
                    return false;
                }
                this.start = this.scanStart + this.m.start();
                this.end = this.scanStart + this.m.end();
                if (this.end < startOffset) {
                    return this.moveNext();
                }
                if (this.end == startOffset) {
                    ++this.end;
                    return this.moveNext();
                }
                if (this.start < startOffset) {
                    this.start = startOffset;
                } else {
                    if (this.start >= this._endOffset) {
                        return false;
                    }
                    if (this.end > this._endOffset) {
                        this.end = this._endOffset;
                    }
                }
                assert (this.start >= startOffset);
                if (this.end > endOffset) {
                    return false;
                }
                assert (this.end > this.start);
                return true;
            }

            public int getStartOffset() {
                return this.start;
            }

            public int getEndOffset() {
                return this.end;
            }

            public AttributeSet getAttributes() {
                return AntHighlightsContainer.this.attrs;
            }
        };
    }
}

