/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common.wizards;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.payara.common.wizards.AddServerLocationPanel;
import org.netbeans.modules.payara.common.wizards.Retriever;
import org.netbeans.modules.payara.common.wizards.ServerWizardIterator;
import org.netbeans.modules.payara.spi.Utils;
import org.netbeans.modules.payara.tooling.data.PayaraPlatformVersionAPI;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class AddServerLocationVisualPanel
extends JPanel
implements Retriever.Updater {
    public static final String DOWNLOAD_PREFIX = "https://www.payara.fish/";
    private final List<ChangeListener> listeners = new CopyOnWriteArrayList<ChangeListener>();
    private Retriever retriever;
    private volatile DownloadState downloadState;
    private volatile String statusText;
    private final ServerWizardIterator wizardIterator;
    private JCheckBox agreeCheckBox;
    private JButton browseButton;
    private JComboBox<PayaraPlatformVersionAPI> chooseServerComboBox;
    private JLabel chooseServerLabel;
    private ButtonGroup domainType;
    private JButton downloadButton;
    private JLabel downloadStatusLabel;
    private JLabel hk2HomeLabel;
    private JTextField hk2HomeTextField;
    private JRadioButton localDomainRadioButton;
    private JButton readlicenseButton;
    private JRadioButton remoteDomainRadioButton;

    public AddServerLocationVisualPanel(ServerWizardIterator swi) {
        this.wizardIterator = swi;
        this.initComponents();
        this.initUserComponents();
    }

    private void initUserComponents() {
        this.downloadButton.setEnabled(false);
        if (this.wizardIterator.downloadableValues.isEmpty()) {
            this.agreeCheckBox.setEnabled(false);
        } else {
            this.agreeCheckBox.setEnabled(true);
        }
        this.setName(NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"TITLE_ServerLocation"));
        this.hk2HomeTextField.setText(this.getPreviousValue());
        this.hk2HomeTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                AddServerLocationVisualPanel.this.homeFolderChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddServerLocationVisualPanel.this.homeFolderChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddServerLocationVisualPanel.this.homeFolderChanged();
            }
        });
        this.chooseServerComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AddServerLocationVisualPanel.this.serverVersionChanged();
                }
            }
        });
        this.setDownloadState(DownloadState.AVAILABLE);
        this.updateMessageText("");
        this.localDomainRadioButton.setSelected(true);
        this.remoteDomainRadioButton.setSelected(false);
        this.wizardIterator.setLocal(true);
    }

    private String getPreviousValue() {
        Preferences prefs = NbPreferences.forModule(this.wizardIterator.getClass());
        String prevValue = null;
        if (null != prefs) {
            prevValue = prefs.get("INSTALL_ROOT_KEY", null);
        }
        if (null == prevValue) {
            String installDir = System.getProperty("INSTALL_ROOT_PROPERTY");
            if (null != installDir && installDir.trim().length() != 0) {
                return installDir;
            }
            return System.getProperty("user.home") + File.separatorChar + "Payara_Server";
        }
        return prevValue;
    }

    public DownloadState getDownloadState() {
        return this.downloadState;
    }

    public String getHk2HomeLocation() {
        return this.hk2HomeTextField.getText();
    }

    public String getStatusText() {
        return this.statusText;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public boolean isLocal() {
        return this.localDomainRadioButton.isSelected();
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireChangeEvent() {
        ChangeEvent ev = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(ev);
        }
    }

    private String browseHomeLocation() {
        String hk2Location = null;
        JFileChooser chooser = this.getJFileChooser();
        int returnValue = chooser.showDialog(this, NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_ChooseButton"));
        if (returnValue == 0) {
            hk2Location = chooser.getSelectedFile().getAbsolutePath();
        }
        return hk2Location;
    }

    private JFileChooser getJFileChooser() {
        JFileChooser chooser = new JFileChooser();
        String t = NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_ChooserName");
        chooser.setDialogTitle(t);
        chooser.setDialogType(2);
        chooser.setFileSelectionMode(1);
        chooser.setApproveButtonMnemonic("Choose_Button_Mnemonic".charAt(0));
        chooser.setMultiSelectionEnabled(false);
        chooser.addChoosableFileFilter(new DirFilter());
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setApproveButtonToolTipText(t);
        chooser.getAccessibleContext().setAccessibleName(t);
        chooser.getAccessibleContext().setAccessibleDescription(t);
        File currentLocation = new File(this.hk2HomeTextField.getText());
        File currentLocationParent = currentLocation.getParentFile();
        if (currentLocationParent != null && currentLocationParent.exists()) {
            chooser.setCurrentDirectory(currentLocationParent);
        }
        if (currentLocation.exists() && currentLocation.isDirectory()) {
            chooser.setSelectedFile(currentLocation);
        }
        return chooser;
    }

    @Override
    public void removeNotify() {
        if (this.retriever != null) {
            this.retriever.stopRetrieval();
        }
        super.removeNotify();
    }

    @Override
    public void updateMessageText(final String msg) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                if (msg.trim().startsWith("<html>")) {
                    AddServerLocationVisualPanel.this.downloadStatusLabel.setText(msg);
                } else {
                    AddServerLocationVisualPanel.this.downloadStatusLabel.setText("<html>" + msg + "</html>");
                }
                AddServerLocationVisualPanel.this.fireChangeEvent();
            }
        });
    }

    @Override
    public void updateStatusText(String status) {
        this.statusText = status;
        this.fireChangeEvent();
    }

    @Override
    public void clearCancelState() {
        this.setDownloadState(this.retriever.getDownloadState() == 3 ? DownloadState.COMPLETED : DownloadState.AVAILABLE);
        this.retriever = null;
    }

    private void updateButton() {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                boolean writableLoc;
                DownloadState state = AddServerLocationVisualPanel.this.downloadState;
                boolean licenseAccepted = AddServerLocationVisualPanel.this.agreeCheckBox.isSelected();
                File val = new File(AddServerLocationVisualPanel.this.hk2HomeTextField.getText().trim());
                boolean bl = writableLoc = AddServerLocationPanel.canCreate(val) || Utils.canWrite(val);
                String buttonTextKey = state == DownloadState.DOWNLOADING ? "LBL_CancelDownload" : (state == DownloadState.COMPLETED ? "LBL_DownloadComplete" : "LBL_DownloadNow");
                String buttonText = NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)buttonTextKey);
                AddServerLocationVisualPanel.this.downloadButton.setText(buttonText);
                AddServerLocationVisualPanel.this.downloadButton.setEnabled(state != DownloadState.COMPLETED && licenseAccepted && writableLoc);
            }
        });
    }

    private synchronized void setDownloadState(DownloadState state) {
        this.downloadState = state;
        this.updateButton();
    }

    private void homeFolderChanged() {
        this.updateMessageText("");
        if (this.downloadState == DownloadState.COMPLETED) {
            this.setDownloadState(DownloadState.AVAILABLE);
        } else {
            this.updateButton();
        }
    }

    private void serverVersionChanged() {
        this.agreeCheckBox.setSelected(false);
        this.agreeCheckBoxActionPerformed(null);
    }

    private void initComponents() {
        this.domainType = new ButtonGroup();
        this.hk2HomeLabel = new JLabel();
        this.hk2HomeTextField = new JTextField();
        this.browseButton = new JButton();
        this.downloadButton = new JButton();
        this.agreeCheckBox = new JCheckBox();
        this.readlicenseButton = new JButton();
        this.downloadStatusLabel = new JLabel();
        this.localDomainRadioButton = new JRadioButton();
        this.remoteDomainRadioButton = new JRadioButton();
        this.chooseServerLabel = new JLabel();
        this.chooseServerComboBox = new JComboBox<PayaraPlatformVersionAPI>(this.wizardIterator.downloadableValues.toArray(new PayaraPlatformVersionAPI[0]));
        this.hk2HomeLabel.setLabelFor(this.hk2HomeTextField);
        Mnemonics.setLocalizedText((JLabel)this.hk2HomeLabel, (String)NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_InstallLocation"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_BrowseButton"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddServerLocationVisualPanel.this.browseButtonActionPerformed(evt);
            }
        });
        this.downloadButton.setText("[download/cancel]");
        this.downloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddServerLocationVisualPanel.this.downloadButtonActionPerformed(evt);
            }
        });
        this.agreeCheckBox.setMargin(new Insets(4, 0, 4, 4));
        this.agreeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddServerLocationVisualPanel.this.agreeCheckBoxActionPerformed(evt);
            }
        });
        this.readlicenseButton.setText(NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_ReadLicenseText"));
        this.readlicenseButton.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.readlicenseButton.setBorderPainted(false);
        this.readlicenseButton.setContentAreaFilled(false);
        this.readlicenseButton.setHorizontalAlignment(10);
        this.readlicenseButton.setVerticalAlignment(1);
        this.readlicenseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddServerLocationVisualPanel.this.readlicenseButtonActionPerformed(evt);
            }
        });
        this.downloadStatusLabel.setText("[download status]");
        this.downloadStatusLabel.setVerticalAlignment(1);
        this.downloadStatusLabel.setHorizontalTextPosition(10);
        this.domainType.add(this.localDomainRadioButton);
        this.localDomainRadioButton.setText(NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"AddServerLocationVisualPanel.localDomainRadioButton"));
        this.localDomainRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddServerLocationVisualPanel.this.localDomainRadioButtonActionPerformed(evt);
            }
        });
        this.domainType.add(this.remoteDomainRadioButton);
        this.remoteDomainRadioButton.setText(NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"AddServerLocationVisualPanel.remoteDomainRadioButton"));
        this.remoteDomainRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddServerLocationVisualPanel.this.remoteDomainRadioButtonActionPerformed(evt);
            }
        });
        this.chooseServerLabel.setLabelFor(this.hk2HomeTextField);
        Mnemonics.setLocalizedText((JLabel)this.chooseServerLabel, (String)NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_ChooseOne"));
        if (!this.wizardIterator.downloadableValues.isEmpty()) {
            this.chooseServerComboBox.setSelectedItem(this.wizardIterator.downloadableValues.get(0));
        } else {
            this.updateMessageText(NbBundle.getMessage(AddServerLocationPanel.class, (String)"LBL_UnableToConnectPayaraMavenRepo"));
        }
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.downloadStatusLabel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.localDomainRadioButton, -2, 121, -2).addGap(17, 17, 17).addComponent(this.remoteDomainRadioButton, -2, 253, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.hk2HomeTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton)).addGroup(layout.createSequentialGroup().addComponent(this.downloadButton).addGap(18, 18, 18).addComponent(this.agreeCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.readlicenseButton, -2, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.hk2HomeLabel).addComponent(this.chooseServerComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.chooseServerLabel, -1, 180, Short.MAX_VALUE)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.hk2HomeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.hk2HomeTextField, -2, -1, -2).addComponent(this.browseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.localDomainRadioButton).addComponent(this.remoteDomainRadioButton)).addGap(10, 10, 10).addComponent(this.chooseServerLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chooseServerComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.agreeCheckBox).addComponent(this.downloadButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 9, Short.MAX_VALUE).addComponent(this.downloadStatusLabel)).addGroup(layout.createSequentialGroup().addComponent(this.readlicenseButton).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        this.hk2HomeTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"AddServerLocationVisualPanel.hk2HomeTextField.AccessibleContext.accessibleDescription"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"AddServerLocationVisualPanel.browseButton.AccessibleContext.accessibleDescription"));
        this.agreeCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"AddServerLocationVisualPanel.agreeCheckBox.AccessibleContext.accessibleDescription"));
        this.readlicenseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"AddServerLocationVisualPanel.readlicenseButton.AccessibleContext.accessibleDescription"));
    }

    private void readlicenseButtonActionPerformed(ActionEvent evt) {
        try {
            PayaraPlatformVersionAPI chosenServerVersion = (PayaraPlatformVersionAPI)this.chooseServerComboBox.getSelectedItem();
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL(chosenServerVersion.getLicenseUrl()));
        }
        catch (Exception ex) {
            Logger.getLogger("payara").log(Level.INFO, ex.getLocalizedMessage(), ex);
        }
    }

    private void downloadButtonActionPerformed(ActionEvent evt) {
        if (this.retriever == null) {
            PayaraPlatformVersionAPI selectedValue = null;
            if (!this.wizardIterator.downloadableValues.isEmpty()) {
                selectedValue = this.wizardIterator.downloadableValues.get(0);
            }
            if (this.wizardIterator.downloadableValues.size() > 1) {
                selectedValue = (PayaraPlatformVersionAPI)this.chooseServerComboBox.getSelectedItem();
            }
            if (null != selectedValue) {
                this.updateStatusText("");
                this.retriever = new Retriever(new File(this.hk2HomeTextField.getText()), selectedValue.getIndirectUrl(), DOWNLOAD_PREFIX, selectedValue.getDirectUrl(), this, "payara");
                new Thread(this.retriever).start();
                this.setDownloadState(DownloadState.DOWNLOADING);
            }
        } else {
            this.retriever.stopRetrieval();
            this.setDownloadState(DownloadState.AVAILABLE);
        }
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        String newLoc = this.browseHomeLocation();
        if (newLoc != null && newLoc.length() > 0) {
            this.hk2HomeTextField.setText(newLoc);
        }
    }

    private void agreeCheckBoxActionPerformed(ActionEvent evt) {
        DownloadState state = this.downloadState;
        if (state == DownloadState.COMPLETED) {
            this.setDownloadState(DownloadState.AVAILABLE);
        } else {
            File val = new File(this.hk2HomeTextField.getText().trim());
            boolean writableLoc = AddServerLocationPanel.canCreate(val) || Utils.canWrite(val);
            this.downloadButton.setEnabled(this.agreeCheckBox.isSelected() && writableLoc);
        }
    }

    private void remoteDomainRadioButtonActionPerformed(ActionEvent evt) {
        this.wizardIterator.setLocal(!this.remoteDomainRadioButton.isSelected());
    }

    private void localDomainRadioButtonActionPerformed(ActionEvent evt) {
        this.wizardIterator.setLocal(this.localDomainRadioButton.isSelected());
    }

    private static class DirFilter
    extends FileFilter {
        DirFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.exists() && f.canRead() && f.isDirectory();
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(AddServerLocationVisualPanel.class, (String)"LBL_DirType");
        }
    }

    public static enum DownloadState {
        AVAILABLE,
        DOWNLOADING,
        COMPLETED;

    }
}

