/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.queries.api;

import java.net.URL;
import java.util.Collection;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.java.source.queries.APIAccessor;
import org.netbeans.modules.java.source.queries.SPIAccessor;
import org.netbeans.modules.java.source.queries.api.Function;
import org.netbeans.modules.java.source.queries.api.QueryException;
import org.netbeans.modules.java.source.queries.spi.ModelOperations;
import org.netbeans.modules.java.source.queries.spi.QueriesController;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public class Queries {
    static final QueriesController ctl;
    private final URL forURL;
    ModelOperations impl;

    Queries(@NonNull URL forURL) {
        assert (forURL != null);
        this.forURL = forURL;
    }

    @NonNull
    public final URL getURL() {
        return this.forURL;
    }

    @NonNull
    public final Collection<? extends String> getTopLevelClasses() throws QueryException {
        return this.impl.getTopLevelClasses();
    }

    @CheckForNull
    public final String getClassBinaryName(@NonNull String cls) throws QueryException {
        Parameters.notNull((CharSequence)"cls", (Object)cls);
        return this.impl.getClassBinaryName(cls);
    }

    @CheckForNull
    public final String getSuperClass(@NonNull String cls) throws QueryException {
        Parameters.notNull((CharSequence)"cls", (Object)cls);
        return this.impl.getSuperClass(cls);
    }

    @NonNull
    public final Collection<? extends String> getInterfaces(@NonNull String cls) throws QueryException {
        Parameters.notNull((CharSequence)"cls", (Object)cls);
        return this.impl.getInterfaces(cls);
    }

    @NonNull
    public final Collection<? extends String> getMethodNames(@NonNull String cls, boolean useRawTypes, @NullAllowed String returnType, @NullAllowed String[] parameterTypes) throws QueryException {
        Parameters.notNull((CharSequence)"cls", (Object)cls);
        return this.impl.getMethodNames(cls, useRawTypes, returnType, parameterTypes);
    }

    @NonNull
    public final Collection<? extends String> getFieldNames(@NonNull String cls, boolean useRawTypes, @NullAllowed String type) throws QueryException {
        Parameters.notNull((CharSequence)"cls", (Object)cls);
        return this.impl.getFieldNames(cls, useRawTypes, type);
    }

    @CheckForNull
    public final int[] getMethodSpan(@NonNull String cls, @NonNull String methodName, boolean useRawTypes, @NonNull String returnType, String ... parameterTypes) throws QueryException {
        Parameters.notNull((CharSequence)"cls", (Object)cls);
        Parameters.notNull((CharSequence)"methodName", (Object)methodName);
        Parameters.notNull((CharSequence)"returnType", (Object)returnType);
        Parameters.notNull((CharSequence)"parameterTypes", (Object)parameterTypes);
        return this.impl.getMethodSpan(cls, methodName, useRawTypes, returnType, parameterTypes);
    }

    @CheckForNull
    public static <T> T query(@NonNull URL forURL, @NonNull Function<Queries, T> queryFnc) throws QueryException {
        Parameters.notNull((CharSequence)"forURL", (Object)forURL);
        Parameters.notNull((CharSequence)"queryFnc", queryFnc);
        if (ctl == null) {
            throw new IllegalStateException("No QueriesController found in the Lookup");
        }
        Queries q = new Queries(forURL);
        QueriesController.Context<T> ctx = SPIAccessor.getInstance().createContext(queryFnc, q);
        return ctl.runQuery(ctx);
    }

    private void attach(@NonNull ModelOperations impl) {
        assert (impl != null);
        this.impl = impl;
    }

    private void detach() {
        this.impl = null;
    }

    static {
        APIAccessor.setInstance(new Accessor());
        ctl = (QueriesController)Lookup.getDefault().lookup(QueriesController.class);
    }

    private static class Accessor
    extends APIAccessor {
        private Accessor() {
        }

        @Override
        public void attach(Queries q, ModelOperations ops) {
            q.attach(ops);
        }

        @Override
        public void detach(Queries q) {
            q.detach();
        }
    }
}

