/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.tooling.utils;

import java.util.Iterator;
import java.util.TreeMap;
import org.netbeans.modules.glassfish.tooling.utils.LinkedList;

public class StringPrefixTree<Type> {
    private Node root = new Node();
    private int size = 0;
    private boolean caseSensitive;

    public StringPrefixTree(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    private void finishExistingStringWithValue(Node node, Type value) {
        ++this.size;
        node.setFinal();
        node.setValue(value);
    }

    private void removeValuefromString(Node node) {
        --this.size;
        node.setInner();
        node.setValue(null);
    }

    private void finishNewStringWithValue(Node node, char c, Type value) {
        ++this.size;
        node.add(c, new Node(value));
    }

    public void clear() {
        StackItem item;
        Node oldRoot = this.root;
        this.root = new Node();
        this.size = 0;
        LinkedList<StackItem> stack = new LinkedList<StackItem>();
        stack.addFirst(new StackItem(oldRoot));
        while ((item = (StackItem)stack.getLast()) != null) {
            if (item.child.hasNext()) {
                stack.addLast(new StackItem(item.child.next()));
                continue;
            }
            item.node.destroy();
            stack.removeLast();
        }
    }

    public boolean add(String str, Type value) {
        boolean result;
        Node next;
        char c;
        int strLen = str != null ? str.length() : 0;
        int lastIndex = strLen > 0 ? strLen - 1 : 0;
        Node act = this.root;
        for (int i = 0; i < lastIndex; ++i) {
            c = str.charAt(i);
            next = act.get(c);
            if (next == null) {
                Node node = act;
                act = new Node();
                node.add(c, act);
                continue;
            }
            act = next;
        }
        if (strLen == 0 && !this.root.isFinal()) {
            result = true;
            this.finishExistingStringWithValue(this.root, value);
        } else {
            c = str.charAt(lastIndex);
            next = act.get(c);
            if (next == null) {
                result = true;
                this.finishNewStringWithValue(act, c, value);
            } else {
                result = !next.isFinal();
                if (result) {
                    this.finishExistingStringWithValue(next, value);
                }
            }
        }
        return result;
    }

    public Type remove(String str) {
        int pos;
        Type result = null;
        int strLen = str != null ? str.length() : 0;
        Node act = this.root;
        Object last = null;
        LinkedList<Node> stack = new LinkedList<Node>();
        for (pos = 0; pos <= strLen && act != null; ++pos) {
            if (pos < strLen) {
                stack.addLast(act);
                act = act.get(str.charAt(pos));
            }
            if (pos != strLen || !act.isFinal()) continue;
            result = act.getValue();
            this.removeValuefromString(act);
        }
        if (result != null) {
            pos = str.length();
            while (--pos >= 0 && !act.isFinal() && act.size() == 0) {
                Node del = act;
                act = (Node)stack.removeLast();
                Node removed = act.remove(str.charAt(pos));
                if (removed == del) {
                    del.destroy();
                    continue;
                }
                throw new VerifyError("Removed transition does not point to removed state.");
            }
        }
        stack.clear();
        return result;
    }

    public Type match(CharSequence str) {
        return this.match(str, 0);
    }

    public Type match(CharSequence str, int offset) {
        int strLen = str != null ? str.length() : 0;
        Type value = null;
        Node act = this.root;
        for (int pos = offset; pos <= strLen && act != null; ++pos) {
            if (pos == strLen && act.isFinal()) {
                value = act.getValue();
            }
            if (pos >= strLen) continue;
            act = act.get(str.charAt(pos));
        }
        return value;
    }

    public Type matchCyclicBuffer(char[] buff, int len, int beg) {
        int pos = beg;
        int count = 0;
        Type value = null;
        Node act = this.root;
        while (count <= len && act != null) {
            if (act.isFinal()) {
                value = act.getValue();
            }
            if (count < len) {
                act = act.get(buff[pos]);
            }
            pos = (beg + ++count) % buff.length;
        }
        return value;
    }

    public Type prefixMatch(CharSequence str) {
        return this.prefixMatch(str, 0);
    }

    public Type prefixMatch(CharSequence str, int offset) {
        int strLen = str != null ? str.length() : 0;
        Type value = null;
        Node act = this.root;
        for (int pos = offset; pos <= strLen && act != null; ++pos) {
            if (act.isFinal()) {
                value = act.getValue();
            }
            if (pos >= strLen) continue;
            act = act.get(str.charAt(pos));
        }
        return value;
    }

    public int size() {
        return this.size;
    }

    private class StackItem {
        Node node;
        Iterator<Node> child;

        StackItem(Node node) {
            this.node = node;
            this.child = node.next.values().iterator();
        }
    }

    private class Node {
        private boolean finalState;
        private Type value;
        private TreeMap<Character, Node> next;

        Character toCharacter(char c) {
            return Character.valueOf(StringPrefixTree.this.caseSensitive ? c : Character.toUpperCase(c));
        }

        Node() {
            this.finalState = false;
            this.next = new TreeMap();
        }

        Node(Type value) {
            this.finalState = true;
            this.next = new TreeMap();
            this.value = value;
        }

        void setFinal() {
            this.finalState = true;
        }

        void setInner() {
            this.finalState = false;
        }

        void setValue(Type value) {
            this.value = value;
        }

        Type getValue() {
            return this.value;
        }

        boolean isFinal() {
            return this.finalState;
        }

        void add(char c, Node node) {
            this.next.put(this.toCharacter(c), node);
        }

        Node remove(char c) {
            return this.next.remove(this.toCharacter(c));
        }

        Node get(char c) {
            return this.next.get(this.toCharacter(c));
        }

        int size() {
            return this.next.size();
        }

        void destroy() {
            this.next.clear();
            this.next = null;
            this.value = null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Value=");
            sb.append(this.value != null ? this.value.toString() : "null");
            sb.append(" Transitions=[");
            Iterator<Character> i = this.next.keySet().iterator();
            while (i.hasNext()) {
                sb.append(i.next());
                if (!i.hasNext()) continue;
                sb.append(',');
            }
            sb.append(']');
            return sb.toString();
        }
    }
}

