/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.debug.ui.tooltip;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CancellationException;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ToolTipSupport;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.netbeans.spi.debugger.ui.ToolTipUI;
import org.netbeans.spi.debugger.ui.ViewFactory;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Annotation;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;

public abstract class AbstractJSToolTipAnnotation
extends Annotation {
    private static final Set<String> JS_KEYWORDS = new HashSet<String>(Arrays.asList("break", "case", "catch", "class", "continue", "debugger", "default", "delete", "do", "else", "enum", "export", "extends", "finally", "for", "function", "if", "implements", "import", "in", "instanceof", "interface", "let", "new", "return", "package", "private", "protected", "public", "static", "super", "switch", "throw", "try", "typeof", "var", "void", "while", "with", "yield"));
    private static final int MAX_TOOLTIP_TEXT = 100000;
    private static final RequestProcessor RP = new RequestProcessor(AbstractJSToolTipAnnotation.class);

    public String getShortDescription() {
        final Session session = DebuggerManager.getDebuggerManager().getCurrentSession();
        if (session == null) {
            return null;
        }
        final DebuggerEngine engine = session.getCurrentEngine();
        if (engine == null) {
            return null;
        }
        final Line.Part lp = (Line.Part)this.getAttachedAnnotatable();
        if (lp == null) {
            return null;
        }
        Line line = lp.getLine();
        DataObject dob = DataEditorSupport.findDataObject((Line)line);
        if (dob == null) {
            return null;
        }
        final EditorCookie ec = (EditorCookie)dob.getLookup().lookup(EditorCookie.class);
        if (ec == null) {
            return null;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AbstractJSToolTipAnnotation.this.evaluate(session, engine, lp, ec);
            }
        };
        RequestProcessor rp = (RequestProcessor)engine.lookupFirst(null, RequestProcessor.class);
        if (rp == null) {
            rp = RP;
        }
        rp.post(runnable);
        return null;
    }

    protected abstract void handleToolTipClose(DebuggerEngine var1, ToolTipSupport var2);

    protected abstract Pair<String, Object> evaluate(String var1, DebuggerEngine var2) throws CancellationException;

    public String getAnnotationType() {
        return null;
    }

    private void evaluate(Session session, final DebuggerEngine engine, Line.Part lp, EditorCookie ec) {
        Pair<String, Object> toolTipTextAndVar;
        boolean[] isFunctionPtr;
        int offset;
        int column;
        StyledDocument doc;
        final Line line = lp.getLine();
        if (line == null) {
            return;
        }
        try {
            doc = ec.openDocument();
        }
        catch (IOException ex) {
            return;
        }
        final JEditorPane ep = EditorContextDispatcher.getDefault().getMostRecentEditor();
        if (ep == null || ep.getDocument() != doc) {
            return;
        }
        int lineNo = lp.getLine().getLineNumber();
        final String expression = AbstractJSToolTipAnnotation.getIdentifier(doc, ep, lineNo, column = lp.getColumn(), offset = NbDocument.findLineOffset((StyledDocument)doc, (int)lineNo) + column, isFunctionPtr = new boolean[]{false});
        if (expression == null) {
            return;
        }
        FileObject fo = (FileObject)line.getLookup().lookup(FileObject.class);
        if (isFunctionPtr[0]) {
            // empty if block
        }
        try {
            toolTipTextAndVar = this.evaluate(expression, engine);
        }
        catch (CancellationException ex) {
            return;
        }
        if (toolTipTextAndVar == null) {
            return;
        }
        final String toolTip = AbstractJSToolTipAnnotation.truncateLongText((String)toolTipTextAndVar.first());
        final Object var = toolTipTextAndVar.second();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditorUI eui = Utilities.getEditorUI((JTextComponent)ep);
                if (eui == null) {
                    AbstractJSToolTipAnnotation.this.firePropertyChange("shortDescription", null, toolTip);
                    return;
                }
                ToolTipUI.Expandable expandable = var != null ? new ToolTipUI.Expandable(expression, var) : null;
                ToolTipUI.Pinnable pinnable = new ToolTipUI.Pinnable(expression, line.getLineNumber(), "org.netbeans.modules.javascript2.debug.PIN_VALUE_PROVIDER");
                ToolTipUI toolTipUI = ViewFactory.getDefault().createToolTip(toolTip, expandable, pinnable);
                ToolTipSupport tts = toolTipUI.show(ep);
                if (tts != null) {
                    AbstractJSToolTipAnnotation.this.handleToolTipClose(engine, tts);
                }
            }
        });
    }

    private static String getIdentifier(StyledDocument doc, JEditorPane ep, int line, int column, int offset, boolean[] isFunctionPtr) {
        int identEnd;
        int identStart;
        String t = null;
        if (ep.getSelectionStart() <= offset && offset <= ep.getSelectionEnd()) {
            t = ep.getSelectedText();
        }
        if (t != null) {
            return t;
        }
        Element lineElem = NbDocument.findLineRootElement((StyledDocument)doc).getElement(line);
        if (lineElem == null) {
            return null;
        }
        int lineStartOffset = lineElem.getStartOffset();
        int lineLen = lineElem.getEndOffset() - lineStartOffset;
        try {
            t = doc.getText(lineStartOffset, lineLen);
        }
        catch (BadLocationException ble) {
            return null;
        }
        boolean wasDot = false;
        for (identStart = column = Math.min(column, t.length()); identStart > 0; --identStart) {
            char c = t.charAt(identStart - 1);
            if (Character.isJavaIdentifierPart(c)) continue;
            if (c == '.') {
                wasDot = true;
                if (true) continue;
            }
            if (!wasDot || c != ']' && c != '[') break;
        }
        for (identEnd = column; identEnd < lineLen && Character.isJavaIdentifierPart(t.charAt(identEnd)); ++identEnd) {
        }
        if (identStart == identEnd) {
            return null;
        }
        String ident = t.substring(identStart, identEnd).trim();
        if (JS_KEYWORDS.contains(ident)) {
            return null;
        }
        while (identEnd < lineLen && Character.isWhitespace(t.charAt(identEnd))) {
            ++identEnd;
        }
        if (identEnd < lineLen && t.charAt(identEnd) == '(') {
            isFunctionPtr[0] = true;
        }
        return ident;
    }

    private static String truncateLongText(String text) {
        if (text.length() > 100000) {
            text = text.substring(0, 100000) + "...";
        }
        return text;
    }
}

