/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.refactoring;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.PersistenceException;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RenameSupport;
import org.netbeans.modules.form.ResourceSupport;
import org.netbeans.modules.form.refactoring.RefactoringInfo;
import org.netbeans.modules.nbform.FormEditorSupport;
import org.netbeans.modules.refactoring.api.SingleCopyRefactoring;
import org.netbeans.modules.refactoring.spi.BackupFacility;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class FormRefactoringUpdate
extends SimpleRefactoringElementImplementation
implements Transaction {
    private RefactoringInfo refInfo;
    private RefactoringElementImplementation previewElement;
    private FileObject changingFile;
    private FormDataObject formDataObject;
    private FormEditor formEditor;
    private boolean loadingFailed;
    private boolean guardedCodeChanging;
    private boolean transactionDone;
    private boolean formFileRenameDone;
    private List<BackupFacility.Handle> backups;

    public FormRefactoringUpdate(RefactoringInfo refInfo, FileObject changingFile) {
        block3: {
            this.refInfo = refInfo;
            this.changingFile = changingFile;
            try {
                DataObject dobj = DataObject.find((FileObject)changingFile);
                if (dobj instanceof FormDataObject) {
                    this.formDataObject = (FormDataObject)dobj;
                }
            }
            catch (DataObjectNotFoundException ex) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    FormDataObject getFormDataObject() {
        return this.formDataObject;
    }

    RefactoringElementImplementation getPreviewElement() {
        if (this.previewElement == null) {
            this.previewElement = new PreviewElement(this.changingFile);
        }
        return this.previewElement;
    }

    void setGaurdedCodeChanging(boolean b) {
        this.guardedCodeChanging = b;
    }

    boolean isGuardedCodeChanging() {
        return this.guardedCodeChanging;
    }

    public void commit() {
        if (this.previewElement != null && !this.previewElement.isEnabled()) {
            return;
        }
        block7: for (FileObject originalFile : this.refInfo.getOriginalFiles()) {
            switch (this.refInfo.getChangeType()) {
                case VARIABLE_RENAME: {
                    if (!originalFile.equals(this.changingFile)) continue block7;
                    this.renameMetaComponent(this.refInfo.getOldName(originalFile), this.refInfo.getNewName());
                    this.transactionDone = true;
                    continue block7;
                }
                case CLASS_RENAME: {
                    if (originalFile.equals(this.changingFile)) continue block7;
                    this.componentClassRename(originalFile);
                    this.transactionDone = true;
                    continue block7;
                }
                case CLASS_MOVE: {
                    if (originalFile.equals(this.changingFile) || !this.isGuardedCodeChanging()) continue block7;
                    this.componentChange(this.refInfo.getOldName(originalFile), this.refInfo.getNewName(originalFile));
                    this.transactionDone = !this.refInfo.containsOriginalFile(this.changingFile);
                    continue block7;
                }
                case CLASS_DELETE: {
                    if (!originalFile.equals(this.changingFile)) continue block7;
                    this.saveFormForUndo();
                    this.transactionDone = true;
                    continue block7;
                }
                case PACKAGE_RENAME: 
                case FOLDER_RENAME: {
                    if (this.changingFile.getParent().equals(originalFile)) continue block7;
                    this.packageRename(originalFile);
                    this.transactionDone = true;
                    continue block7;
                }
                default: {
                    return;
                }
            }
        }
    }

    public void rollback() {
        if (this.previewElement != null && !this.previewElement.isEnabled()) {
            return;
        }
        this.undoFromBackups();
    }

    public void performChange() {
        if (this.previewElement != null && !this.previewElement.isEnabled()) {
            return;
        }
        if (this.transactionDone) {
            this.processCustomCode();
            return;
        }
        block6: for (FileObject originalFile : this.refInfo.getOriginalFiles()) {
            switch (this.refInfo.getChangeType()) {
                case CLASS_RENAME: {
                    if (!originalFile.equals(this.changingFile)) continue block6;
                    this.formRename();
                    continue block6;
                }
                case CLASS_MOVE: {
                    if (!originalFile.equals(this.changingFile) || !this.prepareForm(false)) continue block6;
                    this.formMove();
                    continue block6;
                }
                case CLASS_COPY: {
                    if (!originalFile.equals(this.changingFile) || !this.prepareForm(false)) continue block6;
                    this.formCopy();
                    continue block6;
                }
                case PACKAGE_RENAME: 
                case FOLDER_RENAME: {
                    this.packageRename(originalFile);
                }
            }
        }
        this.processCustomCode();
    }

    public void undoChange() {
        if (this.previewElement != null && !this.previewElement.isEnabled()) {
            return;
        }
        if (this.transactionDone) {
            return;
        }
        this.undoFromBackups();
    }

    private void renameMetaComponent(String oldName, String newName) {
        RADComponent metacomp;
        if (this.prepareForm(true) && (metacomp = this.formEditor.getFormModel().findRADComponent(oldName)) != null) {
            this.saveFormForUndo();
            this.saveResourcesForContentChangeUndo();
            metacomp.setName(newName);
            this.updateForm(false);
        }
    }

    private void formRename() {
        if (this.prepareForm(true)) {
            this.saveFormForUndo();
            this.saveResourcesForFormRenameUndo();
            ResourceSupport.formMoved((FormModel)this.formEditor.getFormModel(), null, (String)this.refInfo.getOldName(this.changingFile), (boolean)false);
            this.updateForm(true);
        }
    }

    private void componentClassRename(FileObject originalFile) {
        String oldName = this.refInfo.getOldName(originalFile);
        String newName = this.refInfo.getNewName();
        String pkg = ClassPath.getClassPath((FileObject)originalFile, (String)"classpath/source").getResourceName(originalFile.getParent(), '.', false);
        String oldClassName = pkg != null && pkg.length() > 0 ? pkg + "." + oldName : oldName;
        String newClassName = pkg != null && pkg.length() > 0 ? pkg + "." + newName : newName;
        this.componentChange(oldClassName, newClassName);
    }

    private FormEditorSupport getFormEditorSupport() {
        return (FormEditorSupport)this.formDataObject.getFormEditorSupport();
    }

    private void formMove() {
        final FormEditorSupport fes = this.getFormEditorSupport();
        if (fes.isOpened()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FormRefactoringUpdate.this.formEditor = fes.reloadFormEditor();
                    FormRefactoringUpdate.this.formMove2();
                }
            });
        } else {
            assert (!this.formEditor.isFormLoaded());
            this.formMove2();
        }
    }

    private void formMove2() {
        if (this.prepareForm(true)) {
            this.saveFormForUndo();
            FileObject oldFolder = this.changingFile.getParent();
            this.saveResourcesForFormMoveUndo(oldFolder);
            String oldFormName = this.refInfo.getOldName(this.changingFile);
            oldFormName = oldFormName.substring(oldFormName.lastIndexOf(46) + 1);
            ResourceSupport.formMoved((FormModel)this.formEditor.getFormModel(), (FileObject)oldFolder, (String)oldFormName, (boolean)false);
            this.updateForm(true);
        }
    }

    private void formCopy() {
        if (this.refInfo.getRefactoring() instanceof SingleCopyRefactoring) {
            FileObject targetFolder;
            FileObject oldFolder;
            FormDataObject oldForm;
            FileObject oldFile;
            block6: {
                oldFile = this.changingFile;
                oldForm = this.formDataObject;
                oldFolder = this.changingFile.getParent();
                SingleCopyRefactoring copyRef = (SingleCopyRefactoring)this.refInfo.getRefactoring();
                String newName = copyRef.getNewName();
                Lookup target = copyRef.getTarget();
                targetFolder = URLMapper.findFileObject((URL)((URL)target.lookup(URL.class)));
                this.changingFile = targetFolder.getFileObject(newName, "java");
                try {
                    DataObject dobj = DataObject.find((FileObject)this.changingFile);
                    if (dobj instanceof FormDataObject) {
                        this.formDataObject = (FormDataObject)dobj;
                    }
                }
                catch (DataObjectNotFoundException ex) {
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError();
                }
            }
            this.formEditor = null;
            if (this.prepareForm(true)) {
                this.saveResourcesForFormRenameUndo();
                if (oldFolder == targetFolder) {
                    oldFolder = null;
                }
                ResourceSupport.formMoved((FormModel)this.formEditor.getFormModel(), (FileObject)oldFolder, (String)oldFile.getName(), (boolean)true);
                this.updateForm(true);
            }
            this.changingFile = oldFile;
            this.formDataObject = oldForm;
        }
    }

    private void componentChange(String oldClassName, String newClassName) {
        if (oldClassName == null || newClassName == null) {
            return;
        }
        FormEditorSupport fes = this.getFormEditorSupport();
        if (fes.isOpened()) {
            fes.closeFormEditor();
        }
        String[] oldNames = new String[]{oldClassName};
        String[] newNames = new String[]{newClassName};
        this.replaceClassOrPkgName(oldNames, newNames, false);
        this.replaceShortClassName(oldNames, newNames);
    }

    private boolean replaceShortClassName(String[] oldNames, String[] newNames) {
        LinkedList<String> oldList = new LinkedList<String>();
        LinkedList<String> newList = new LinkedList<String>();
        for (int i = 0; i < oldNames.length; ++i) {
            if (!oldNames[i].contains(".")) continue;
            String shortOldName = oldNames[i].substring(oldNames[i].lastIndexOf(46) + 1);
            String shortNewName = newNames[i].substring(newNames[i].lastIndexOf(46) + 1);
            if (shortNewName.equals(shortOldName)) continue;
            oldList.add(shortOldName);
            newList.add(newNames[i]);
        }
        if (!oldList.isEmpty()) {
            oldNames = oldList.toArray(new String[oldList.size()]);
            newNames = newList.toArray(new String[newList.size()]);
            return this.replaceClassOrPkgName(oldNames, newNames, false);
        }
        return false;
    }

    private void packageRename(FileObject originalPkgFile) {
        FormEditorSupport fes = this.getFormEditorSupport();
        if (fes.isOpened()) {
            fes.closeFormEditor();
        }
        String oldName = this.refInfo.getOldName(originalPkgFile);
        String newName = this.refInfo.getNewName();
        if (this.refInfo.getChangeType() == RefactoringInfo.ChangeType.FOLDER_RENAME) {
            String parentPkgName;
            ClassPath cp = ClassPath.getClassPath((FileObject)originalPkgFile, (String)"classpath/source");
            FileObject parent = originalPkgFile.getParent();
            if (cp != null && cp.contains(parent) && (parentPkgName = cp.getResourceName(parent, '.', false)) != null && parentPkgName.length() > 0) {
                oldName = parentPkgName + "." + oldName;
                newName = parentPkgName + "." + newName;
            }
        }
        if (this.replaceClassOrPkgName(new String[]{oldName}, new String[]{newName}, true) && !this.isGuardedCodeChanging()) {
            this.updateForm(true);
        }
    }

    private void processCustomCode() {
        if (this.isGuardedCodeChanging() && !this.formFileRenameDone) {
            boolean replaced = false;
            LinkedList<String> oldList = new LinkedList<String>();
            LinkedList<String> newList = new LinkedList<String>();
            for (FileObject originalFile : this.refInfo.getOriginalFiles()) {
                String oldName = this.refInfo.getOldName(originalFile);
                String newName = this.refInfo.getNewName(originalFile);
                if (oldName == null || newName == null) continue;
                oldList.add(oldName);
                newList.add(newName);
            }
            if (!oldList.isEmpty()) {
                String[] oldNames = oldList.toArray(new String[oldList.size()]);
                String[] newNames = newList.toArray(new String[newList.size()]);
                replaced |= this.replaceClassOrPkgName(oldNames, newNames, false);
                switch (this.refInfo.getChangeType()) {
                    case CLASS_RENAME: 
                    case CLASS_MOVE: {
                        replaced |= this.replaceShortClassName(oldNames, newNames);
                    }
                }
            }
            if (replaced) {
                final FormEditorSupport fes = this.getFormEditorSupport();
                if (fes.isOpened()) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            FormRefactoringUpdate.this.formEditor = fes.reloadFormEditor();
                            FormRefactoringUpdate.this.updateForm(true);
                        }
                    });
                } else {
                    if (this.formEditor != null && this.formEditor.isFormLoaded()) {
                        this.formEditor.closeForm();
                    }
                    if (this.prepareForm(true)) {
                        this.updateForm(true);
                    }
                }
            }
            this.formFileRenameDone = false;
        }
    }

    private void updateForm(boolean saveAll) {
        if (!this.prepareForm(true)) {
            return;
        }
        this.formEditor.getFormModel().fireFormChanged(true);
        FormEditorSupport fes = this.getFormEditorSupport();
        try {
            if (!fes.isOpened()) {
                this.formEditor.saveFormData();
                if (saveAll) {
                    fes.saveSourceOnly();
                }
                this.formEditor.closeForm();
            } else if (saveAll) {
                fes.saveDocument();
            }
        }
        catch (PersistenceException pex) {
            Exceptions.printStackTrace((Throwable)pex);
        }
        catch (IOException ioex) {
            Exceptions.printStackTrace((Throwable)ioex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean prepareForm(boolean load) {
        if (this.formDataObject != null) {
            FormEditor fe = this.getFormEditorSupport().getFormEditor();
            if (fe != null) {
                this.formEditor = fe;
            } else if (this.formEditor == null) {
                this.formEditor = new FormEditor(this.formDataObject, this.formDataObject.getFormEditorSupport());
            }
        }
        if (this.formEditor == null) return false;
        if (this.formEditor.isFormLoaded() || !load) {
            return true;
        }
        if (this.loadingFailed) return false;
        if (this.formEditor.loadForm()) {
            if (!this.formEditor.anyPersistenceError()) return true;
            this.formEditor.closeForm();
            this.loadingFailed = true;
            return false;
        } else {
            this.loadingFailed = true;
        }
        return false;
    }

    private void saveFormForUndo() {
        if (!this.formDataObject.isValid()) {
            FileObject fob = this.formDataObject.getPrimaryFile();
            if (!fob.isValid()) {
                File file = FileUtil.toFile((FileObject)fob);
                fob = FileUtil.toFileObject((File)file);
            }
            try {
                this.formDataObject = (FormDataObject)DataObject.find((FileObject)fob);
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.saveForUndo(this.formDataObject.getFormFile());
    }

    private void saveResourcesForContentChangeUndo() {
        for (URL url : ResourceSupport.getFilesForContentChangeBackup((FormModel)this.formEditor.getFormModel())) {
            this.saveForUndo(url);
        }
    }

    private void saveResourcesForFormRenameUndo() {
        for (URL url : ResourceSupport.getFilesForFormRenameBackup((FormModel)this.formEditor.getFormModel())) {
            this.saveForUndo(url);
        }
    }

    private void saveResourcesForFormMoveUndo(FileObject oldFolder) {
        for (URL url : ResourceSupport.getFilesForFormMoveBackup((FormModel)this.formEditor.getFormModel(), (FileObject)oldFolder)) {
            this.saveForUndo(url);
        }
    }

    private void saveForUndo(final URL url) {
        BackupFacility.Handle id;
        FileObject file = URLMapper.findFileObject((URL)url);
        if (file != null) {
            try {
                id = BackupFacility.getDefault().backup(new FileObject[]{file});
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return;
            }
        } else {
            id = new BackupFacility.Handle(){

                public void restore() throws IOException {
                    FileObject file = URLMapper.findFileObject((URL)url);
                    if (file != null) {
                        file.delete();
                    }
                }
            };
        }
        if (this.backups == null) {
            this.backups = new ArrayList<BackupFacility.Handle>();
        }
        this.backups.add(id);
    }

    private void saveForUndo(FileObject file) {
        try {
            BackupFacility.Handle id = BackupFacility.getDefault().backup(new FileObject[]{file});
            if (this.backups == null) {
                this.backups = new ArrayList<BackupFacility.Handle>();
            }
            this.backups.add(id);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void undoFromBackups() {
        if (this.backups != null) {
            try {
                for (BackupFacility.Handle id : this.backups) {
                    id.restore();
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.backups.clear();
        }
    }

    public String getText() {
        return "GUI form update";
    }

    public String getDisplayText() {
        return NbBundle.getMessage(FormRefactoringUpdate.class, (String)"CTL_RefactoringUpdate2");
    }

    public Lookup getLookup() {
        return Lookup.EMPTY;
    }

    public FileObject getParentFile() {
        return this.changingFile;
    }

    public PositionBounds getPosition() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean replaceClassOrPkgName(String[] oldNames, String[] newNames, boolean pkgName) {
        FileObject formFile = this.formDataObject.getFormFile();
        FileLock lock = null;
        OutputStream os = null;
        try {
            lock = formFile.lock();
            String outString = RenameSupport.renameInFormFile((FileObject)formFile, (String[])oldNames, (String[])newNames, (boolean)pkgName);
            if (outString != null) {
                this.saveForUndo(formFile);
                os = formFile.getOutputStream(lock);
                os.write(outString.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException iOException) {}
            if (lock != null) {
                lock.releaseLock();
            }
        }
        this.formFileRenameDone = true;
        return true;
    }

    private static class PreviewElement
    extends SimpleRefactoringElementImplementation {
        private FileObject file;

        PreviewElement(FileObject file) {
            this.file = file;
        }

        public String getText() {
            return "GUI form update";
        }

        public String getDisplayText() {
            return NbBundle.getMessage(FormRefactoringUpdate.class, (String)"CTL_RefactoringUpdate1");
        }

        public void performChange() {
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return this.file;
        }

        public PositionBounds getPosition() {
            return null;
        }
    }
}

