/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ko4j.debugging;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;
import org.netbeans.modules.ko4j.debugging.MessageDispatcherImpl;
import org.netbeans.modules.web.webkit.debugging.api.TransportStateException;
import org.netbeans.modules.web.webkit.debugging.spi.Command;
import org.netbeans.modules.web.webkit.debugging.spi.Response;
import org.netbeans.modules.web.webkit.debugging.spi.ResponseCallback;
import org.netbeans.modules.web.webkit.debugging.spi.TransportImplementation;
import org.openide.util.Exceptions;

public class Transport
implements TransportImplementation {
    private ObjectInputStream input;
    private ObjectOutputStream output;
    private ResponseCallback callback;
    private MessageDispatcherImpl messageDispatcher;

    public Transport(Socket socket, MessageDispatcherImpl messageDispatcher) {
        try {
            this.messageDispatcher = messageDispatcher;
            this.input = new ObjectInputStream(socket.getInputStream());
            this.output = new ObjectOutputStream(socket.getOutputStream());
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (true) {
                            int length = Transport.this.input.readInt();
                            byte[] bytes = new byte[length];
                            Transport.this.input.readFully(bytes);
                            String message = new String(bytes, StandardCharsets.UTF_8);
                            JSONObject json = (JSONObject)JSONValue.parseWithException((String)message);
                            Transport.this.callback.handleResponse(new Response(json));
                        }
                    }
                    catch (IOException ioex) {
                        ioex.printStackTrace();
                    }
                    catch (ParseException pex) {
                        pex.printStackTrace();
                    }
                    Transport.this.messageDispatcher.dispatchMessage("inspect", null);
                }
            });
            t.start();
        }
        catch (IOException ioex) {
            Exceptions.printStackTrace((Throwable)ioex);
        }
    }

    public boolean attach() {
        return true;
    }

    public boolean detach() {
        return true;
    }

    public synchronized void sendCommand(Command command) throws TransportStateException {
        try {
            String message = command.toString();
            byte[] bytes = message.getBytes(StandardCharsets.UTF_8);
            this.output.writeInt(bytes.length);
            this.output.write(bytes);
            this.output.flush();
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
    }

    public void registerResponseCallback(ResponseCallback callback) {
        this.callback = callback;
    }

    public String getConnectionName() {
        return "";
    }

    public URL getConnectionURL() {
        return null;
    }

    public String getVersion() {
        return "version 1.0";
    }
}

