/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax.traversal;

import java.util.Arrays;
import java.util.HashSet;
import org.netbeans.tax.TreeCharacterData;
import org.netbeans.tax.TreeComment;
import org.netbeans.tax.TreeEntityReference;
import org.netbeans.tax.TreeNode;
import org.netbeans.tax.TreeNodeDecl;
import org.netbeans.tax.TreeProcessingInstruction;
import org.netbeans.tax.TreeReference;
import org.netbeans.tax.traversal.Util;

public final class TreeNodeFilter {
    public static final short FILTER_ACCEPT = 0;
    public static final short FILTER_REJECT = 1;
    public static final short ACCEPT_TYPES = 10;
    public static final short REJECT_TYPES = 11;
    private Class[] nodeTypes;
    private short acceptPolicy;
    public static final TreeNodeFilter SHOW_ALL_FILTER = new TreeNodeFilter();
    public static final TreeNodeFilter SHOW_DATA_ONLY_FILTER = new TreeNodeFilter(new Class[]{TreeComment.class, TreeProcessingInstruction.class}, 11);

    public TreeNodeFilter(Class[] nodeTypes, short acceptPolicy) throws IllegalArgumentException {
        for (int i = 0; i < nodeTypes.length; ++i) {
            if (TreeNodeFilter.isValidNodeType(nodeTypes[i])) continue;
            throw new IllegalArgumentException();
        }
        this.nodeTypes = nodeTypes;
        this.acceptPolicy = acceptPolicy;
    }

    public TreeNodeFilter(Class[] nodeTypes) {
        this(nodeTypes, 10);
    }

    public TreeNodeFilter() {
        this(new Class[]{TreeNode.class});
    }

    public short acceptNode(TreeNode node) {
        short isNotInstanceReturn;
        short isInstanceReturn;
        if (this.acceptPolicy == 10) {
            isInstanceReturn = 0;
            isNotInstanceReturn = 1;
        } else {
            isInstanceReturn = 1;
            isNotInstanceReturn = 0;
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("+ TreeNodeFilter::acceptNode: this = " + this);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("+               ::acceptNode: node = " + node);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("+               ::acceptNode: acceptPolicy = " + this.acceptPolicy);
        }
        for (int i = 0; i < this.nodeTypes.length; ++i) {
            if (!this.nodeTypes[i].isInstance(node)) continue;
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("+               ::acceptNode: RETURN " + isInstanceReturn);
            }
            return isInstanceReturn;
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("+               ::acceptNode: RETURN " + isNotInstanceReturn);
        }
        return isNotInstanceReturn;
    }

    public boolean equals(Object object) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("-=#| TreeNodeFilter.equals");
        }
        if (!(object instanceof TreeNodeFilter)) {
            return false;
        }
        TreeNodeFilter peer = (TreeNodeFilter)object;
        HashSet<Class> thisSet = new HashSet<Class>(Arrays.asList(this.nodeTypes));
        HashSet<Class> peerSet = new HashSet<Class>(Arrays.asList(peer.nodeTypes));
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("-=#|    thisSet = " + thisSet);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("-=#|    peerSet = " + peerSet);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("-=#|    acceptPolicy? " + (this.acceptPolicy == peer.acceptPolicy));
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("-=#|    nodeTypes   ? " + thisSet.equals(peerSet));
        }
        if (this.acceptPolicy != peer.acceptPolicy) {
            return false;
        }
        return thisSet.equals(peerSet);
    }

    public Class[] getNodeTypes() {
        return this.nodeTypes;
    }

    public short getAcceptPolicy() {
        return this.acceptPolicy;
    }

    public static boolean isValidNodeType(Class type) {
        if (TreeNode.class.isAssignableFrom(type)) {
            return true;
        }
        if (TreeCharacterData.class.isAssignableFrom(type)) {
            return true;
        }
        if (TreeReference.class.isAssignableFrom(type)) {
            return true;
        }
        if (TreeEntityReference.class.isAssignableFrom(type)) {
            return true;
        }
        return TreeNodeDecl.class.isAssignableFrom(type);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString()).append(" [ ");
        sb.append("acceptPolicy= [").append(this.acceptPolicy).append("] ");
        if (this.acceptPolicy == 10) {
            sb.append("ACCEPT");
        } else {
            sb.append("REJECT");
        }
        sb.append(" | nodeTypes= [");
        for (int i = 0; i < this.nodeTypes.length; ++i) {
            if (i != 0) {
                sb.append(" | ");
            }
            sb.append(this.nodeTypes[i].getName());
        }
        sb.append("] ]");
        return sb.toString();
    }
}

