/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

class Writer {
    private final OutputStream os;
    private final StringBuilder sb;

    Writer(OutputStream os) {
        this.os = os;
        this.sb = new StringBuilder(524288);
    }

    Writer append(String s) throws IOException {
        return this.append(s, false);
    }

    Writer appendEscaped(String s) throws IOException {
        return this.append(s, true);
    }

    private void escape(int c) {
        if (!(c == 9 || c == 10 || c == 13 || c >= 32 && c <= 55295 || c >= 57344 && c <= 65533 || c >= 65536 && c <= 0x10FFFF)) {
            return;
        }
        switch (c) {
            case 60: {
                this.sb.append("&lt;");
                break;
            }
            case 62: {
                this.sb.append("&gt;");
                break;
            }
            case 38: {
                this.sb.append("&amp;");
                break;
            }
            case 39: {
                this.sb.append("&apos;");
                break;
            }
            case 34: {
                this.sb.append("&quot;");
                break;
            }
            default: {
                if (c > 126 || c < 32) {
                    this.sb.append("&#x").append(Integer.toHexString(c)).append(';');
                    break;
                }
                this.sb.append((char)c);
            }
        }
    }

    private Writer append(String s, boolean escape) throws IOException {
        if (escape) {
            int codePoint;
            for (int offset = 0; offset < s.length(); offset += Character.charCount(codePoint)) {
                codePoint = s.codePointAt(offset);
                this.escape(codePoint);
            }
        } else {
            this.sb.append(s);
        }
        this.check();
        return this;
    }

    private void check() throws IOException {
        if (this.sb.capacity() - this.sb.length() < 1024) {
            this.flush();
        }
    }

    Writer append(char c) throws IOException {
        this.sb.append(c);
        this.check();
        return this;
    }

    Writer append(int n) throws IOException {
        this.sb.append(n);
        this.check();
        return this;
    }

    Writer append(long n) throws IOException {
        this.sb.append(n);
        this.check();
        return this;
    }

    Writer append(double n) throws IOException {
        this.sb.append(n);
        this.check();
        return this;
    }

    void flush() throws IOException {
        this.os.write(this.sb.toString().getBytes(StandardCharsets.UTF_8));
        this.sb.setLength(0);
    }
}

