/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.libraries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation2;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

public class J2SELibrarySourceForBinaryQuery
implements SourceForBinaryQueryImplementation2,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(J2SELibrarySourceForBinaryQuery.class.getName());
    private final Map<URL, SourceForBinaryQueryImplementation2.Result> cache = new ConcurrentHashMap<URL, SourceForBinaryQueryImplementation2.Result>();
    private final Map<URL, URL> normalizedURLCache = new ConcurrentHashMap<URL, URL>();
    private final AtomicBoolean lmListens = new AtomicBoolean();
    private Iterable<? extends LibraryManager> lmCache;
    private int lmCacheEvntCnt;

    public SourceForBinaryQueryImplementation2.Result findSourceRoots2(URL binaryRoot) {
        SourceForBinaryQueryImplementation2.Result res = this.cache.get(binaryRoot);
        if (res != null) {
            return res;
        }
        try {
            boolean isNormalizedURL = J2SELibrarySourceForBinaryQuery.isNormalizedURL(binaryRoot);
            for (LibraryManager libraryManager : this.getLibraryManagers()) {
                for (Library lib : libraryManager.getLibraries()) {
                    if (!lib.getType().equals("j2se")) continue;
                    Iterator iterator = lib.getContent("classpath").iterator();
                    while (iterator.hasNext()) {
                        URL entry;
                        URL normalizedEntry = entry = (URL)iterator.next();
                        if (isNormalizedURL) {
                            try {
                                normalizedEntry = this.getNormalizedURL(normalizedEntry);
                            }
                            catch (MalformedURLException ex) {
                                LOG.log(Level.INFO, "Invalid URL: " + normalizedEntry, ex);
                                return null;
                            }
                        }
                        if (!binaryRoot.equals(normalizedEntry)) continue;
                        res = new Result(entry, libraryManager, lib);
                        this.cache.put(binaryRoot, res);
                        return res;
                    }
                }
            }
        }
        catch (MalformedURLException | URISyntaxException ex) {
            LOG.log(Level.INFO, "Invalid URL: " + binaryRoot, ex);
        }
        return null;
    }

    public SourceForBinaryQuery.Result findSourceRoots(URL binaryRoot) {
        return this.findSourceRoots2(binaryRoot);
    }

    public void preInit() {
        for (LibraryManager libraryManager : this.getLibraryManagers()) {
            for (Library lib : libraryManager.getLibraries()) {
                if (!"j2se".equals(lib.getType())) continue;
                for (URL url : lib.getContent("classpath")) {
                    try {
                        this.getNormalizedURL(url);
                    }
                    catch (MalformedURLException ex) {
                        LOG.log(Level.INFO, "Invalid URL: " + url, ex);
                    }
                }
            }
        }
    }

    private URL getNormalizedURL(URL url) throws MalformedURLException {
        FileObject fo;
        if (J2SELibrarySourceForBinaryQuery.isNormalizedURL(url)) {
            return url;
        }
        URL normalizedURL = this.normalizedURLCache.get(url);
        if (normalizedURL == null && (fo = URLMapper.findFileObject((URL)url)) != null) {
            normalizedURL = fo.toURL();
            this.normalizedURLCache.put(url, normalizedURL);
        }
        return normalizedURL;
    }

    private static boolean isNormalizedURL(URL url) throws MalformedURLException {
        if ("jar".equals(url.getProtocol())) {
            String path = url.getPath();
            int index = path.indexOf("!/");
            if (index < 0) {
                throw new MalformedURLException();
            }
            String jarPath = path.substring(0, index);
            if (jarPath.indexOf("file://") > -1 && jarPath.indexOf("file:////") == -1) {
                jarPath = jarPath.replaceFirst("file://", "file:////");
            }
            url = new URL(jarPath);
        }
        return "file".equals(url.getProtocol());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("openManagers".equals(evt.getPropertyName())) {
            J2SELibrarySourceForBinaryQuery j2SELibrarySourceForBinaryQuery = this;
            synchronized (j2SELibrarySourceForBinaryQuery) {
                this.lmCache = null;
                ++this.lmCacheEvntCnt;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private Iterable<? extends LibraryManager> getLibraryManagers() {
        int current;
        Iterable<Object> res;
        J2SELibrarySourceForBinaryQuery j2SELibrarySourceForBinaryQuery = this;
        synchronized (j2SELibrarySourceForBinaryQuery) {
            res = this.lmCache;
            current = this.lmCacheEvntCnt;
        }
        if (res == null) {
            if (this.lmListens.compareAndSet(false, true)) {
                LibraryManager.addOpenManagersPropertyChangeListener((PropertyChangeListener)this);
            }
            res = LibraryManager.getOpenManagers();
            j2SELibrarySourceForBinaryQuery = this;
            synchronized (j2SELibrarySourceForBinaryQuery) {
                if (current == this.lmCacheEvntCnt) {
                    this.lmCache = res;
                } else if (this.lmCache != null) {
                    res = this.lmCache;
                }
            }
        }
        return res;
    }

    @CheckForNull
    public static J2SELibrarySourceForBinaryQuery getInstance() {
        J2SELibrarySourceForBinaryQuery result = (J2SELibrarySourceForBinaryQuery)Lookup.getDefault().lookup(J2SELibrarySourceForBinaryQuery.class);
        if (result == null) {
            for (SourceForBinaryQueryImplementation impl : Lookup.getDefault().lookupAll(SourceForBinaryQueryImplementation.class)) {
                if (J2SELibrarySourceForBinaryQuery.class != impl.getClass()) continue;
                result = (J2SELibrarySourceForBinaryQuery)impl;
                break;
            }
        }
        return result;
    }

    private static class Result
    implements SourceForBinaryQueryImplementation2.Result,
    PropertyChangeListener {
        private final LibraryManager manager;
        private final URI entry;
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private FileObject[] cache;
        private volatile Library lib;

        public Result(@NonNull URL queryFor, @NonNull LibraryManager manager, @NonNull Library lib) throws URISyntaxException {
            this.entry = queryFor.toURI();
            this.manager = manager;
            this.lib = lib;
            manager.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)manager));
            lib.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)lib));
        }

        public synchronized FileObject[] getRoots() {
            if (this.cache == null) {
                Library _lib = this.lib;
                if (Result.getResolvedURIContent(_lib, this.manager, "classpath").contains(this.entry)) {
                    ArrayList<FileObject> result = new ArrayList<FileObject>();
                    for (URL u : _lib.getContent("src")) {
                        FileObject sourceRoot = URLMapper.findFileObject((URL)u);
                        if (sourceRoot == null) continue;
                        result.add(sourceRoot);
                    }
                    this.cache = result.toArray(new FileObject[result.size()]);
                } else {
                    this.cache = new FileObject[0];
                }
            }
            return this.cache;
        }

        public synchronized void addChangeListener(ChangeListener l) {
            assert (l != null) : "Listener cannot be null";
            this.cs.addChangeListener(l);
        }

        public synchronized void removeChangeListener(ChangeListener l) {
            assert (l != null) : "Listener cannot be null";
            this.cs.removeChangeListener(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent event) {
            String propName = event.getPropertyName();
            if ("content".equals(propName)) {
                Result result = this;
                synchronized (result) {
                    this.cache = null;
                }
                this.cs.fireChange();
            } else if ("libraries".equals(propName) && this.manager.equals(event.getSource())) {
                boolean change;
                Library currentLib = this.lib;
                Library newLib = this.manager.getLibrary(currentLib.getName());
                if (newLib == null) {
                    change = true;
                } else if (newLib == currentLib) {
                    change = false;
                } else {
                    List newBin = newLib.getURIContent("classpath");
                    if (newBin == null || !newBin.contains(this.entry)) {
                        change = true;
                    } else {
                        List newSrc = newLib.getURIContent("src");
                        boolean bl = change = newSrc == null || !newSrc.equals(currentLib.getURIContent("src"));
                    }
                }
                if (change) {
                    LOG.log(Level.FINE, "Library {0} redefined.", currentLib.getName());
                    boolean fire = false;
                    Result result = this;
                    synchronized (result) {
                        if (newLib != null) {
                            this.lib = newLib;
                            fire = true;
                        }
                        this.cache = null;
                    }
                    if (fire) {
                        this.cs.fireChange();
                    }
                }
            }
        }

        public boolean preferSources() {
            return false;
        }

        private static List<? extends URI> getResolvedURIContent(@NonNull Library lib, @NonNull LibraryManager manager, @NonNull String type) {
            List content = lib.getURIContent(type);
            URL location = manager.getLocation();
            if (location == null) {
                return content;
            }
            ArrayList<URI> res = new ArrayList<URI>(content.size());
            for (URI toResolve : content) {
                URI resolved = LibrariesSupport.resolveLibraryEntryURI((URL)location, (URI)toResolve);
                if (resolved != null) {
                    res.add(resolved);
                    continue;
                }
                LOG.log(Level.WARNING, "Cannot resolve: {0} in: {1}", new Object[]{toResolve, location});
            }
            return res;
        }
    }
}

