/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.php.dbgp.models.ViewModelSupport;
import org.netbeans.modules.php.dbgp.models.nodes.AbstractModelNode;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public class VariablesModelFilter
extends ViewModelSupport
implements TreeModelFilter {
    private static final String LOCALS_VIEW = "LocalsView";
    private static AtomicReference<FilterType[]> myShowFilters;

    public static void setFilters(FilterType[] types) {
        myShowFilters.set(types);
        DebuggerEngine engine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        TreeModelFilter filter = (TreeModelFilter)engine.lookupFirst(LOCALS_VIEW, TreeModelFilter.class);
        if (filter != null) {
            assert (filter instanceof VariablesModelFilter);
            ((VariablesModelFilter)filter).refresh();
        }
    }

    public Object[] getChildren(TreeModel original, Object node, int from, int to) throws UnknownTypeException {
        List<Object> list = this.getFilteredChildren(original, node);
        if (from >= list.size()) {
            return new Object[0];
        }
        int end = Math.min(list.size(), to);
        list = list.subList(from, end);
        return list.toArray(new Object[list.size()]);
    }

    public int getChildrenCount(TreeModel original, Object node) throws UnknownTypeException {
        return this.getFilteredChildren(original, node).size();
    }

    public Object getRoot(TreeModel original) {
        return original.getRoot();
    }

    public boolean isLeaf(TreeModel original, Object node) throws UnknownTypeException {
        return original.isLeaf(node);
    }

    @Override
    public void clearModel() {
    }

    public static FilterType[] getFilters() {
        return myShowFilters.get();
    }

    private List<Object> getFilteredChildren(TreeModel original, Object node) throws UnknownTypeException {
        Object[] children;
        int size = original.getChildrenCount(node);
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object object : children = original.getChildren(node, 0, size)) {
            if (!(object instanceof AbstractModelNode)) {
                result.add(object);
                continue;
            }
            AbstractModelNode var = (AbstractModelNode)object;
            FilterType[] types = VariablesModelFilter.getFilters();
            HashSet<FilterType> set = new HashSet<FilterType>(Arrays.asList(types));
            if (!var.hasType(set)) continue;
            result.add(object);
        }
        return result;
    }

    private static void initFilters() {
        myShowFilters = new AtomicReference();
        FilterType[] filters = new FilterType[]{FilterType.ARRAY, FilterType.OBJECT, FilterType.SCALARS, FilterType.SUPERGLOBALS, FilterType.RESOURCE, FilterType.NULL};
        myShowFilters.set(filters);
    }

    static {
        VariablesModelFilter.initFilters();
    }

    public static enum FilterType {
        SCALARS,
        ARRAY,
        OBJECT,
        RESOURCE,
        NULL,
        UNINIT,
        SUPERGLOBALS;

    }
}

