/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.api;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import java.util.prefs.NodeChangeEvent;
import java.util.prefs.NodeChangeListener;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.docker.api.DockerInstance;
import org.newsclub.net.unix.AFUNIXSocket;
import org.openide.util.ChangeSupport;
import org.openide.util.NbPreferences;
import org.openide.util.Parameters;

public final class DockerSupport {
    private static final Logger LOGGER = Logger.getLogger(DockerSupport.class.getName());
    private static DockerSupport support;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final Map<String, DockerInstance> instances = new HashMap<String, DockerInstance>();
    private boolean initialized;

    private DockerSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DockerSupport getDefault() {
        Object object = DockerSupport.class;
        synchronized (DockerSupport.class) {
            if (support == null) {
                support = new DockerSupport();
                Preferences p = NbPreferences.forModule(DockerInstance.class).node("instances");
                p.addNodeChangeListener(new NodeChangeListener(){

                    @Override
                    public void childAdded(NodeChangeEvent evt) {
                        support.refresh();
                    }

                    @Override
                    public void childRemoved(NodeChangeEvent evt) {
                        support.refresh();
                    }
                });
            }
            DockerSupport ret = support;
            // ** MonitorExit[var1] (shouldn't be in output)
            object = ret;
            synchronized (object) {
                if (!ret.isInitialized()) {
                    ret.refresh();
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DockerInstance addInstance(@NonNull DockerInstance instance) {
        Parameters.notNull((CharSequence)"instance", (Object)instance);
        String url = instance.getUrl();
        DockerSupport dockerSupport = this;
        synchronized (dockerSupport) {
            if (this.instances.containsKey(url)) {
                throw new IllegalStateException("Docker instance already exist: " + url);
            }
            instance.save();
            this.instances.put(url, instance);
        }
        this.changeSupport.fireChange();
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstance(@NonNull DockerInstance instance) {
        Parameters.notNull((CharSequence)"instance", (Object)instance);
        DockerSupport dockerSupport = this;
        synchronized (dockerSupport) {
            this.instances.remove(instance.getUrl());
            instance.delete();
        }
        this.changeSupport.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends DockerInstance> getInstances() {
        DockerSupport dockerSupport = this;
        synchronized (dockerSupport) {
            return new HashSet<DockerInstance>(this.instances.values());
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public boolean isSocketSupported() {
        return AFUNIXSocket.isSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInitialized() {
        DockerSupport dockerSupport = this;
        synchronized (dockerSupport) {
            return this.initialized;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        boolean fire = false;
        DockerSupport dockerSupport = this;
        synchronized (dockerSupport) {
            this.initialized = true;
            HashSet<String> toRemove = new HashSet<String>(this.instances.keySet());
            for (DockerInstance dockerInstance : DockerInstance.loadAll()) {
                if (this.instances.get(dockerInstance.getUrl()) == null) {
                    fire = true;
                    this.instances.put(dockerInstance.getUrl(), dockerInstance);
                }
                toRemove.remove(dockerInstance.getUrl());
            }
            if (this.instances.keySet().removeAll(toRemove)) {
                fire = true;
            }
        }
        if (fire) {
            this.changeSupport.fireChange();
        }
    }
}

