/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class GetExadataInfrastructureUnAllocatedResourcesRequest
extends BmcRequest<Void> {
    private String exadataInfrastructureId;
    private String opcRequestId;
    private List<String> dbServers;

    public String getExadataInfrastructureId() {
        return this.exadataInfrastructureId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<String> getDbServers() {
        return this.dbServers;
    }

    public Builder toBuilder() {
        return new Builder().exadataInfrastructureId(this.exadataInfrastructureId).opcRequestId(this.opcRequestId).dbServers(this.dbServers);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",exadataInfrastructureId=").append(String.valueOf(this.exadataInfrastructureId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",dbServers=").append(String.valueOf(this.dbServers));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetExadataInfrastructureUnAllocatedResourcesRequest)) {
            return false;
        }
        GetExadataInfrastructureUnAllocatedResourcesRequest other = (GetExadataInfrastructureUnAllocatedResourcesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.exadataInfrastructureId, other.exadataInfrastructureId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.dbServers, other.dbServers);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.exadataInfrastructureId == null ? 43 : this.exadataInfrastructureId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.dbServers == null ? 43 : this.dbServers.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetExadataInfrastructureUnAllocatedResourcesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String exadataInfrastructureId = null;
        private String opcRequestId = null;
        private List<String> dbServers = null;

        public Builder exadataInfrastructureId(String exadataInfrastructureId) {
            this.exadataInfrastructureId = exadataInfrastructureId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder dbServers(List<String> dbServers) {
            this.dbServers = dbServers;
            return this;
        }

        public Builder dbServers(String singularValue) {
            return this.dbServers(Arrays.asList(singularValue));
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetExadataInfrastructureUnAllocatedResourcesRequest o) {
            this.exadataInfrastructureId(o.getExadataInfrastructureId());
            this.opcRequestId(o.getOpcRequestId());
            this.dbServers(o.getDbServers());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetExadataInfrastructureUnAllocatedResourcesRequest build() {
            GetExadataInfrastructureUnAllocatedResourcesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetExadataInfrastructureUnAllocatedResourcesRequest buildWithoutInvocationCallback() {
            GetExadataInfrastructureUnAllocatedResourcesRequest request = new GetExadataInfrastructureUnAllocatedResourcesRequest();
            request.exadataInfrastructureId = this.exadataInfrastructureId;
            request.opcRequestId = this.opcRequestId;
            request.dbServers = this.dbServers;
            return request;
        }
    }
}

