/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.dependency.ArtifactSpec;
import org.netbeans.modules.project.dependency.ProjectArtifactsQuery;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public abstract class AbstractMicronautArtifacts
implements PropertyChangeListener {
    private static final List<ArtifactSpec> UNKNOWN = new ArrayList<ArtifactSpec>();
    private static final RequestProcessor ARTIFACTS_RP = new RequestProcessor(AbstractMicronautArtifacts.class);
    private final Project project;
    protected final ProjectArtifactsQuery.Filter query;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private List<ArtifactSpec> artifacts;
    private PropertyChangeListener projectL;
    private RequestProcessor.Task refreshTask;
    private int eventNo;

    public AbstractMicronautArtifacts(Project project, ProjectArtifactsQuery.Filter query) {
        this.project = project;
        this.query = query;
    }

    public final Project getProject() {
        return this.project;
    }

    protected abstract List<ArtifactSpec> compute();

    protected abstract void attach(PropertyChangeListener var1);

    protected abstract void detach(PropertyChangeListener var1);

    protected abstract boolean accept(PropertyChangeEvent var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener l) {
        AbstractMicronautArtifacts abstractMicronautArtifacts = this;
        synchronized (abstractMicronautArtifacts) {
            if (this.projectL == null) {
                this.projectL = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.project);
                this.attach(this.projectL);
            }
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener l) {
        AbstractMicronautArtifacts abstractMicronautArtifacts = this;
        synchronized (abstractMicronautArtifacts) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ArtifactSpec> getArtifacts() {
        AbstractMicronautArtifacts abstractMicronautArtifacts = this;
        synchronized (abstractMicronautArtifacts) {
            if (this.artifacts != null) {
                return this.artifacts;
            }
        }
        return this.refresh(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ArtifactSpec> refresh(List<ArtifactSpec> old) {
        int mySerial;
        AbstractMicronautArtifacts abstractMicronautArtifacts = this;
        synchronized (abstractMicronautArtifacts) {
            mySerial = this.eventNo;
        }
        List<ArtifactSpec> as = Collections.unmodifiableList(this.compute());
        AbstractMicronautArtifacts abstractMicronautArtifacts2 = this;
        synchronized (abstractMicronautArtifacts2) {
            if (mySerial != this.eventNo) {
                return as;
            }
            if (this.artifacts != null) {
                return this.artifacts;
            }
            if (as.equals(old)) {
                this.artifacts = old;
                return old;
            }
            this.artifacts = as;
            if (this.listeners == null || this.listeners.isEmpty()) {
                return as;
            }
        }
        this.fireChanged();
        return as;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.accept(evt)) {
            return;
        }
        boolean fire = false;
        AbstractMicronautArtifacts abstractMicronautArtifacts = this;
        synchronized (abstractMicronautArtifacts) {
            ++this.eventNo;
            List<ArtifactSpec> old = this.artifacts;
            this.artifacts = null;
            if (old != null) {
                if (this.refreshTask != null) {
                    this.refreshTask.cancel();
                }
                this.refreshTask = ARTIFACTS_RP.post(() -> this.refresh(old), 50);
                return;
            }
            if (this.listeners != null && !this.listeners.isEmpty()) {
                fire = true;
            }
        }
        if (fire) {
            this.fireChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChanged() {
        ChangeListener[] ll;
        AbstractMicronautArtifacts abstractMicronautArtifacts = this;
        synchronized (abstractMicronautArtifacts) {
            if (this.listeners == null || this.listeners.isEmpty()) {
                return;
            }
            ll = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
        }
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : ll) {
            l.stateChanged(e);
        }
    }

    public Collection<ArtifactSpec> getExcludedArtifacts() {
        return null;
    }
}

