/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.provider.mappersync;

import java.util.function.Consumer;
import org.keycloak.broker.provider.mappersync.AbstractConfigPropertySynchronizer;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public class RoleConfigPropertyByRoleNameSynchronizer
extends AbstractConfigPropertySynchronizer<RoleModel.RoleNameChangeEvent> {
    public static final RoleConfigPropertyByRoleNameSynchronizer INSTANCE = new RoleConfigPropertyByRoleNameSynchronizer();

    private RoleConfigPropertyByRoleNameSynchronizer() {
    }

    @Override
    public Class<RoleModel.RoleNameChangeEvent> getEventClass() {
        return RoleModel.RoleNameChangeEvent.class;
    }

    @Override
    public RealmModel extractRealm(RoleModel.RoleNameChangeEvent event) {
        return event.getRealm();
    }

    @Override
    public String getConfigPropertyName() {
        return "role";
    }

    @Override
    protected void updateConfigPropertyIfNecessary(RoleModel.RoleNameChangeEvent event, String currentPropertyValue, Consumer<String> propertyUpdater) {
        String previousRoleQualifier = KeycloakModelUtils.buildRoleQualifier(event.getClientId(), event.getPreviousName());
        if (previousRoleQualifier.equals(currentPropertyValue)) {
            String newRoleQualifier = KeycloakModelUtils.buildRoleQualifier(event.getClientId(), event.getNewName());
            propertyUpdater.accept(newRoleQualifier);
        }
    }
}

