/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Set;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.net.ssl.SSLHandshakeException;
import org.jboss.logging.Logger;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.LDAPCapabilityRepresentation;
import org.keycloak.representations.idm.TestLdapConnectionRepresentation;
import org.keycloak.services.ServicesLogger;
import org.keycloak.storage.ldap.LDAPConfig;
import org.keycloak.storage.ldap.idm.store.ldap.LDAPContextManager;
import org.keycloak.storage.ldap.idm.store.ldap.LDAPIdentityStore;

public class LDAPServerCapabilitiesManager {
    private static final Logger logger = Logger.getLogger(LDAPServerCapabilitiesManager.class);
    public static final String TEST_CONNECTION = "testConnection";
    public static final String TEST_AUTHENTICATION = "testAuthentication";
    public static final String QUERY_SERVER_CAPABILITIES = "queryServerCapabilities";

    public static LDAPConfig buildLDAPConfig(TestLdapConnectionRepresentation config, RealmModel realm) {
        String bindCredential = config.getBindCredential();
        if (config.getComponentId() != null && "**********".equals(bindCredential)) {
            bindCredential = (String)realm.getComponent(config.getComponentId()).getConfig().getFirst((Object)"bindCredential");
        }
        MultivaluedHashMap configMap = new MultivaluedHashMap();
        configMap.putSingle((Object)"authType", (Object)config.getAuthType());
        configMap.putSingle((Object)"bindDn", (Object)config.getBindDn());
        configMap.putSingle((Object)"bindCredential", (Object)bindCredential);
        configMap.add((Object)"connectionUrl", (Object)config.getConnectionUrl());
        configMap.add((Object)"useTruststoreSpi", (Object)config.getUseTruststoreSpi());
        configMap.putSingle((Object)"connectionTimeout", (Object)config.getConnectionTimeout());
        configMap.add((Object)"startTls", (Object)config.getStartTls());
        return new LDAPConfig((MultivaluedHashMap<String, String>)configMap);
    }

    public static Set<LDAPCapabilityRepresentation> queryServerCapabilities(TestLdapConnectionRepresentation config, KeycloakSession session, RealmModel realm) {
        if (!QUERY_SERVER_CAPABILITIES.equals(config.getAction())) {
            ServicesLogger.LOGGER.unknownAction(config.getAction());
            return Collections.emptySet();
        }
        LDAPConfig ldapConfig = LDAPServerCapabilitiesManager.buildLDAPConfig(config, realm);
        return new LDAPIdentityStore(session, ldapConfig).queryServerCapabilities();
    }

    public static String getErrorCode(Throwable throwable) {
        String errorMsg = "UnknownError";
        if (throwable instanceof NamingException) {
            errorMsg = "NamingError";
        }
        if (throwable instanceof AuthenticationException) {
            errorMsg = "AuthenticationFailure";
        }
        if (throwable instanceof CommunicationException) {
            errorMsg = "CommunicationError";
        }
        if (throwable instanceof ServiceUnavailableException) {
            errorMsg = "ServiceUnavailable";
        }
        if (throwable instanceof InvalidNameException) {
            errorMsg = "InvalidName";
        }
        if (throwable instanceof ServiceUnavailableException) {
            errorMsg = "ServiceUnavailable";
        }
        if (throwable instanceof InvalidBindDNException) {
            errorMsg = "InvalidBindDN";
        }
        if (throwable instanceof NamingException) {
            Throwable rootCause = ((NamingException)throwable).getRootCause();
            if (rootCause instanceof MalformedURLException) {
                errorMsg = "MalformedURL";
            }
            if (rootCause instanceof NoRouteToHostException) {
                errorMsg = "NoRouteToHost";
            }
            if (rootCause instanceof ConnectException) {
                errorMsg = "ConnectionFailed";
            }
            if (rootCause instanceof UnknownHostException) {
                errorMsg = "UnknownHost";
            }
            if (rootCause instanceof SSLHandshakeException) {
                errorMsg = "SSLHandshakeFailed";
            }
            if (rootCause instanceof SocketException) {
                errorMsg = "SocketReset";
            }
        }
        return errorMsg;
    }

    public static void testLDAP(TestLdapConnectionRepresentation config, KeycloakSession session, RealmModel realm) throws NamingException {
        if (!TEST_CONNECTION.equals(config.getAction()) && !TEST_AUTHENTICATION.equals(config.getAction())) {
            ServicesLogger.LOGGER.unknownAction(config.getAction());
            throw new NamingException("testLDAP unknown action");
        }
        if (TEST_AUTHENTICATION.equals(config.getAction())) {
            if ((config.getBindDn() == null || config.getBindDn().isEmpty()) && "simple".equals(config.getAuthType())) {
                throw new InvalidBindDNException("Unknown bind DN");
            }
        } else {
            config.setAuthType("none");
        }
        LDAPConfig ldapConfig = LDAPServerCapabilitiesManager.buildLDAPConfig(config, realm);
        try (LDAPContextManager ldapContextManager = LDAPContextManager.create(session, ldapConfig);){
            ldapContextManager.getLdapContext();
        }
        catch (Exception ne) {
            String errorMessage = TEST_AUTHENTICATION.equals(config.getAction()) ? "Error when authenticating to LDAP: " : "Error when connecting to LDAP: ";
            ServicesLogger.LOGGER.errorAuthenticating(ne, errorMessage + ne.getMessage());
            throw ne;
        }
    }

    public static class InvalidBindDNException
    extends NamingException {
        public InvalidBindDNException(String s) {
            super(s);
        }
    }
}

