/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.admin.cli.operations;

import java.util.List;
import org.keycloak.client.admin.cli.util.HttpUtil;

public class GroupOperations {
    public static String getIdFromName(String rootUrl, String realm, String auth, String groupname) {
        return HttpUtil.getIdForType(rootUrl, realm, auth, "groups", "name", groupname, "name");
    }

    public static String getIdFromPath(String rootUrl, String realm, String auth, String path) {
        return HttpUtil.getIdForType(rootUrl, realm, auth, "groups", "path", path, "path");
    }

    public static void addRealmRoles(String rootUrl, String realm, String auth, String groupid, List<?> roles) {
        String resourceUrl = HttpUtil.composeResourceUrl(rootUrl, realm, "groups/" + groupid + "/role-mappings/realm");
        HttpUtil.doPostJSON(resourceUrl, auth, roles);
    }

    public static void addClientRoles(String rootUrl, String realm, String auth, String groupid, String idOfClient, List<?> roles) {
        String resourceUrl = HttpUtil.composeResourceUrl(rootUrl, realm, "groups/" + groupid + "/role-mappings/clients/" + idOfClient);
        HttpUtil.doPostJSON(resourceUrl, auth, roles);
    }

    public static void removeRealmRoles(String rootUrl, String realm, String auth, String groupid, List<?> roles) {
        String resourceUrl = HttpUtil.composeResourceUrl(rootUrl, realm, "groups/" + groupid + "/role-mappings/realm");
        HttpUtil.doDeleteJSON(resourceUrl, auth, roles);
    }

    public static void removeClientRoles(String rootUrl, String realm, String auth, String groupid, String idOfClient, List<?> roles) {
        String resourceUrl = HttpUtil.composeResourceUrl(rootUrl, realm, "groups/" + groupid + "/role-mappings/clients/" + idOfClient);
        HttpUtil.doDeleteJSON(resourceUrl, auth, roles);
    }
}

