/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.admin.cli.commands;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.jboss.aesh.cl.GroupCommandDefinition;
import org.jboss.aesh.console.command.CommandException;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.keycloak.client.admin.cli.commands.AbstractGlobalOptionsCmd;
import org.keycloak.client.admin.cli.commands.AddRolesCmd;
import org.keycloak.client.admin.cli.commands.ConfigCmd;
import org.keycloak.client.admin.cli.commands.CreateCmd;
import org.keycloak.client.admin.cli.commands.DeleteCmd;
import org.keycloak.client.admin.cli.commands.GetCmd;
import org.keycloak.client.admin.cli.commands.GetRolesCmd;
import org.keycloak.client.admin.cli.commands.HelpCmd;
import org.keycloak.client.admin.cli.commands.NewObjectCmd;
import org.keycloak.client.admin.cli.commands.RemoveRolesCmd;
import org.keycloak.client.admin.cli.commands.SetPasswordCmd;
import org.keycloak.client.admin.cli.commands.UpdateCmd;
import org.keycloak.client.admin.cli.util.ConfigUtil;
import org.keycloak.client.admin.cli.util.IoUtil;
import org.keycloak.client.admin.cli.util.OsUtil;

@GroupCommandDefinition(name="kcadm", description="COMMAND [ARGUMENTS]", groupCommands={HelpCmd.class, ConfigCmd.class, NewObjectCmd.class, CreateCmd.class, GetCmd.class, UpdateCmd.class, DeleteCmd.class, AddRolesCmd.class, RemoveRolesCmd.class, GetRolesCmd.class, SetPasswordCmd.class})
public class KcAdmCmd
extends AbstractGlobalOptionsCmd {
    public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
        try {
            if (this.printHelp()) {
                CommandResult commandResult = CommandResult.SUCCESS;
                return commandResult;
            }
            if (this.args != null && this.args.size() > 0) {
                IoUtil.printErr("Unknown command: " + (String)this.args.get(0));
                CommandResult commandResult = CommandResult.FAILURE;
                return commandResult;
            }
            IoUtil.printOut(KcAdmCmd.usage());
            CommandResult commandResult = CommandResult.FAILURE;
            return commandResult;
        }
        finally {
            commandInvocation.stop();
        }
    }

    public static String usage() {
        StringWriter sb = new StringWriter();
        PrintWriter out = new PrintWriter(sb);
        out.println("Keycloak Admin CLI");
        out.println();
        out.println("Use '" + OsUtil.CMD + " config credentials' command with username and password to start a session against a specific");
        out.println("server and realm.");
        out.println();
        out.println("For example:");
        out.println();
        out.println("  " + OsUtil.PROMPT + " " + OsUtil.CMD + " config credentials --server http://localhost:8080 --realm master --user admin");
        out.println("  Enter password: ");
        out.println("  Logging into http://localhost:8080 as user admin of realm master");
        out.println();
        out.println("Any configured username can be used for login, but to perform admin operations the user");
        out.println("needs proper roles, otherwise operations will fail.");
        out.println();
        out.println("Usage: " + OsUtil.CMD + " COMMAND [ARGUMENTS]");
        out.println();
        out.println("Global options:");
        out.println("  -x            Print full stack trace when exiting with error");
        out.println("  --help        Print help for specific command");
        out.println("  --config      Path to the config file (" + ConfigUtil.DEFAULT_CONFIG_FILE_STRING + " by default)");
        out.println();
        out.println("Commands: ");
        out.println("  config        Set up credentials, and other configuration settings using the config file");
        out.println("  create        Create new resource");
        out.println("  get           Get a resource");
        out.println("  update        Update a resource");
        out.println("  delete        Delete a resource");
        out.println("  get-roles     List roles for a user or a group");
        out.println("  add-roles     Add role to a user or a group");
        out.println("  remove-roles  Remove role from a user or a group");
        out.println("  set-password  Re-set password for a user");
        out.println("  help          This help");
        out.println();
        out.println("Use '" + OsUtil.CMD + " help <command>' for more information about a given command.");
        return sb.toString();
    }
}

