/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Properties;
import java.util.Vector;
import java.util.function.Consumer;
import java.util.logging.Level;
import oracle.jdbc.ErrorSet;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.KeywordValueI;
import oracle.jdbc.driver.NTFDCNRegistration;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Pipeline;
import oracle.jdbc.driver.PlsqlIbtBindInfo;
import oracle.jdbc.driver.T4C8TTIrxh;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIdcb;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4CTTIimplres;
import oracle.jdbc.driver.T4CTTIiov;
import oracle.jdbc.driver.T4CTTIoac;
import oracle.jdbc.driver.T4CTTIoer;
import oracle.jdbc.driver.T4CTTIoer11;
import oracle.jdbc.driver.T4CTTIrxd;
import oracle.jdbc.driver.TypeAccessor;
import oracle.jdbc.driver.utils.ThrowingRunnable;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.KeywordValue;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.oracore.OracleTypeADT;

final class T4C8Oall
extends T4CTTIfun {
    private static final String CLASS_NAME = T4C8Oall.class.getName();
    Vector<IOException> nonFatalIOExceptions = null;
    static final byte[] EMPTY_BYTES = new byte[0];
    static final int UOPF_PRS = 1;
    static final int UOPF_BND = 8;
    static final int UOPF_EXE = 32;
    static final int UOPF_FEX = 512;
    static final int UOPF_FCH = 64;
    static final int UOPF_CAN = 128;
    static final int UOPF_COM = 256;
    static final int UOPF_DSY = 131072;
    static final int UOPF_SIO = 1024;
    static final int UOPF_NPL = 32768;
    static final int UOPF_DFN = 16;
    static final int UOPF_NCF = 262144;
    static final int UOPF_BER = 524288;
    static final int EXE_COMMIT_ON_SUCCESS = 1;
    static final int EXE_LEAVE_CUR_MAPPED = 2;
    static final int EXE_BATCH_DML_ERRORS = 4;
    static final int EXE_SCROL_READ_ONLY = 8;
    static final int EXE_DISABLE_ROWSHIP = 16;
    static final int EXE_RESULT_CACHE = 32;
    static final int EXE_NO_RESULT_CACHE = 64;
    static final int EXE_ACET = 128;
    static final int EXE_FROM_OPIOSQ = 256;
    static final int EXE_REQ_SESSSTATE_STABLE = 512;
    static final int EXE_NODESC_METADATA = 1024;
    static final int KPUCXEXE = 32;
    static final int KPUCXFCH = 64;
    static final int KPUCXCAN = 128;
    static final int KPUCXCOM = 256;
    static final int KPUCXFEX = 512;
    static final int KPUCXNCF = 262144;
    static final int AL8EX_GET_PIDMLRC = 16384;
    static final int AL8EX_RSET_REPOSITION = 262144;
    static final int AL8EX_REQ_SESSSTATE_STABLE = 524288;
    static final int AL8KW_MAXLANG = 63;
    static final int AL8KW_TIMEZONE = 163;
    static final int AL8KW_ERR_OVLAP = 164;
    static final int AL8KW_SESSION_ID = 165;
    static final int AL8KW_SERIAL_NUM = 166;
    static final int AL8KW_TAG_FOUND = 167;
    static final int AL8KW_SCHEMA_NAME = 168;
    static final int AL8KW_SCHEMA_ID = 169;
    static final int AL8KW_ENABLED_ROLES = 170;
    static final int AL8KW_AUX_SESSSTATE = 171;
    static final int AL8KW_EDITION = 172;
    static final int AL8KW_SQL_TXLP = 173;
    static final int AL8KW_FSQL_SNTX = 174;
    static final String AL8KW_ERR_OVLAP_STR = "AL8KW_ERR_OVLAP";
    static final String AL8KW_SCHEMA_NAME_STR = "AL8KW_SCHEMA_NAME";
    static final String AL8KW_ENABLED_ROLES_STR = "AL8KW_ENABLED_ROLES";
    static final String AL8KW_EDITION_STR = "AL8KW_EDITION";
    static final String AL8KW_AUX_SESSSTATE_STR = "AL8KW_AUX_SESSSTATE";
    static final String AL8KW_SQL_TXLP_STR = "AL8KW_SQL_TXLP";
    static final String AL8KW_FSQL_SNTX_STR = "AL8KW_FSQL_SNTX";
    static final int AL8KW_OPENCURSORS = 175;
    static final String AL8KW_OPENCURSORS_STR = "AL8KW_OPENCURSORS";
    static final int AL8KW_PDBUID = 176;
    static final int AL8KW_DBID = 177;
    static final int AL8KW_GUDBID = 178;
    static final int AL8KW_DBNAME = 179;
    static final int AL8KW_SERVICE_NAME = 183;
    static final int AL8KW_CLIENT_INFO = 186;
    static final String AL8KW_CLIENT_INFO_STR = "AL8KW_CLIENT_INFO";
    static final int AL8KW_ROW_ARCHIVAL = 187;
    static final String AL8KW_ROW_ARCHIVAL_STR = "AL8KW_ROW_ARCHIVAL";
    static final int AL8KW_CONTAINER_NAME = 197;
    static final String AL8KW_CONTAINER_NAME_STR = "CONTAINER_NAME";
    static final int AL8KW_CLIENT_ID = 198;
    static final String AL8KW_CLIENT_ID_STR = "AL8KW_CLIENT_ID";
    static final int AL8KW_ENABLED_ROLE_NAMES = 199;
    static final String AL8KW_ENABLED_ROLE_NAMES_STR = "AL8KW_ENABLED_ROLE_NAMES";
    static final int AL8KW_PREFETCH_ROWS = 200;
    static final String AL8KW_PREFETCH_ROWS_STR = "AL8KW_PREFETCH_ROWS";
    static final String[] NLS_KEYS = new String[]{"AUTH_NLS_LXCCURRENCY", "AUTH_NLS_LXCISOCURR", "AUTH_NLS_LXCNUMERICS", null, null, null, null, "AUTH_NLS_LXCDATEFM", "AUTH_NLS_LXCDATELANG", "AUTH_NLS_LXCTERRITORY", "SESSION_NLS_LXCCHARSET", "AUTH_NLS_LXCSORT", "AUTH_NLS_LXCCALENDAR", null, null, null, "AUTH_NLS_LXLAN", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "AUTH_NLS_LXNLSCOMP", null, "AUTH_NLS_LXCUNIONCUR", null, null, null, null, "AUTH_NLS_LXCTIMEFM", "AUTH_NLS_LXCSTMPFM", "AUTH_NLS_LXCTTZNFM", "AUTH_NLS_LXCSTZNFM", "SESSION_NLS_LXCNLSLENSEM", "SESSION_NLS_LXCNCHAREXCP", "SESSION_NLS_LXCNCHARIMP"};
    static final int LDIREGIDFLAG = 120;
    static final int LDIREGIDSET = 181;
    static final int LDIMAXTIMEFIELD = 60;
    static final int AL8EX_IMPL_RESULTS_CLIENT = 32768;
    long rowsProcessed;
    int numberOfDefinePositions;
    long options;
    int cursor;
    byte[] sqlStmt = new byte[0];
    final long[] al8i4 = new long[13];
    boolean plsql = false;
    Accessor[] definesAccessors;
    int definesLength;
    Accessor[] outBindAccessors;
    int numberOfBindPositions;
    InputStream[][] parameterStream;
    short[] bindIndicators;
    byte[] bindBytes;
    char[] bindChars;
    ByteArray bindData;
    boolean bindUseDBA = false;
    long[] bindDataOffsets = null;
    int[] bindDataLengths = null;
    int bindDataIndex;
    int bindIndicatorSubRange;
    byte[] tmpBindsByteArray;
    DBConversion conversion;
    byte[] ibtBindBytes;
    char[] ibtBindChars;
    short[] ibtBindIndicators;
    boolean sendBindsDefinition = false;
    OracleStatement oracleStatement;
    short dbCharSet;
    short NCharSet;
    T4CTTIrxd rxd;
    T4C8TTIrxh rxh;
    T4CTTIdcb dcb;
    T4CTTIimplres implres;
    OracleStatement.SqlKind typeOfStatement;
    int defCols = 0;
    int rowsToFetch;
    boolean aFetchWasDone = false;
    T4CTTIoac[] oacdefBindsSent;
    T4CTTIoac[] oacdefDefines;
    int[] definedColumnSize;
    int[] definedColumnType;
    int[] definedColumnFormOfUse;
    NTFDCNRegistration registration = null;
    static final int AL8TXCUR = 1;
    static final int AL8TXDON = 2;
    static final int AL8TXRON = 4;

    T4C8Oall(T4CConnection _connection) {
        super(_connection, (byte)3);
        this.setFunCode((short)94);
        this.rxh = new T4C8TTIrxh(_connection);
        this.rxd = new T4CTTIrxd(_connection);
        this.dcb = new T4CTTIdcb(_connection);
        this.implres = new T4CTTIimplres(_connection);
    }

    void doOALL(boolean doParse, boolean doExecute, boolean doFetch, boolean doDescribe, boolean doDefine) throws SQLException, IOException {
        this.prepareForCall(doParse, doExecute, doFetch, doDescribe, doDefine);
        this.doRPC();
        this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "doOALL", "OALL8 options={0}, cursor={1}. ", (String)null, null, (Object)this.options, (Object)this.cursor);
        this.clearStateAfterCall();
        if (this.nonFatalIOExceptions != null) {
            throw this.handleNonFatalIOExceptionsAfterCall();
        }
    }

    void doOALLAsync(boolean doParse, boolean doExecute, boolean doFetch, boolean doDescribe, boolean doDefine, ErrorSet continueOnErrorSet, ThrowingRunnable<Exception> startCallback, Consumer<Throwable> callback) {
        this.doRPCAsync(continueOnErrorSet, () -> {
            startCallback.runOrThrow();
            this.prepareForCall(doParse, doExecute, doFetch, doDescribe, doDefine);
        }, error -> {
            try {
                if (error == null) {
                    this.clearStateAfterCall();
                    if (this.nonFatalIOExceptions != null) {
                        error = this.handleNonFatalIOExceptionsAfterCall();
                    }
                }
            }
            catch (Throwable throwable) {
                error = CompletionStageUtil.suppress(throwable, error);
            }
            callback.accept((Throwable)error);
        });
    }

    private void prepareForCall(boolean doParse, boolean doExecute, boolean doFetch, boolean doDescribe, boolean doDefine) throws SQLException, IOException {
        this.initializeCharacterSetsBeforeCall();
        int number_of_bound_rows = this.getNumberOfBoundRowsBeforeCall();
        this.initializeSQLBeforeCall(doParse);
        this.requireValidBatchCommamnd(number_of_bound_rows);
        this.resetStateBeforeCall();
        if (doDefine && this.typeOfStatement.isSELECT()) {
            this.initDefinesDefinition();
        }
        this.initializeBindOACsBeforeCall();
        if (doParse) {
            this.sendBindsDefinition = true;
        }
        boolean isBatchExecution = number_of_bound_rows > 1;
        this.options = this.setOptions(doParse, doExecute, doFetch, doDefine, isBatchExecution);
        this.initializeI4OptionsBeforeCall(doDescribe, doFetch, number_of_bound_rows);
        this.initializeFunctionCodeBeforeCall();
        this.setExecutingSQLBeforeCall();
    }

    private final void initializeCharacterSetsBeforeCall() {
        this.dbCharSet = this.conversion.getServerCharSetId();
        this.NCharSet = this.conversion.getNCharSetId();
    }

    private final int getNumberOfBoundRowsBeforeCall() {
        int number_of_bound_rows = 0;
        if (this.bindIndicators != null) {
            number_of_bound_rows = ((this.bindIndicators[this.bindIndicatorSubRange + 3] & 0xFFFF) << 16) + (this.bindIndicators[this.bindIndicatorSubRange + 4] & 0xFFFF);
        }
        return number_of_bound_rows;
    }

    private void initializeSQLBeforeCall(boolean doParse) throws SQLException {
        if (!doParse) {
            this.sqlStmt = EMPTY_BYTES;
        }
        if (this.sqlStmt == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 431).fillInStackTrace();
        }
    }

    private void requireValidBatchCommamnd(int numberOfBoundRows) throws SQLException {
        if (!this.typeOfStatement.isDML() && numberOfBoundRows > 1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 80).fillInStackTrace();
        }
    }

    private void resetStateBeforeCall() {
        this.rowsProcessed = 0L;
        this.options = 0L;
        this.plsql = this.typeOfStatement.isPlsqlOrCall();
        this.sendBindsDefinition = false;
        this.aFetchWasDone = false;
        this.nonFatalIOExceptions = null;
        if (this.receiveState != 0) {
            this.receiveState = 0;
        }
        this.rxh.init();
        this.rxd.init();
        this.rxd.setNumberOfColumns(this.definesLength);
        this.connection.getT4CTTIoer().init();
    }

    private void initializeBindOACsBeforeCall() throws SQLException, IOException {
        if (this.numberOfBindPositions > 0 && this.bindIndicators != null) {
            if (this.oacdefBindsSent == null) {
                this.oacdefBindsSent = new T4CTTIoac[this.numberOfBindPositions];
            }
            this.sendBindsDefinition = this.initBindsDefinition(this.oacdefBindsSent);
        } else if (this.numberOfBindPositions == 0 && this.oacdefBindsSent != null) {
            this.oacdefBindsSent = null;
        }
    }

    private void initializeI4OptionsBeforeCall(boolean doDescribe, boolean doFetch, int numberOfBoundRows) {
        this.al8i4[0] = (this.options & 1L) > 0L ? 1L : 0L;
        this.al8i4[1] = this.plsql || this.typeOfStatement.isOTHER() ? 1L : (doDescribe ? (doFetch && this.oracleStatement.isFetchStreams ? (long)this.rowsToFetch : 0L) : (this.typeOfStatement.isDML() ? (numberOfBoundRows == 0 ? 1L : (long)numberOfBoundRows) : (doFetch && !doDescribe ? (long)this.rowsToFetch : 0L)));
        this.al8i4[7] = this.typeOfStatement.isSELECT() ? 1L : 0L;
        long scn = this.oracleStatement.inScn;
        int leastSignificantHalfScn = (int)scn;
        int mostSignificantHalfScn = (int)(scn >> 32);
        this.al8i4[5] = leastSignificantHalfScn;
        this.al8i4[6] = mostSignificantHalfScn;
        if (this.typeOfStatement.isDML()) {
            this.al8i4[9] = this.al8i4[9] | 0x4000L;
            this.al8i4[9] = this.al8i4[9] & 0xFFFFFFFFFFFBFFFFL;
            this.al8i4[11] = 0L;
        } else {
            this.al8i4[9] = this.al8i4[9] & 0xFFFFFFFFFFFFBFFFL;
            if (this.typeOfStatement.isSELECT() && this.oracleStatement.isSSSCursor && this.connection.replayModes.contains((Object)T4CConnection.ReplayMode.REPLAYING)) {
                this.al8i4[9] = this.al8i4[9] | 0x40000L;
                this.al8i4[11] = this.oracleStatement.sssCursorPosition;
            } else {
                this.al8i4[9] = this.al8i4[9] & 0xFFFFFFFFFFFBFFFFL;
                this.al8i4[11] = 0L;
            }
        }
        try {
            if (this.connection.isSSSHybrid()) {
                this.al8i4[9] = this.al8i4[9] | 0x80000L;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.al8i4[9] = (this.options & 0x20L) != 0L ? this.al8i4[9] | 0x8000L : this.al8i4[9] & 0xFFFFFFFFFFFF7FFFL;
    }

    private void initializeFunctionCodeBeforeCall() {
        if ((this.options & 0x40L) != 0L && (this.options & 0x20L) == 0L && (this.options & 1L) == 0L && (this.options & 8L) == 0L && (this.options & 0x10L) == 0L && !this.oracleStatement.needToSendOalToFetch) {
            this.setFunCode((short)5);
        } else if (this.oracleStatement.inScn == 0L && (this.options & 0x20L) != 0L && (this.options & 1L) == 0L && (this.options & 0x10L) == 0L && (this.options & 8L) == 0L && (this.options & 0x8000L) != 0L && (this.options & 0x40L) != 0L) {
            this.setFunCode((short)78);
        } else {
            this.setFunCode((short)94);
        }
    }

    private void setExecutingSQLBeforeCall() {
        if (this.getFunCode() == 94 || this.getFunCode() == 78) {
            ((T4CConnection)this.oracleStatement.connection).setExecutingRPCSQL(this.oracleStatement.sqlObject.actualSql);
        }
    }

    private void clearStateAfterCall() {
        if ((this.options & 0x20L) != 0L) {
            this.oracleStatement.inScn = 0L;
        }
        this.ibtBindIndicators = null;
        this.ibtBindChars = null;
        this.ibtBindBytes = null;
        this.tmpBindsByteArray = null;
        this.outBindAccessors = null;
        this.bindBytes = null;
        this.bindChars = null;
        this.bindIndicators = null;
        this.oracleStatement = null;
        this.parameterStream = null;
    }

    private SQLException handleNonFatalIOExceptionsAfterCall() {
        IOException firstIOex = this.nonFatalIOExceptions.get(0);
        SQLException sqlex = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 266).fillInStackTrace();
        sqlex.initCause(firstIOex);
        return sqlex;
    }

    @Override
    void readBVC() throws IOException, SQLException {
        int nbOfColumnSent = this.meg.unmarshalUB2();
        this.rxd.unmarshalBVC(nbOfColumnSent);
    }

    @Override
    void readIOV() throws IOException, SQLException {
        T4CTTIiov iov = new T4CTTIiov(this.connection, this.rxh, this.rxd);
        iov.init();
        iov.unmarshalV10(this.numberOfBindPositions);
        if (!this.oracleStatement.isDmlReturning && !iov.isIOVectorEmpty()) {
            byte[] ioVector = iov.getIOVector();
            this.outBindAccessors = iov.processRXD(this.outBindAccessors, this.numberOfBindPositions, this.bindBytes, this.bindChars, this.bindIndicators, this.bindIndicatorSubRange, this.conversion, this.tmpBindsByteArray, ioVector, this.parameterStream, this.oracleStatement, null, null, null);
        }
    }

    @Override
    void readRXH() throws IOException, SQLException {
        this.rxh.init();
        this.rxh.unmarshalV10(this.rxd);
        if (this.rxh.uacBufLength > 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 405).fillInStackTrace();
        }
        if ((this.rxh.rxhflg & 8) == 8) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 449).fillInStackTrace();
        }
        if ((this.rxh.rxhflg & 0x10) == 16) {
            for (int i = 0; i < this.definesAccessors.length; ++i) {
                if (this.definesAccessors[i].udskpos < 0 || this.definesAccessors[i].udskpos == i) continue;
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 450).fillInStackTrace();
            }
        }
    }

    @Override
    void processSLG() throws IOException, SQLException {
        this.readRXH();
        int[] oacmxlArr = new int[this.numberOfBindPositions];
        for (int i = 0; i < this.numberOfBindPositions; ++i) {
            oacmxlArr[i] = this.oacdefBindsSent[i].oacmxl;
        }
        this.nonFatalIOExceptions = this.marshalBinds(oacmxlArr, true);
    }

    @Override
    void processOCSHRDKEY(byte[] buf) throws SQLException {
        this.oracleStatement.setShardingKeyRpnTokens(buf);
    }

    @Override
    boolean readRXD() throws IOException, SQLException {
        this.aFetchWasDone = true;
        if (this.oracleStatement.isDmlReturning && this.numberOfBindPositions > 0) {
            int col = 0;
            int row = 0;
            try {
                for (col = 0; col < this.oracleStatement.numberOfBindPositions; ++col) {
                    Accessor acc = this.oracleStatement.accessors[col];
                    if (acc == null) continue;
                    int nbOfRowsSent = (int)this.meg.unmarshalUB4();
                    this.oracleStatement.increaseCapacity(nbOfRowsSent);
                    this.oracleStatement.rowsDmlReturned += nbOfRowsSent;
                    for (row = 0; row < nbOfRowsSent; ++row) {
                        acc.unmarshalOneRow();
                        ++this.oracleStatement.storedRowCount;
                    }
                }
            }
            catch (IOException | SQLException exception) {
                // empty catch block
            }
            this.oracleStatement.returnParamsFetched = true;
        } else if (this.iovProcessed || this.outBindAccessors != null && this.definesAccessors == null ? this.rxd.unmarshal(this.outBindAccessors, this.numberOfBindPositions) : this.rxd.unmarshal(this.definesAccessors, this.definesLength)) {
            return true;
        }
        return false;
    }

    @Override
    void readRPA() throws IOException, SQLException {
        int KSCNFVB = 32768;
        int al8o4l = this.meg.unmarshalUB2();
        int[] al8o4 = new int[al8o4l];
        for (int i = 0; i < al8o4l; ++i) {
            al8o4[i] = (int)this.meg.unmarshalUB4();
        }
        int leastSignificantHalfScn = al8o4[0];
        int mostSignificantHalfScn = al8o4[1] & ~KSCNFVB;
        long scn = (long)leastSignificantHalfScn & 0xFFFFFFFFL | ((long)mostSignificantHalfScn & 0xFFFFFFFFL) << 32;
        if (scn != 0L) {
            this.oracleStatement.connection.outScn = scn;
        }
        this.cursor = al8o4[2];
        int al8txl = this.meg.unmarshalUB2();
        byte[] al8txn = null;
        if (al8txl > 0) {
            al8txn = this.meg.unmarshalNBytes(al8txl);
        }
        int al8kvl = this.meg.unmarshalUB2();
        KeywordValue[] al8kv = new KeywordValue[al8kvl];
        for (int i = 0; i < al8kvl; ++i) {
            al8kv[i] = KeywordValueI.unmarshal(this.meg);
        }
        this.connection.updateSessionProperties(al8kv);
        this.oracleStatement.dcnQueryId = -1L;
        this.oracleStatement.dcnTableName = null;
        if (this.connection.getTTCVersion() >= 4) {
            int registrationFeedbackLength = (int)this.meg.unmarshalUB4();
            byte[] registrationFeedback = this.meg.unmarshalNBytes(registrationFeedbackLength);
            if (registrationFeedbackLength > 0 && this.registration != null) {
                String qcOption;
                boolean isQC = false;
                Properties regOptions = this.registration.getRegistrationOptions();
                if (regOptions != null && (qcOption = regOptions.getProperty("DCN_QUERY_CHANGE_NOTIFICATION")) != null && qcOption.compareToIgnoreCase("true") == 0) {
                    isQC = true;
                }
                int tablesDescriptionLength = registrationFeedbackLength;
                if (isQC) {
                    tablesDescriptionLength = registrationFeedbackLength - 8;
                }
                String tablesAll = new String(registrationFeedback, 0, tablesDescriptionLength, StandardCharsets.US_ASCII);
                char[] delimitor = new char[]{'\u0000'};
                String[] tables = tablesAll.split(new String(delimitor));
                this.registration.addTablesName(tables, tables.length);
                this.oracleStatement.dcnTableName = tables;
                if (isQC) {
                    long queryId;
                    int queryId2 = registrationFeedback[registrationFeedbackLength - 1] & 0xFF | (registrationFeedback[registrationFeedbackLength - 2] & 0xFF) << 8 | (registrationFeedback[registrationFeedbackLength - 3] & 0xFF) << 16 | (registrationFeedback[registrationFeedbackLength - 4] & 0xFF) << 24;
                    int queryId1 = registrationFeedback[registrationFeedbackLength - 5] & 0xFF | (registrationFeedback[registrationFeedbackLength - 6] & 0xFF) << 8 | (registrationFeedback[registrationFeedbackLength - 7] & 0xFF) << 16 | (registrationFeedback[registrationFeedbackLength - 8] & 0xFF) << 24;
                    this.oracleStatement.dcnQueryId = queryId = (long)queryId1 & 0xFFFFFFFFL | ((long)queryId2 & 0xFFFFFFFFL) << 32;
                }
            }
        }
        if (this.connection.getTTCVersion() >= 7 && this.typeOfStatement.isDML()) {
            int al8pidmlrcl = (int)this.meg.unmarshalUB4();
            long[] al8pidmlrc = new long[al8pidmlrcl];
            for (int i = 0; i < al8pidmlrcl; ++i) {
                al8pidmlrc[i] = this.meg.unmarshalSB8();
            }
            this.oracleStatement.batchRowsUpdatedArray = al8pidmlrc;
        }
    }

    @Override
    void readDCB() throws IOException, SQLException {
        this.dcb.init(this.oracleStatement, 0);
        this.definesAccessors = this.dcb.receive(this.definesAccessors);
        this.definesLength = this.numberOfDefinePositions = this.dcb.numuds;
        this.rxd.setNumberOfColumns(this.numberOfDefinePositions);
    }

    @Override
    void readRSH() throws IOException, SQLException {
        long queryId = this.meg.unmarshalSB8();
        this.connection.kpdqidcscn.unmarshal();
        long executionSCN = this.connection.kpdqidcscn.getSCN();
        this.oracleStatement.setQueryId(queryId);
    }

    @Override
    void readIMPLRES() throws IOException, SQLException {
        int rsCount;
        this.implres.init(this.oracleStatement);
        this.oracleStatement.implicitResultSetStatements = new ArrayDeque(rsCount);
        for (rsCount = (int)this.meg.unmarshalUB4(); rsCount != 0; --rsCount) {
            this.implres.readImplicitResultSet();
        }
        this.oracleStatement.implicitResultSetIterator = this.oracleStatement.implicitResultSetStatements.iterator();
    }

    private boolean isORA1403Ignored() {
        return this.typeOfStatement.isSELECT();
    }

    @Override
    void unmarshalError() throws IOException, SQLException {
        if (this.isORA1403Ignored()) {
            this.connection.getT4CTTIoer().unmarshal(true);
        } else {
            super.unmarshalError();
        }
    }

    @Override
    void processError() throws SQLException {
        T4CTTIoer11 oer = this.connection.getT4CTTIoer();
        this.cursor = oer.currCursorID;
        this.rowsProcessed = oer.getCurRowNumber();
        this.oracleStatement.isAllFetched = this.oracleStatement.isAllFetched | oer.retCode == 1403L;
        if (this.typeOfStatement.isSELECT() && oer.retCode == 1403L) {
            this.aFetchWasDone = true;
        }
        if (oer.retCode != 1403L || oer.retCode == 1403L && !this.isORA1403Ignored()) {
            if (this.oracleStatement.connection.checksumMode.needToCalculateFetchChecksum() && oer.retCode != 0L) {
                long localCheckSum;
                this.oracleStatement.checkSum = localCheckSum = oer.updateChecksum(this.oracleStatement.checkSum);
            }
            oer.processError(this.oracleStatement);
            if (this.oracleStatement.connection.enableSSSCursor) {
                this.oracleStatement.sssCursorChecksum = ((T4CTTIoer)oer).oerchksm;
            }
        }
    }

    int getCursorId() {
        return this.cursor;
    }

    void continueReadRow(int start, OracleStatement s) throws SQLException, IOException {
        try {
            this.oracleStatement = s;
            this.receiveState = 2;
            if (this.rxd.unmarshal(this.definesAccessors, start, this.definesLength)) {
                this.receiveState = 3;
                return;
            }
            this.resumeReceive();
        }
        finally {
            this.oracleStatement = null;
        }
    }

    long getNumRows() {
        long rows = 0L;
        if (this.typeOfStatement == null) {
            return rows;
        }
        if (this.receiveState == 3) {
            rows = -2L;
        } else {
            switch (this.typeOfStatement) {
                case DELETE: 
                case INSERT: 
                case MERGE: 
                case UPDATE: 
                case ALTER_SESSION: 
                case OTHER: 
                case PLSQL_BLOCK: 
                case CALL_BLOCK: {
                    rows = this.rowsProcessed;
                    break;
                }
                case SELECT_FOR_UPDATE: 
                case SELECT: {
                    assert (this.definesAccessors == null || this.definesAccessors[0] != null) : "definesAccessors is not null but definesAccessors[0] is null";
                    rows = this.definesAccessors != null && this.definesLength > 0 && this.definesAccessors[0] != null ? (long)this.definesAccessors[0].lastRowProcessed : 0L;
                }
            }
        }
        return rows;
    }

    @Override
    void marshal() throws IOException {
        if (this.getFunCode() == 5) {
            this.meg.marshalSWORD(this.cursor);
            this.meg.marshalSWORD((int)this.al8i4[1]);
        } else if (this.getFunCode() == 78) {
            this.meg.marshalSWORD(this.cursor);
            this.meg.marshalSWORD((int)this.al8i4[1]);
            int exerof = 96;
            this.meg.marshalSWORD(exerof);
            int exeflg = 0;
            if ((this.options & 0x100L) == 256L) {
                exeflg |= 1;
            }
            try {
                if (this.connection.isSSSHybrid()) {
                    exeflg |= 0x200;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.meg.marshalSWORD(exeflg);
            int[] oacmxlArr = new int[this.numberOfBindPositions];
            for (int i = 0; i < this.numberOfBindPositions; ++i) {
                oacmxlArr[i] = this.oacdefBindsSent[i].oacmxl;
            }
            if (this.numberOfBindPositions > 0 && this.bindIndicators != null) {
                this.marshalBinds(oacmxlArr, false);
            }
        } else {
            int i;
            if (this.oracleStatement.needToSendOalToFetch) {
                this.oracleStatement.needToSendOalToFetch = false;
            }
            this.marshalPisdef();
            this.meg.marshalCHR(this.sqlStmt);
            this.meg.marshalUB4Array(this.al8i4);
            int[] oacmxlArr = new int[this.numberOfBindPositions];
            for (i = 0; i < this.numberOfBindPositions; ++i) {
                oacmxlArr[i] = this.oacdefBindsSent[i].oacmxl;
            }
            if ((this.options & 8L) != 0L && this.numberOfBindPositions > 0 && this.bindIndicators != null && this.sendBindsDefinition) {
                this.marshalBindsTypes(this.oacdefBindsSent);
            }
            if (this.connection.getTTCVersion() >= 2 && (this.options & 0x10L) != 0L) {
                for (i = 0; i < this.defCols; ++i) {
                    this.oacdefDefines[i].marshal();
                }
            }
            if ((this.options & 0x20L) != 0L && this.numberOfBindPositions > 0 && this.bindIndicators != null) {
                this.nonFatalIOExceptions = this.marshalBinds(oacmxlArr, false);
            }
        }
        this.debugp(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshal", "cursor={0}, sendBindsDefinition={1}, bind positions={2}, al8i4={3}. ", null, null, () -> new Object[]{this.cursor, this.sendBindsDefinition, this.numberOfBindPositions, Arrays.toString(this.al8i4)});
    }

    void marshalPisdef() throws IOException {
        this.meg.marshalUB4(this.options);
        this.meg.marshalSWORD(this.cursor);
        if (this.sqlStmt.length == 0) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        this.meg.marshalSWORD(this.sqlStmt.length);
        if (this.al8i4.length == 0) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        this.meg.marshalSWORD(this.al8i4.length);
        this.meg.marshalNULLPTR();
        this.meg.marshalNULLPTR();
        if ((this.options & 0x40L) == 0L && (this.options & 0x20L) != 0L && (this.options & 1L) != 0L && this.typeOfStatement.isSELECT()) {
            this.meg.marshalUB4(Long.MAX_VALUE);
            this.meg.marshalUB4(this.rowsToFetch);
        } else {
            this.meg.marshalUB4(0L);
            this.meg.marshalUB4(0L);
        }
        if (!this.typeOfStatement.isPlsqlOrCall()) {
            this.meg.marshalUB4(Integer.MAX_VALUE);
        } else {
            this.meg.marshalUB4(32760L);
        }
        if ((this.options & 8L) != 0L && this.numberOfBindPositions > 0 && this.sendBindsDefinition) {
            this.meg.marshalPTR();
            this.meg.marshalSWORD(this.numberOfBindPositions);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        this.meg.marshalNULLPTR();
        this.meg.marshalNULLPTR();
        this.meg.marshalNULLPTR();
        this.meg.marshalNULLPTR();
        this.meg.marshalNULLPTR();
        if (this.connection.getTTCVersion() >= 2) {
            if (this.defCols > 0 && (this.options & 0x10L) != 0L) {
                this.meg.marshalPTR();
                this.meg.marshalSWORD(this.defCols);
            } else {
                this.meg.marshalNULLPTR();
                this.meg.marshalSWORD(0);
            }
        }
        if (this.connection.getTTCVersion() >= 4) {
            int regid_lb = 0;
            int regid_mb = 0;
            if (this.registration != null) {
                long regid = this.registration.getRegId();
                regid_lb = (int)(regid & 0xFFFFFFFFFFFFFFFFL);
                regid_mb = (int)((regid & 0xFFFFFFFF00000000L) >> 32);
            }
            this.meg.marshalUB4(regid_lb);
            this.meg.marshalNULLPTR();
            this.meg.marshalPTR();
            if (this.connection.getTTCVersion() >= 5) {
                this.meg.marshalNULLPTR();
                this.meg.marshalUB4(0L);
                this.meg.marshalNULLPTR();
                this.meg.marshalUB4(0L);
                this.meg.marshalUB4(regid_mb);
                if (this.connection.getTTCVersion() >= 7) {
                    if (this.typeOfStatement.isDML()) {
                        this.meg.marshalPTR();
                        this.meg.marshalUB4(this.oracleStatement.currentRank);
                        this.meg.marshalPTR();
                    } else {
                        this.meg.marshalNULLPTR();
                        this.meg.marshalUB4(0L);
                        this.meg.marshalNULLPTR();
                    }
                    if (this.connection.getTTCVersion() >= 8) {
                        this.meg.marshalNULLPTR();
                        this.meg.marshalUB4(0L);
                        this.meg.marshalNULLPTR();
                        this.meg.marshalUB4(0L);
                        this.meg.marshalNULLPTR();
                        if (this.connection.getTTCVersion() >= 9) {
                            this.meg.marshalNULLPTR();
                            this.meg.marshalUB4(0L);
                        }
                    }
                }
            }
        }
    }

    boolean initBindsDefinition(T4CTTIoac[] oacdefArr) throws SQLException, IOException {
        boolean needToUpdateDefinition = false;
        short[] l_bindIndicators = this.bindIndicators;
        int _oacmxl = 0;
        int nbOfIbt = 0;
        for (int P = 0; P < this.numberOfBindPositions; ++P) {
            int subRangeOffset = this.bindIndicatorSubRange + 5 + 10 * P;
            short formOfUse = l_bindIndicators[subRangeOffset + 9];
            int _oactype = l_bindIndicators[subRangeOffset + 0] & 0xFFFF;
            T4CTTIoac oac = oacdefArr[P];
            boolean isReusableType = false;
            if (oac == null) {
                oacdefArr[P] = oac = new T4CTTIoac(this.connection);
            } else if (oac.getRequestedType() == _oactype) {
                isReusableType = true;
            }
            switch (_oactype) {
                case 8: 
                case 24: {
                    _oacmxl = this.plsql ? 32760 : Integer.MAX_VALUE;
                    if (isReusableType && oacdefArr[P].oacmxl == _oacmxl && oacdefArr[P].oaccsfrm == formOfUse) break;
                    needToUpdateDefinition = true;
                    oac.init((short)_oactype, _oacmxl);
                    oac.setFormOfUse(formOfUse);
                    oac.setCharset(formOfUse == 2 ? this.NCharSet : this.dbCharSet);
                    break;
                }
                case 998: {
                    int oacmal;
                    short sqlType;
                    if (this.outBindAccessors != null && this.outBindAccessors[P] != null) {
                        PlsqlIbtBindInfo ibtInfo = this.outBindAccessors[P].plsqlIndexTableBindInfo();
                        sqlType = (short)ibtInfo.element_internal_type;
                        _oacmxl = ibtInfo.elemMaxLen;
                        oacmal = ibtInfo.maxLen;
                    } else if (this.ibtBindIndicators[6 + nbOfIbt * 8] != 0) {
                        sqlType = this.ibtBindIndicators[6 + nbOfIbt * 8];
                        oacmal = (this.ibtBindIndicators[6 + nbOfIbt * 8 + 2] & 0xFFFF) << 16 | this.ibtBindIndicators[6 + nbOfIbt * 8 + 3] & 0xFFFF;
                        _oacmxl = this.ibtBindIndicators[6 + nbOfIbt * 8 + 1] * this.conversion.sMaxCharSize;
                    } else {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89, "Binding PLSQL index-by table but no type defined").fillInStackTrace();
                    }
                    ++nbOfIbt;
                    if (oacdefArr[P].requestedtype == sqlType && oacdefArr[P].oacmxl == _oacmxl && oacdefArr[P].oacmal >= oacmal) break;
                    needToUpdateDefinition = true;
                    oac.init(sqlType, _oacmxl);
                    oac.setMal(oacmal);
                    oac.addFlg((short)64);
                    break;
                }
                case 109: 
                case 111: {
                    OracleTypeADT adt = null;
                    if (this.outBindAccessors != null && this.outBindAccessors[P] != null) {
                        if (this.outBindAccessors[P].internalOtype != null) {
                            _oacmxl = _oactype == 109 ? 11 : 4000;
                            adt = (OracleTypeADT)((TypeAccessor)this.outBindAccessors[P]).internalOtype;
                        }
                    } else if (this.oracleStatement instanceof OraclePreparedStatement && ((OraclePreparedStatement)this.oracleStatement).binders != null && ((OraclePreparedStatement)this.oracleStatement).binders[this.oracleStatement.firstRowInBatch] != null) {
                        _oacmxl = _oactype == 109 ? 11 : 4000;
                        Binder binder = ((OraclePreparedStatement)this.oracleStatement).binders[this.oracleStatement.firstRowInBatch][P];
                        if (binder == null && ((OraclePreparedStatement)this.oracleStatement).lastBinders != null) {
                            binder = ((OraclePreparedStatement)this.oracleStatement).lastBinders[P];
                        }
                        adt = ((OraclePreparedStatement)this.oracleStatement).getOtype(binder);
                    } else {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89, "Binding NAMED_TYPE but no type defined").fillInStackTrace();
                    }
                    if (isReusableType && adt != null && Arrays.equals(oacdefArr[P].oactoid, adt.getTOID()) && oacdefArr[P].oacmxl == _oacmxl) break;
                    needToUpdateDefinition = true;
                    oac.init((short)_oactype, _oacmxl);
                    oac.setADT(adt);
                    break;
                }
                case 994: {
                    int[] returnParamMetaLocal = this.oracleStatement.returnParamMeta;
                    _oactype = returnParamMetaLocal[3 + P * 4 + 0];
                    _oacmxl = returnParamMetaLocal[3 + P * 4 + 2];
                    formOfUse = (short)returnParamMetaLocal[3 + P * 4 + 3];
                    if (_oactype == 109 || _oactype == 111) {
                        TypeAccessor typeAccessor = (TypeAccessor)this.oracleStatement.accessors[P];
                        _oacmxl = _oactype == 109 ? 11 : 4000;
                        OracleTypeADT adt = (OracleTypeADT)typeAccessor.internalOtype;
                        if (isReusableType && Arrays.equals(oacdefArr[P].oactoid, adt.getTOID()) && oacdefArr[P].oacmxl == _oacmxl) break;
                        needToUpdateDefinition = true;
                        oac.init((short)_oactype, _oacmxl);
                        oac.setADT(adt);
                        break;
                    }
                    if (isReusableType && oacdefArr[P].oacmxl == _oacmxl && oacdefArr[P].oaccsfrm == formOfUse) break;
                    needToUpdateDefinition = true;
                    oac.init((short)_oactype, _oacmxl);
                    oac.setFormOfUse(formOfUse);
                    oac.setCharset(formOfUse == 2 ? this.NCharSet : this.dbCharSet);
                    break;
                }
                case 180: {
                    int number_of_bound_rows;
                    _oacmxl = this.bindUseDBA ? 11 : l_bindIndicators[subRangeOffset + 1] & 0xFFFF;
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "initBindsDefinition", "TIMESTAMP case _oacmxl={0}. ", (String)null, (Throwable)null, (Object)_oacmxl);
                    short scale = -1;
                    Binder binder = ((OraclePreparedStatement)this.oracleStatement).currentRowBinders[P];
                    if (binder == null && (binder = ((OraclePreparedStatement)this.oracleStatement).binders[this.oracleStatement.firstRowInBatch][P]) == null && ((OraclePreparedStatement)this.oracleStatement).lastBinders != null) {
                        binder = ((OraclePreparedStatement)this.oracleStatement).lastBinders[P];
                    }
                    if (binder != null) {
                        scale = ((OraclePreparedStatement)this.oracleStatement).getScale(binder);
                    }
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "initBindsDefinition", "TIMESTAMP case scale={0}. ", (String)null, (Throwable)null, (Object)scale);
                    if (isReusableType && oacdefArr[P].oacmxl == _oacmxl && scale != -1 && oacdefArr[P].oacscl == scale) break;
                    boolean wasScaleSet = true;
                    if (scale == -1) {
                        wasScaleSet = false;
                        scale = 9;
                    }
                    if ((number_of_bound_rows = ((this.bindIndicators[this.bindIndicatorSubRange + 3] & 0xFFFF) << 16) + (this.bindIndicators[this.bindIndicatorSubRange + 4] & 0xFFFF)) == 1) {
                        boolean isValueNull;
                        int valueLengthOffset = ((l_bindIndicators[subRangeOffset + 7] & 0xFFFF) << 16) + (l_bindIndicators[subRangeOffset + 8] & 0xFFFF);
                        short valueLength = l_bindIndicators[valueLengthOffset];
                        int nullOffset = ((this.bindIndicators[subRangeOffset + 5] & 0xFFFF) << 16) + (this.bindIndicators[subRangeOffset + 6] & 0xFFFF);
                        boolean bl = isValueNull = l_bindIndicators[nullOffset] == -1;
                        if (!(!isValueNull && valueLength != 7 || wasScaleSet && scale != 0)) {
                            scale = 0;
                        } else if (valueLength == 11) {
                            scale = 9;
                        }
                    }
                    if (isReusableType && oacdefArr[P].oacmxl == _oacmxl && oacdefArr[P].oacscl >= scale) break;
                    needToUpdateDefinition = true;
                    oac.init((short)_oactype, _oacmxl);
                    oac.addFlg2(0x8000000L);
                    oac.setTimestampFractionalSecondsPrecision(scale);
                    break;
                }
                case 182: {
                    _oacmxl = l_bindIndicators[subRangeOffset + 1] & 0xFFFF;
                    if (isReusableType && oacdefArr[P].oacmxl == _oacmxl && oacdefArr[P].oaccsfrm == formOfUse) break;
                    needToUpdateDefinition = true;
                    oac.init((short)_oactype, _oacmxl);
                    oac.setFormOfUse(formOfUse);
                    oac.setCharset(formOfUse == 2 ? this.NCharSet : this.dbCharSet);
                    oac.setPrecision((short)9);
                    oac.addFlg2(0x8000000L);
                    break;
                }
                case 183: {
                    _oacmxl = l_bindIndicators[subRangeOffset + 1] & 0xFFFF;
                    if (isReusableType && oacdefArr[P].oacmxl == _oacmxl && oacdefArr[P].oaccsfrm == formOfUse) break;
                    needToUpdateDefinition = true;
                    oac.init((short)_oactype, _oacmxl);
                    oac.setFormOfUse(formOfUse);
                    oac.setCharset(formOfUse == 2 ? this.NCharSet : this.dbCharSet);
                    oac.setPrecision((short)9);
                    oac.addFlg2(0x8000000L);
                    oac.setScale((short)9);
                    break;
                }
                default: {
                    _oacmxl = l_bindIndicators[subRangeOffset + 1] & 0xFFFF;
                    if (_oacmxl == 0) {
                        _oacmxl = l_bindIndicators[subRangeOffset + 2] & 0xFFFF;
                        if (_oactype == 996) {
                            _oacmxl *= 2;
                        } else if (_oacmxl > 1) {
                            --_oacmxl;
                        }
                        if (formOfUse == 2) {
                            _oacmxl *= this.conversion.maxNCharSize;
                        }
                        if (isReusableType && oacdefArr[P].oacmxl == _oacmxl && oacdefArr[P].oaccsfrm == formOfUse) break;
                        needToUpdateDefinition = true;
                        if (this.typeOfStatement == OracleStatement.SqlKind.PLSQL_BLOCK || this.connection.versionNumber >= 10200 && this.typeOfStatement == OracleStatement.SqlKind.CALL_BLOCK) {
                            _oacmxl = _oacmxl == 0 ? this.connection.maxVcsBytesPlsql : (_oacmxl *= this.conversion.sMaxCharSize);
                        } else if (this.typeOfStatement == OracleStatement.SqlKind.CALL_BLOCK) {
                            if (_oacmxl < 4001) {
                                _oacmxl = 4001;
                            }
                        } else if (formOfUse != 2) {
                            int t4MaxLength = this.connection.maxVarcharLength;
                            _oacmxl = ((T4CConnection)this.oracleStatement.connection).retainV9BindBehavior && _oacmxl <= t4MaxLength ? Math.min(_oacmxl * this.conversion.sMaxCharSize, t4MaxLength) : (_oacmxl *= this.conversion.sMaxCharSize);
                        }
                        if (_oacmxl == 0 && this.bindUseDBA && this.bindDataLengths[P] > 0) {
                            _oacmxl = this.bindDataLengths[P];
                        }
                        if (_oacmxl == 0) {
                            _oacmxl = 32;
                        }
                    } else {
                        if (isReusableType && oacdefArr[P].oacmxl == _oacmxl && oacdefArr[P].oaccsfrm == formOfUse) break;
                        needToUpdateDefinition = true;
                    }
                    oac.init((short)_oactype, _oacmxl);
                    oac.setFormOfUse(formOfUse);
                    oac.setCharset(formOfUse == 2 ? this.NCharSet : this.dbCharSet);
                }
            }
            if (this.oracleStatement.parameterMaxLength == null || this.oracleStatement.parameterMaxLength[P] <= _oacmxl) continue;
            oac.init((short)_oactype, this.oracleStatement.parameterMaxLength[P]);
            needToUpdateDefinition = true;
        }
        if (this.oracleStatement.parameterMaxLength != null) {
            this.oracleStatement.parameterMaxLength = null;
        }
        if (needToUpdateDefinition) {
            this.oracleStatement.nbPostPonedColumns[0] = 0;
        }
        return needToUpdateDefinition;
    }

    void initDefinesDefinition() throws SQLException, IOException {
        this.defCols = 0;
        for (int i = 0; i < this.definedColumnType.length && this.definedColumnType[i] != 0; ++i) {
            ++this.defCols;
        }
        this.oacdefDefines = new T4CTTIoac[this.defCols];
        long flg2 = 0L;
        int maxLength = 0;
        int oacmxlc = 0;
        short internalType = 0;
        for (int i = 0; i < this.oacdefDefines.length; ++i) {
            this.oacdefDefines[i] = new T4CTTIoac(this.connection);
            internalType = (short)this.oracleStatement.getInternalType(this.definedColumnType[i]);
            maxLength = Integer.MAX_VALUE;
            flg2 = 0L;
            oacmxlc = 0;
            short formOfUse = 1;
            if (this.definedColumnFormOfUse != null && this.definedColumnFormOfUse.length > i && this.definedColumnFormOfUse[i] == 2) {
                formOfUse = 2;
            }
            if (internalType == 8) {
                internalType = 1;
            } else if (internalType == 24) {
                internalType = (short)23;
            } else if (internalType == 1 || internalType == 96) {
                internalType = 1;
                maxLength = this.connection.maxVarcharLength * this.conversion.sMaxCharSize;
                if (this.definedColumnSize != null && this.definedColumnSize.length > i && this.definedColumnSize[i] > 0) {
                    maxLength = this.definedColumnSize[i] * this.conversion.sMaxCharSize;
                }
            } else if (this.connection.useLobPrefetch && (internalType == 113 || internalType == 112 || internalType == 114 || internalType == 119)) {
                maxLength = 0;
                flg2 = 0x2000000L;
                if (this.connection.sendAllDataForValueLobs) {
                    flg2 |= 0x800000000L;
                }
                if (this.definedColumnSize != null && this.definedColumnSize.length > i && this.definedColumnSize[i] > 0) {
                    oacmxlc = this.definedColumnSize[i];
                }
            } else if (internalType == 23) {
                maxLength = this.connection.maxRawLength;
            }
            this.oacdefDefines[i].init(internalType, maxLength);
            this.oacdefDefines[i].addFlg2(flg2);
            this.oacdefDefines[i].setMxlc(oacmxlc);
            this.oacdefDefines[i].setFormOfUse(formOfUse);
            this.oacdefDefines[i].setCharset(formOfUse == 2 ? this.NCharSet : this.dbCharSet);
        }
    }

    void marshalBindsTypes(T4CTTIoac[] oac) throws IOException {
        if (oac == null) {
            return;
        }
        for (int i = 0; i < oac.length; ++i) {
            oac[i].marshal();
        }
    }

    Vector<IOException> marshalBinds(int[] oacmxlArr, boolean processingSLG) throws IOException {
        boolean sendFirstPostPonedColumnOnly;
        int rowId;
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalBinds", "processingSLG={0}. ", (String)null, (Throwable)null, (Object)processingSLG);
        Vector<IOException> ioExceptionsFromUserStream = null;
        int number_of_bound_rows = ((this.bindIndicators[this.bindIndicatorSubRange + 3] & 0xFFFF) << 16) + (this.bindIndicators[this.bindIndicatorSubRange + 4] & 0xFFFF);
        if (processingSLG) {
            rowId = this.rxh.iterNum;
            sendFirstPostPonedColumnOnly = true;
        } else {
            rowId = 0;
            sendFirstPostPonedColumnOnly = false;
        }
        while (rowId < number_of_bound_rows) {
            int parameterIndex = this.oracleStatement.firstRowInBatch + rowId;
            InputStream[] streamParameters = null;
            if (this.parameterStream != null) {
                streamParameters = this.parameterStream[parameterIndex];
            }
            Vector<IOException> ioExceptionsFromUserStreamForThisRow = this.rxd.marshal(this.bindBytes, this.bindChars, this.bindIndicators, this.bindIndicatorSubRange, this.tmpBindsByteArray, this.conversion, streamParameters, this.ibtBindBytes, this.ibtBindChars, this.ibtBindIndicators, null, rowId, oacmxlArr, this.plsql, this.oracleStatement.returnParamMeta, this.oracleStatement.nbPostPonedColumns, this.oracleStatement.indexOfPostPonedColumn, sendFirstPostPonedColumnOnly, this.bindData, this.bindDataOffsets, this.bindDataLengths, this.bindUseDBA);
            sendFirstPostPonedColumnOnly = false;
            if (ioExceptionsFromUserStreamForThisRow != null) {
                if (ioExceptionsFromUserStream == null) {
                    ioExceptionsFromUserStream = new Vector<IOException>();
                }
                ioExceptionsFromUserStream.addAll(ioExceptionsFromUserStreamForThisRow);
            }
            ++rowId;
        }
        return ioExceptionsFromUserStream;
    }

    long setOptions(boolean doParse, boolean doExecute, boolean doFetch, boolean doDefine, boolean isBatchExecution) throws SQLException {
        block17: {
            long options;
            block19: {
                block18: {
                    block16: {
                        options = 0L;
                        if (!doParse || doExecute || doFetch) break block16;
                        options |= 1L;
                        break block17;
                    }
                    if (!doParse || !doExecute || doFetch) break block18;
                    options = 32801L;
                    if ((this.typeOfStatement == OracleStatement.SqlKind.SELECT || this.typeOfStatement == OracleStatement.SqlKind.SELECT_FOR_UPDATE) && this.oracleStatement.connection.autocommit && this.oracleStatement.connection.commitSelectOnAutocommit) {
                        options |= 0x100L;
                    }
                    break block17;
                }
                if (!doExecute || !doFetch) break block19;
                if (doParse) {
                    options |= 1L;
                }
                switch (this.typeOfStatement) {
                    case SELECT_FOR_UPDATE: 
                    case SELECT: {
                        options |= 0x8060L;
                        break block17;
                    }
                    case PLSQL_BLOCK: 
                    case CALL_BLOCK: {
                        if (this.numberOfBindPositions > 0) {
                            options |= 0x420L | (long)(this.oracleStatement.connection.autocommit ? 256 : 0);
                            if (this.sendBindsDefinition) {
                                options |= 8L;
                            }
                        } else {
                            options |= 0x20L | (long)(this.oracleStatement.connection.autocommit ? 256 : 0);
                        }
                        break block17;
                    }
                    case DELETE: 
                    case INSERT: 
                    case MERGE: 
                    case UPDATE: 
                    case ALTER_SESSION: 
                    case OTHER: {
                        options = this.oracleStatement.isDmlReturning ? (options |= 0x420L | (long)(this.oracleStatement.connection.autocommit ? 256 : 0)) : (options |= 0x8020L | (long)(this.oracleStatement.connection.autocommit ? 256 : 0));
                        break block17;
                    }
                    default: {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 432).fillInStackTrace();
                    }
                }
            }
            if (!doParse && !doExecute && doFetch) {
                options = 32832L;
            } else {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 432).fillInStackTrace();
            }
        }
        if (!this.typeOfStatement.isPlsqlOrCall()) {
            if ((doParse || doExecute || !doFetch) && this.numberOfBindPositions > 0 && this.sendBindsDefinition) {
                options |= 8L;
            }
            if (this.connection.versionNumber >= 9000 && doDefine && this.typeOfStatement.isSELECT()) {
                options |= 0x10L;
            }
        }
        if (isBatchExecution && this.connection.continueBatchOnError) {
            options |= 0x80000L;
        }
        return options &= 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }

    @Override
    protected Pipeline.IoTask decorateIoTask(Pipeline.IoTask ioTask) {
        return new CursorLimitTask(ioTask);
    }

    private final class CursorLimitTask
    extends Pipeline.IoTaskDecorator {
        private boolean isCursorCountIncreased;

        private CursorLimitTask(Pipeline.IoTask decoratedTask) {
            super(decoratedTask);
            this.isCursorCountIncreased = false;
        }

        @Override
        public Pipeline.IoStatus send() throws Exception {
            T4C8Oall.this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "send", "Sending OALL8 asyncCursorCount={0}, asyncCursorLimit={1}. ", (String)null, (Throwable)null, (Object)T4C8Oall.this.connection.asyncCursorCount(), (Object)T4C8Oall.this.connection.asyncCursorLimit());
            if (T4C8Oall.this.cursor == 0 && T4C8Oall.this.connection.asyncCursorCount() >= T4C8Oall.this.connection.asyncCursorLimit()) {
                T4C8Oall.this.connection.pipeline().yield();
                return Pipeline.IoStatus.PENDING_SEND;
            }
            Pipeline.IoStatus status = super.send();
            if (status != Pipeline.IoStatus.PENDING_SEND && T4C8Oall.this.cursor == 0 && !this.isCursorCountIncreased) {
                T4C8Oall.this.connection.incrementAsyncCursorCount();
                this.isCursorCountIncreased = true;
            }
            return status;
        }

        @Override
        public void complete(Throwable error) {
            if (this.isCursorCountIncreased) {
                T4C8Oall.this.connection.decrementAsyncCursorCount();
                this.isCursorCountIncreased = false;
                T4C8Oall.this.connection.pipeline().go();
            }
            super.complete(error);
        }

        @Override
        public String toString() {
            return "[this = " + super.toString() + ", sql = " + (T4C8Oall.this.oracleStatement == null || T4C8Oall.this.oracleStatement.sqlObject == null ? "" : T4C8Oall.this.oracleStatement.sqlObject) + "]";
        }
    }
}

