/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.receipts;

import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.MessageWithBodiesFilter;
import org.jivesoftware.smack.filter.NotFilter;
import org.jivesoftware.smack.filter.StanzaExtensionFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.receipts.DeliveryReceipt;
import org.jivesoftware.smackx.receipts.DeliveryReceiptRequest;
import org.jivesoftware.smackx.receipts.ReceiptReceivedListener;
import org.jxmpp.jid.Jid;

public final class DeliveryReceiptManager
extends Manager {
    private static final StanzaFilter NON_ERROR_GROUPCHAT_MESSAGES_WITH_DELIVERY_RECEIPT_REQUEST = new AndFilter(StanzaTypeFilter.MESSAGE, new StanzaExtensionFilter(new DeliveryReceiptRequest()), new NotFilter(MessageTypeFilter.ERROR));
    private static final StanzaFilter MESSAGES_WITH_DELIVERY_RECEIPT = new AndFilter(StanzaTypeFilter.MESSAGE, new StanzaExtensionFilter("received", "urn:xmpp:receipts"));
    private static final Logger LOGGER = Logger.getLogger(DeliveryReceiptManager.class.getName());
    private static final Map<XMPPConnection, DeliveryReceiptManager> instances = new WeakHashMap<XMPPConnection, DeliveryReceiptManager>();
    private static AutoReceiptMode defaultAutoReceiptMode;
    private AutoReceiptMode autoReceiptMode = defaultAutoReceiptMode;
    private final Set<ReceiptReceivedListener> receiptReceivedListeners = new CopyOnWriteArraySet<ReceiptReceivedListener>();
    private static final StanzaFilter MESSAGES_TO_REQUEST_RECEIPTS_FOR;

    public static void setDefaultAutoReceiptMode(AutoReceiptMode autoReceiptMode) {
        defaultAutoReceiptMode = autoReceiptMode;
    }

    private DeliveryReceiptManager(XMPPConnection connection) {
        super(connection);
        ServiceDiscoveryManager sdm = ServiceDiscoveryManager.getInstanceFor(connection);
        sdm.addFeature("urn:xmpp:receipts");
        connection.addAsyncStanzaListener(new StanzaListener(){

            @Override
            public void processStanza(Stanza packet) throws SmackException.NotConnectedException {
                DeliveryReceipt dr = DeliveryReceipt.from((Message)packet);
                for (ReceiptReceivedListener l : DeliveryReceiptManager.this.receiptReceivedListeners) {
                    l.onReceiptReceived(packet.getFrom(), packet.getTo(), dr.getId(), packet);
                }
            }
        }, MESSAGES_WITH_DELIVERY_RECEIPT);
        connection.addAsyncStanzaListener(new StanzaListener(){

            @Override
            public void processStanza(Stanza packet) throws SmackException.NotConnectedException, InterruptedException {
                Jid from = packet.getFrom();
                XMPPConnection connection = DeliveryReceiptManager.this.connection();
                switch (DeliveryReceiptManager.this.autoReceiptMode) {
                    case disabled: {
                        return;
                    }
                    case ifIsSubscribed: {
                        if (Roster.getInstanceFor(connection).isSubscribedToMyPresence(from)) break;
                        return;
                    }
                }
                Message messageWithReceiptRequest = (Message)packet;
                Message ack = DeliveryReceiptManager.receiptMessageFor(messageWithReceiptRequest);
                if (ack == null) {
                    LOGGER.warning("Received message stanza with receipt request from '" + from + "' without a stanza ID set. Message: " + messageWithReceiptRequest);
                    return;
                }
                connection.sendStanza(ack);
            }
        }, NON_ERROR_GROUPCHAT_MESSAGES_WITH_DELIVERY_RECEIPT_REQUEST);
    }

    public static synchronized DeliveryReceiptManager getInstanceFor(XMPPConnection connection) {
        DeliveryReceiptManager receiptManager = instances.get(connection);
        if (receiptManager == null) {
            receiptManager = new DeliveryReceiptManager(connection);
            instances.put(connection, receiptManager);
        }
        return receiptManager;
    }

    public boolean isSupported(Jid jid) throws SmackException, XMPPException, InterruptedException {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).supportsFeature(jid, "urn:xmpp:receipts");
    }

    public void setAutoReceiptMode(AutoReceiptMode autoReceiptMode) {
        this.autoReceiptMode = autoReceiptMode;
    }

    public AutoReceiptMode getAutoReceiptMode() {
        return this.autoReceiptMode;
    }

    public void addReceiptReceivedListener(ReceiptReceivedListener listener) {
        this.receiptReceivedListeners.add(listener);
    }

    public void removeReceiptReceivedListener(ReceiptReceivedListener listener) {
        this.receiptReceivedListeners.remove(listener);
    }

    public void autoAddDeliveryReceiptRequests() {
        this.connection().addMessageInterceptor(DeliveryReceiptRequest::addTo, m3 -> MESSAGES_TO_REQUEST_RECEIPTS_FOR.accept((Stanza)m3));
    }

    public void dontAutoAddDeliveryReceiptRequests() {
        this.connection().removeMessageInterceptor(DeliveryReceiptRequest::addTo);
    }

    public static boolean hasDeliveryReceiptRequest(Message message) {
        return DeliveryReceiptRequest.from(message) != null;
    }

    @Deprecated
    public static String addDeliveryReceiptRequest(Message m3) {
        return DeliveryReceiptRequest.addTo(m3);
    }

    public static Message receiptMessageFor(Message messageWithReceiptRequest) {
        String stanzaId = messageWithReceiptRequest.getStanzaId();
        if (StringUtils.isNullOrEmpty((CharSequence)stanzaId)) {
            return null;
        }
        Message message = ((MessageBuilder)((MessageBuilder)StanzaBuilder.buildMessage().ofType(messageWithReceiptRequest.getType()).to(messageWithReceiptRequest.getFrom())).addExtension(new DeliveryReceipt(stanzaId))).build();
        return message;
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(XMPPConnection connection) {
                DeliveryReceiptManager.getInstanceFor(connection);
            }
        });
        defaultAutoReceiptMode = AutoReceiptMode.ifIsSubscribed;
        MESSAGES_TO_REQUEST_RECEIPTS_FOR = new AndFilter(MessageTypeFilter.NORMAL_OR_CHAT_OR_HEADLINE, new NotFilter(new StanzaExtensionFilter("received", "urn:xmpp:receipts")), MessageWithBodiesFilter.INSTANCE);
    }

    public static enum AutoReceiptMode {
        disabled,
        ifIsSubscribed,
        always;

    }
}

